/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.CircleSeg;
import algoanim.primitives.generators.Language;
import algoanim.properties.CircleSegProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTClosedCircleSegment;
import animal.graphics.PTGraphicObject;

public class PTClosedCircleSegmentExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTClosedCircleSegment shape = (PTClosedCircleSegment)ptgo;
        if (PTClosedCircleSegmentExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates center = Node.convertToNode(shape.getCenter());
        CircleSegProperties cp = new CircleSegProperties();
        this.installStandardProperties(cp, shape, isVisible);
        cp.set("angle", shape.getTotalAngle());
        cp.set("startAngle", shape.getStartAngle());
        cp.set("clockwise", shape.isClockwise());
        cp.set("counterclockwise", !shape.isClockwise());
        cp.set("closed", true);
        cp.set("fwArrow", false);
        cp.set("bwArrow", false);
        cp.set("filled", shape.isFilled());
        if (shape.isFilled()) {
            cp.set("fillColor", shape.getFillColor());
        }
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        CircleSeg result = lang.newCircleSeg(center, shape.getRadius(), shape.getObjectName(), t, cp);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

