/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.Circle;
import algoanim.primitives.generators.Language;
import algoanim.properties.CircleProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTCircle;
import animal.graphics.PTGraphicObject;

public class PTCircleExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTCircle shape = (PTCircle)ptgo;
        if (PTCircleExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates center = Node.convertToNode(shape.getCenter());
        CircleProperties cp = new CircleProperties();
        this.installStandardProperties(cp, shape, isVisible);
        cp.set("filled", shape.isFilled());
        if (shape.isFilled()) {
            cp.set("fillColor", shape.getFillColor());
        }
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        Circle result = lang.newCircle(center, shape.getRadius(), shape.getObjectName(), t, cp);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

