/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTRectangle;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.awt.Point;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTRectangleImporter
extends PTGraphicObjectImporter {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        PTRectangle shape = new PTRectangle();
        try {
            shape.setStartNode(ParseSupport.parseNode(stok, "Rectangle node"));
            ParseSupport.parseMandatoryWord(stok, "Rectangle keyword 'size'", "size");
            Point sizePoint = ParseSupport.parseNode(stok, "Rectangle node");
            if (sizePoint == null) {
                sizePoint = new Point(0, 0);
            }
            shape.setWidth(sizePoint.x);
            shape.setHeight(sizePoint.y);
            shape.setColor(ParseSupport.parseColor(stok, "Rectangle color", "color"));
            this.parseFillAttributes(stok, shape, "Rectangle");
            this.parseEndingValuesFrom(stok, shape, "Rectangle");
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return shape;
    }
}

