/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.Exporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.meta.FillablePrimitive;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;

public class PTGraphicObjectExporter
implements Exporter {
    public void exportTo(PrintWriter pw, PTGraphicObject ptgo) {
        pw.println("Undefined primitive: " + this.getClass().getName() + " for " + ptgo);
    }

    public void exportColor(PrintWriter pw, Color color) {
        this.exportColor(pw, color, "color");
    }

    public void exportColor(PrintWriter pw, Color color, String key) {
        pw.print(key);
        pw.print(" (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") ");
    }

    public void exportCommonEndAttributesTo(PrintWriter pw, PTGraphicObject shape) {
        pw.print("depth ");
        pw.print(shape.getDepth());
        if (shape.getObjectName() != null) {
            pw.print(" name \"");
            pw.print(shape.getObjectName());
            pw.println("\"");
        }
    }

    public void exportCommonStartAttributesTo(PrintWriter pw, PTGraphicObject shape) {
        pw.print(shape.getFileVersion());
        pw.print(" object ");
        pw.print(shape.getNum(false));
        pw.print(" ");
        pw.print(shape.getType());
        pw.print(' ');
    }

    public void exportFillSettings(PrintWriter pw, FillablePrimitive shape) {
        if (shape.isFilled()) {
            pw.print("filled ");
            this.exportColor(pw, shape.getFillColor(), "fillColor");
        }
    }

    public void exportNode(PrintWriter pw, Point node) {
        pw.print("(");
        pw.print(node.x);
        pw.print(",");
        pw.print(node.y);
        pw.print(") ");
    }

    public void exportNode(PrintWriter pw, PTPoint node) {
        if (node != null) {
            this.exportNode(pw, node.toPoint());
        }
    }

    public void exportNode(PrintWriter pw, Point node, String key) {
        pw.print(key);
        pw.print(' ');
        this.exportNode(pw, node);
    }

    public void exportNode(PrintWriter pw, PTPoint node, String key) {
        pw.print(key);
        pw.print(' ');
        this.exportNode(pw, node);
    }
}

