/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PTGraph;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.PrintWriter;

public class PTGraphExporter
extends PTGraphicObjectExporter {
    @Override
    public void exportTo(PrintWriter pw, PTGraphicObject ptgo) {
        PTGraph graph = (PTGraph)ptgo;
        pw.print(graph.getFileVersion());
        pw.print(" object ");
        pw.print(graph.getNum(false));
        pw.print(" Graph size ");
        pw.print(graph.length);
        pw.print(" origin (");
        Point p = graph.getOrigin();
        pw.print(p.x);
        pw.print(", ");
        pw.print(p.y);
        pw.print(")");
        pw.print(" nodes {");
        int i = 0;
        while (i < graph.length) {
            pw.print("\"");
            pw.print(PTText.escapeText(graph.getValueNode(i)));
            pw.print("\" ");
            Point p1 = graph.getPTTextNode(i).getLocation();
            pw.print("(");
            pw.print(p1.x);
            pw.print(", ");
            pw.print(p1.y);
            pw.print(") ");
            Point p2 = graph.getNode(i).getCenter();
            pw.print("(");
            pw.print(p2.x);
            pw.print(", ");
            pw.print(p2.y);
            pw.print(") ");
            pw.print(graph.getNode(i).getRadius());
            if (i < graph.length - 1) {
                pw.print(" ");
            }
            ++i;
        }
        pw.print("} edges {");
        i = 0;
        while (i < graph.length) {
            int j = 0;
            while (j < graph.length) {
                pw.print("\"");
                pw.print(PTText.escapeText(graph.getValueEdge(i, j)));
                pw.print("\"");
                if (i != graph.length - 1 || j < graph.length - 1) {
                    pw.print(" ");
                }
                ++j;
            }
            ++i;
        }
        pw.print("} ");
        Font nodeFont = graph.getNodeFont();
        pw.print("nodeFont (");
        pw.print(nodeFont.getName());
        pw.print(", ");
        pw.print(nodeFont.getSize());
        pw.print(") ");
        Font edgeFont = graph.getEdgeFont();
        pw.print("edgeFont (");
        pw.print(edgeFont.getName());
        pw.print(", ");
        pw.print(edgeFont.getSize());
        pw.print(") ");
        Color color = graph.getBGColor();
        pw.print("bgColor (");
        pw.print(color.getRed());
        pw.print(", ");
        pw.print(color.getGreen());
        pw.print(", ");
        pw.print(color.getBlue());
        pw.print(") ");
        color = graph.getNodeFontColor();
        pw.print("nodeFontColor (");
        pw.print(color.getRed());
        pw.print(", ");
        pw.print(color.getGreen());
        pw.print(", ");
        pw.print(color.getBlue());
        pw.print(") ");
        color = graph.getEdgeFontColor();
        pw.print("edgeFontColor (");
        pw.print(color.getRed());
        pw.print(", ");
        pw.print(color.getGreen());
        pw.print(", ");
        pw.print(color.getBlue());
        pw.print(") ");
        color = graph.getOutlineColor();
        pw.print("outlineColor (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") ");
        color = graph.getHighlightColor();
        pw.print("highlightColor (");
        pw.print(color.getRed());
        pw.print(", ");
        pw.print(color.getGreen());
        pw.print(", ");
        pw.print(color.getBlue());
        pw.print(") ");
        color = graph.getElemHighlightColor();
        pw.print("elementHighlightColor (");
        pw.print(color.getRed());
        pw.print(", ");
        pw.print(color.getGreen());
        pw.print(", ");
        pw.print(color.getBlue());
        pw.print(")");
        if (graph.hasDirection()) {
            pw.print(" direction");
        }
        if (graph.hasWeight()) {
            pw.print(" weight");
        }
        if (graph.indicesShown()) {
            pw.print(" showIndices");
        }
        pw.print(" depth ");
        pw.println(graph.getDepth());
    }
}

