/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.misc.MessageDisplay;
import translator.AnimalTranslator;

public class AnimationConverter {
    private AnimalConfiguration animalConfig;
    private Animal animalInstance;

    public AnimationConverter() {
        if (this.animalInstance == null) {
            this.animalInstance = Animal.get();
            this.animalInstance.setAutoloadLastFile(false);
        }
        if (this.animalConfig == null) {
            this.animalConfig = new AnimalConfiguration();
        }
        new AnimalMainWindow(this.animalInstance, this.animalConfig.getProperties(), false, true);
        this.animalConfig.initializeImportFormats();
        this.animalConfig.initializeExportFormats();
        this.animalConfig.initializeAllEditors();
    }

    public boolean convert(String inputFormat, String outputFormat, String filename) {
        return this.convert(inputFormat, outputFormat, filename, filename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean convert(String inputFormat, String outputFormat, String inputFilename, String outputFilename) {
        Animation targetAnimation;
        long animationTimer = System.currentTimeMillis();
        AnimationImporter importer = null;
        AnimationExporter exporter = null;
        int lastDotPosition = inputFilename.lastIndexOf(46);
        String targetFileName = outputFilename;
        importer = AnimationImporter.getImporterFor(inputFormat);
        String effectiveInputFilename = inputFilename;
        String effectiveOutputFilename = outputFilename;
        if (importer == null) return false;
        exporter = AnimationExporter.getExporterFor(outputFormat);
        if (exporter == null) return false;
        if (lastDotPosition == -1) {
            effectiveInputFilename = String.valueOf(effectiveInputFilename) + "." + importer.getDefaultExtension();
        }
        if ((targetAnimation = importer.importAnimationFrom(effectiveInputFilename)) == null) return false;
        lastDotPosition = effectiveOutputFilename.lastIndexOf(46);
        if (lastDotPosition != -1) {
            effectiveOutputFilename = effectiveOutputFilename.substring(0, lastDotPosition);
        }
        targetFileName = String.valueOf(effectiveOutputFilename) + "." + exporter.getDefaultExtension();
        exporter.setFilename(effectiveOutputFilename);
        MessageDisplay.message("writingToFile ", new String[]{targetFileName});
        exporter.setAnimation(targetAnimation);
        exporter.chooseExportMode();
        MessageDisplay.message("timeTaken", new String[]{String.valueOf(System.currentTimeMillis() - animationTimer)});
        return true;
    }

    public static void main(String[] args) {
        AnimationConverter converter = new AnimationConverter();
        if (args.length < 3) {
            MessageDisplay.message(AnimalTranslator.translateMessage("animConvUsage"));
        } else if (args.length == 3) {
            converter.convert(args[0], args[1], args[2]);
        } else {
            converter.convert(args[0], args[1], args[2], args[3]);
        }
    }
}

