/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.AnimationImporter;
import animal.main.Animal;
import animal.main.Animation;
import animalscript.core.AnimalScriptParser;
import java.io.InputStream;
import translator.AnimalTranslator;

public class AnimalScriptImporter
extends AnimationImporter {
    private boolean isCompressed = false;
    public StringBuilder fileContents = null;

    @Override
    public void init(String format) {
        super.init(format);
        this.isCompressed = format.endsWith("-compressed");
    }

    @Override
    public Animation importAnimationFrom(String filename) {
        AnimalScriptParser animalScriptParser = Animal.getAnimalScriptParser(true);
        animalScriptParser.setCompressed(this.isCompressed);
        Animation anim = animalScriptParser.programImport(filename, !filename.startsWith("%"));
        this.fileContents = AnimalScriptParser.fileContents;
        Animal.get().setAnimalScriptCode(this.fileContents.toString());
        return anim;
    }

    @Override
    public Animation importAnimationFrom(InputStream in, String filename) {
        AnimalScriptParser animalScriptParser = Animal.getAnimalScriptParser(true);
        animalScriptParser.setCompressed(this.isCompressed);
        Animation anim = animalScriptParser.importAnimationFrom(in, filename, true);
        this.fileContents = AnimalScriptParser.fileContents;
        Animal.get().setAnimalScriptCode(this.fileContents.toString());
        return anim;
    }

    @Override
    public String getDefaultExtension() {
        return this.isCompressed ? "asc" : "asu";
    }

    @Override
    public String getFormatDescription() {
        return this.toString();
    }

    @Override
    public String getMIMEType() {
        return "animation/animalscript" + (this.isCompressed ? "-compressed" : "");
    }

    @Override
    public String toString() {
        return AnimalTranslator.translateMessage("animalScriptImportDescription");
    }
}

