/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.properties;

import animal.editor.properties.PropertyEditor;
import animal.main.PropertiedObject;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class BooleanPropertyEditor
extends PropertyEditor
implements ActionListener {
    JCheckBox checkBox;

    public BooleanPropertyEditor(String type, XProperties properties) {
        super(type, properties);
    }

    @Override
    public void addEditorTo(Container container) {
        String label = this.getProperties().getProperty("param0");
        String property = this.getProperties().getProperty("property");
        JLabel myLabel = new JLabel(label, 2);
        PropertiedObject ptgo = this.target;
        boolean isActive = ptgo.getProperties().getBoolProperty(property);
        this.checkBox = new JCheckBox(label);
        this.checkBox.addActionListener(this);
        this.checkBox.setSelected(isActive);
        container.add(myLabel);
        container.add(this.checkBox);
    }

    @Override
    public void storeProperty() {
        PropertiedObject targetObject = this.getTargetObject();
        String propertyToChange = this.getProperties().getProperty("property");
        targetObject.getProperties().put(propertyToChange, this.checkBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PropertiedObject targetObject = this.getTargetObject();
        if (targetObject != null && targetObject.getProperties() != null) {
            this.storeProperty();
        } else {
            MessageDisplay.errorMsg("objectOrPropertyNullException", new Object[]{"actionPerformed", this.getClass().getName()});
        }
    }
}

