/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.OrientedArcBasedShapeEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTOpenCircleSegment;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class OpenCircleSegmentEditor
extends OrientedArcBasedShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private JCheckBox fwArrowBox;
    private JCheckBox bwArrowBox;
    private static final long serialVersionUID = -2413776784253970663L;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonOpenArcElements(generator);
        this.addBox(contentBox);
        Box optionsBox = generator.generateBorderedBox(3, "OpenCircleSegmentEditor.ocProps");
        Box arrowsBox = new Box(3);
        this.fwArrowBox = generator.generateJCheckBox("ArrowableShapeEditor.fwArrow", null, this);
        this.fwArrowBox.addItemListener(this);
        arrowsBox.add(this.fwArrowBox);
        this.bwArrowBox = generator.generateJCheckBox("ArrowableShapeEditor.bwArrow", null, this);
        this.bwArrowBox.addItemListener(this);
        arrowsBox.add(this.bwArrowBox);
        optionsBox.add(arrowsBox);
        this.clockwise = generator.generateJCheckBox("ArcBasedShapeEditor.clockwise", null, this);
        this.clockwise.addItemListener(this);
        optionsBox.add(this.clockwise);
        this.addBox(optionsBox);
        this.finishBoxes();
    }

    @Override
    public int pointsNeeded() {
        return 4;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTOpenCircleSegment shape = (PTOpenCircleSegment)this.getCurrentObject();
        switch (num) {
            case 1: {
                shape.setCenter(p.x, p.y);
                break;
            }
            case 2: {
                shape.setRadius(p.x - shape.getCenter().x);
                break;
            }
            case 3: {
                shape.setStartAngle(shape.getAngle(p));
                break;
            }
            case 4: {
                int angle = shape.getAngle(p) - shape.getStartAngle();
                if (angle <= 0) {
                    angle += 360;
                }
                shape.setTotalAngle(angle);
                shape.setFWArrow(this.fwArrowBox.isSelected());
                shape.setBWArrow(this.bwArrowBox.isSelected());
            }
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        PTOpenCircleSegment pg = (PTOpenCircleSegment)go;
        Point a = new Point(pg.getCenter().x, pg.getCenter().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getRadius(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getRadius(), pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getCenter())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTOpenCircleSegment pg = (PTOpenCircleSegment)go;
        EditPoint[] result = new EditPoint[7];
        int x = pg.getCenter().x;
        int rx = pg.getRadius();
        int y = pg.getCenter().y;
        int ry = pg.getRadius();
        int nr = 0;
        result[nr++] = new EditPoint(2, new Point(x + rx, y + ry));
        result[nr++] = new EditPoint(3, pg.getPointAtLength(pg.getStartAngle()));
        result[nr++] = new EditPoint(4, pg.getPointAtLength(pg.getStartAngle() + pg.getTotalAngle()));
        result[nr++] = new EditPoint(-1, new Point(x - rx, y));
        result[nr++] = new EditPoint(-2, new Point(x, y + ry));
        result[nr++] = new EditPoint(-3, new Point(x + rx, y));
        result[nr++] = new EditPoint(-4, new Point(x, y - ry));
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("OpenCircleSegment.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("OpenCircleSegment.depth", "16"));
        this.bwArrowBox.setSelected(props.getBoolProperty("OpenCircleSegment.bwArrow", false));
        this.fwArrowBox.setSelected(props.getBoolProperty("OpenCircleSegment.fwArrow", false));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("OpenCircleSegment.color", this.colorChooser.getColor());
        props.put((Object)"OpenCircleSegment.depth", this.depthBox.getSelectedItem());
        props.put("OpenCircleSegment.bwArrow", this.bwArrowBox.isSelected());
        props.put("OpenCircleSegment.fwArrow", this.fwArrowBox.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTOpenCircleSegment p = (PTOpenCircleSegment)this.getCurrentObject();
        if (e.getSource() == this.clockwise) {
            p.setClockwise(this.clockwise.isSelected());
        }
        if (e.getSource() == this.bwArrowBox) {
            p.setBWArrow(this.bwArrowBox.isSelected());
        }
        if (e.getSource() == this.fwArrowBox) {
            p.setFWArrow(this.fwArrowBox.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    @Override
    public EditableObject createObject() {
        PTOpenCircleSegment pg = new PTOpenCircleSegment();
        this.storeAttributesInto(pg);
        return pg;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTOpenCircleSegment p = (PTOpenCircleSegment)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFWArrow(this.fwArrowBox.isSelected());
        p.setBWArrow(this.bwArrowBox.isSelected());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTOpenCircleSegment p = (PTOpenCircleSegment)eo;
        this.colorChooser.setColor(p.getColor());
        this.bwArrowBox.setSelected(p.hasBWArrow());
        this.fwArrowBox.setSelected(p.hasFWArrow());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        OpenCircleSegmentEditor result = new OpenCircleSegmentEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("OpenCircleSegmentEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTOpenCircleSegment p = (PTOpenCircleSegment)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTOpenCircleSegment poly = (PTOpenCircleSegment)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "OpenCircleSegment";
    }
}

