/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.AbstractTextEditor;
import animal.graphics.PTArc;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.gui.DrawCanvas;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class ArcEditor
extends AbstractTextEditor
implements ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3323874737657161500L;
    private ColorChooserAction colorChooser;
    private ColorChooserAction fillColorChooser;
    private ExtendedActionButton fillColorChooserButton;
    private JCheckBox isCircle;
    private JCheckBox isFilled;
    private JCheckBox isClosed;
    private JCheckBox orientationIsClockwise;
    private boolean isItalic;
    private boolean isBold;
    private JCheckBox hasFwArrow;
    private JCheckBox hasBwArrow;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box colorBox = generator.generateBorderedBox(3, "GenericEditor.colorBL");
        Box firstRowBox = new Box(2);
        firstRowBox.add(generator.generateJLabel("GenericEditor.colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTText)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("ArcEditor.lineColor")}), initialColor);
        firstRowBox.add(new ExtendedActionButton(this.colorChooser, 67));
        colorBox.add(firstRowBox);
        Box secondRowBox = new Box(2);
        secondRowBox.add(generator.generateJLabel("GenericEditor.fillColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTArc)this.getCurrentObject()).getFillColor();
        this.fillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "fillColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("GenericEditor.fillColor")}), initialColor);
        this.fillColorChooserButton = new ExtendedActionButton(this.fillColorChooser, 70);
        secondRowBox.add(this.fillColorChooserButton);
        colorBox.add(secondRowBox);
        this.addBox(colorBox);
        this.isCircle = new JCheckBox(AnimalTranslator.translateMessage("ArcEditor.circle"));
        this.isCircle.addActionListener(this);
        this.isFilled = new JCheckBox(AnimalTranslator.translateMessage("GenericEditor.filled"));
        this.isFilled.addItemListener(this);
        this.isClosed = new JCheckBox(AnimalTranslator.translateMessage("ArcEditor.closed"));
        this.isClosed.addItemListener(this);
        this.orientationIsClockwise = new JCheckBox(AnimalTranslator.translateMessage("ArcBasedShapeEditor.clockwise"));
        this.orientationIsClockwise.addActionListener(this);
        this.hasFwArrow = new JCheckBox(AnimalTranslator.translateMessage("ArrowableShapeEditor.fwArrow"));
        this.hasFwArrow.addItemListener(this);
        this.hasBwArrow = new JCheckBox(AnimalTranslator.translateMessage("ArrowableShapeEditor.bwArrow"));
        this.hasBwArrow.addItemListener(this);
        Box arcPropertiesBox = generator.generateBorderedBox(3, "ArcEditor.arcPropsBL");
        Box closedFilledBox = new Box(2);
        closedFilledBox.add(this.isClosed);
        closedFilledBox.add(this.isFilled);
        Box circleClockwiseBox = new Box(2);
        circleClockwiseBox.add(this.isCircle);
        circleClockwiseBox.add(this.orientationIsClockwise);
        Box arrowModeBox = new Box(2);
        arrowModeBox.add(this.hasFwArrow);
        arrowModeBox.add(this.hasBwArrow);
        arcPropertiesBox.add(closedFilledBox);
        arcPropertiesBox.add(circleClockwiseBox);
        arcPropertiesBox.add(arrowModeBox);
        this.addBox(arcPropertiesBox);
        this.addBox(this.generateTextComponentBox(generator));
        this.finishBoxes();
    }

    @Override
    public int pointsNeeded() {
        return 4;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTArc arc = (PTArc)this.getCurrentObject();
        switch (num) {
            case 1: {
                arc.setCenter(p);
                arc.setStartAngle(0);
                arc.setTotalAngle(720);
                break;
            }
            case 2: {
                if (arc.isCircular()) {
                    arc.setRadius(MSMath.dist(arc.getCenter(), p));
                    break;
                }
                int xRadius = Math.abs(p.x - arc.getCenter().x);
                int yRadius = Math.abs(p.y - arc.getCenter().y);
                arc.setRadius(new Point(xRadius, yRadius));
                break;
            }
            case 3: {
                arc.setStartAngle(arc.getAngle(p));
                if (Math.abs(arc.getTotalAngle()) != 720) break;
                arc.setClosed(true);
                arc.setFilled(false);
                break;
            }
            case 4: {
                int angle = arc.getAngle(p) - arc.getStartAngle();
                if (arc.isClockwise()) {
                    angle = -angle;
                }
                if (angle <= 0) {
                    angle += 360;
                }
                arc.setTotalAngle(angle);
                arc.setClosed(this.isClosed.isSelected());
                arc.setFilled(this.isFilled.isSelected());
            }
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        double d;
        PTArc arc = (PTArc)go;
        int angle = arc.getAngle(p);
        Point c = arc.getCenter();
        Point firstPoint = arc.getPointAtAngle(arc.getStartAngle());
        Point secondPoint = arc.getPointAtAngle(arc.getStartAngle() + arc.getTotalAngle());
        int dist = arc.isAngleInside(angle) ? ((d = MSMath.sqr((double)(p.x - c.x) / (double)arc.getXRadius()) + MSMath.sqr((double)(p.y - c.y) / (double)arc.getYRadius())) >= 1.0 ? (int)Math.sqrt((d - 1.0) * 500.0) : (arc.isFilled() ? 0 : (arc.isClosed() ? Math.min((int)Math.sqrt((1.0 - d) * 500.0), Math.min(MSMath.dist(p, firstPoint, c), MSMath.dist(p, secondPoint, c))) : (int)Math.sqrt((1.0 - d) * 500.0)))) : (arc.isFilled() || arc.isClosed() ? Math.min(MSMath.dist(p, firstPoint, c), MSMath.dist(p, secondPoint, c)) : Math.min(MSMath.dist(p, firstPoint), MSMath.dist(p, secondPoint)));
        return dist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTArc arc = (PTArc)go;
        Point c = arc.getCenter();
        if (arc.isCircular()) {
            int r = arc.getRadius();
            return new EditPoint[]{new EditPoint(-1, c), new EditPoint(4, arc.getPointAtAngle(arc.getStartAngle() + arc.getTotalAngle())), new EditPoint(3, arc.getPointAtAngle(arc.getStartAngle())), new EditPoint(2, new Point(c.x - r, c.y)), new EditPoint(2, new Point(c.x + r, c.y)), new EditPoint(2, new Point(c.x, c.y - r)), new EditPoint(2, new Point(c.x, c.y + r))};
        }
        int xr = arc.getXRadius();
        int yr = arc.getYRadius();
        return new EditPoint[]{new EditPoint(-1, c), new EditPoint(2, new Point(c.x - xr, c.y - yr)), new EditPoint(2, new Point(c.x - xr, c.y + yr)), new EditPoint(2, new Point(c.x + xr, c.y - yr)), new EditPoint(2, new Point(c.x + xr, c.y + yr)), new EditPoint(4, arc.getPointAtAngle(arc.getStartAngle() + arc.getTotalAngle())), new EditPoint(3, arc.getPointAtAngle(arc.getStartAngle()))};
    }

    @Override
    public void setProperties(XProperties props) {
        this.bold.setSelected(props.getBoolProperty("Arc.bold"));
        this.hasBwArrow.setSelected(props.getBoolProperty("Arc.bwArrow"));
        this.isCircle.setSelected(props.getBoolProperty("Arc.circle"));
        this.orientationIsClockwise.setSelected(props.getBoolProperty("Arc.clockwise"));
        this.isClosed.setSelected(props.getBoolProperty("Arc.closed"));
        this.colorChooser.setColor(props.getColorProperty("Arc.color", Color.black));
        this.fillColorChooser.setColor(props.getColorProperty("Arc.fillColor", Color.black));
        this.fontName.setSelectedItem(props.getProperty("Arc.fontName", "SansSerif"));
        this.fontSize.setSelectedItem(props.getProperty("Arc.fontSize", "12"));
        this.isFilled.setSelected(props.getBoolProperty("Arc.filled"));
        this.hasFwArrow.setSelected(props.getBoolProperty("Arc.fwArrow"));
        this.italic.setSelected(props.getBoolProperty("Arc.italic"));
        if (this.textField != null) {
            this.textField.setText(props.getProperty("Arc.text"));
        }
        this.textColorChooser.setColor(props.getColorProperty("Arc.textColor", Color.black));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Arc.bold", this.bold.isSelected());
        props.put("Arc.bwArrow", this.hasBwArrow.isSelected());
        props.put("Arc.circle", this.isCircle.isSelected());
        props.put("Arc.clockwise", this.orientationIsClockwise.isSelected());
        props.put("Arc.closed", this.isClosed.isSelected());
        props.put("Arc.color", this.colorChooser.getColor());
        props.put("Arc.fillColor", this.fillColorChooser.getColor());
        props.put("Arc.filled", this.isFilled.isSelected());
        props.put((Object)"Arc.fontName", this.fontName.getSelectedItem());
        props.put((Object)"Arc.fontSize", this.fontSize.getSelectedItem());
        props.put("Arc.fwArrow", this.hasFwArrow.isSelected());
        props.put("Arc.italic", this.italic.isSelected());
        props.put("Arc.text", this.textField.getText());
        props.put("Arc.textColor", this.textColorChooser.getColor());
    }

    @Override
    public EditableObject createObject() {
        PTArc arc = new PTArc();
        this.storeAttributesInto(arc);
        return arc;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTArc arc = (PTArc)eo;
        if (this.textField != null) {
            arc.setText(this.textField.getText());
        } else {
            arc.setText("");
        }
        arc.getTextComponent().setFont(this.storeFont());
        arc.setCircle(this.isCircle.isSelected());
        arc.setFilled(this.isFilled.isSelected());
        arc.setClosed(this.isClosed.isSelected());
        arc.setClockwise(this.orientationIsClockwise.isSelected());
        arc.setFWArrow(this.hasFwArrow.isSelected());
        arc.setBWArrow(this.hasBwArrow.isSelected());
        arc.setColor(this.colorChooser.getColor());
        arc.setFillColor(this.fillColorChooser.getColor());
        arc.setTextColor(this.textColorChooser.getColor());
        PTText textCompo = arc.getTextComponent();
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        Font targetFont = new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
        textCompo.setFont(targetFont);
        int width = 10;
        if (this.textField != null) {
            width = Animal.getStringWidth(this.textField.getText(), targetFont);
        }
        textCompo.setPosition(arc.getCenter().x - width / 2, arc.getCenter().y + targetFont.getSize() / 2);
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTArc arc = (PTArc)eo;
        this.textField.setText(arc.getTextComponent().getText());
        this.extractFont(arc.getTextComponent().getFont());
        this.isCircle.setSelected(arc.isCircular());
        this.isFilled.setSelected(arc.isFilled());
        this.isClosed.setSelected(arc.isClosed());
        this.orientationIsClockwise.setSelected(arc.isClockwise());
        this.hasFwArrow.setSelected(arc.hasFWArrow());
        this.hasBwArrow.setSelected(arc.hasBWArrow());
        this.colorChooser.setColor(arc.getColor());
        this.fillColorChooser.setColor(arc.getFillColor());
        this.textColorChooser.setColor(arc.getTextComponent().getColor());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        ArcEditor result = new ArcEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("ArcEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTArc arc = (PTArc)this.getCurrentObject();
        if (arc != null) {
            if (e.getSource() == this.isClosed) {
                this.isFilled.setEnabled(this.isClosed.isSelected());
                this.hasFwArrow.setEnabled(!this.isClosed.isSelected());
                this.hasBwArrow.setEnabled(!this.isClosed.isSelected());
                arc.setClosed(this.isClosed.isSelected());
            }
            if (!this.isClosed.isSelected()) {
                arc.setFilled(false);
            } else {
                arc.setFilled(this.isFilled.isSelected());
            }
            if (e.getSource() == this.isFilled) {
                arc.setFilled(this.isFilled.isSelected());
            }
            if (e.getSource() == this.hasFwArrow) {
                arc.setFWArrow(this.hasFwArrow.isSelected());
            }
            if (e.getSource() == this.hasBwArrow) {
                arc.setBWArrow(this.hasBwArrow.isSelected());
            }
            this.fillColorChooserButton.setEnabled(this.isClosed.isSelected() && this.isFilled.isSelected());
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Font newFont;
        String size;
        String name;
        super.actionPerformed(e);
        PTArc arc = (PTArc)this.getCurrentObject();
        this.isItalic = arc.getTextComponent().getFont().isItalic();
        this.isBold = arc.getTextComponent().getFont().isBold();
        if (e.getSource() == this.textField) {
            arc.setText(this.textField.getText());
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            arc.getTextComponent().setFont(this.storeFont());
        }
        if (e.getSource() == this.italic) {
            this.isItalic = !this.isItalic;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            arc.getTextComponent().setFont(newFont);
        }
        if (e.getSource() == this.bold) {
            this.isBold = !this.isBold;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            arc.getTextComponent().setFont(newFont);
        }
        if (e.getSource() == this.isCircle) {
            arc.setCircle(this.isCircle.isSelected());
        }
        if (e.getSource() == this.orientationIsClockwise) {
            arc.setClockwise(this.orientationIsClockwise.isSelected());
        }
        if (Animation.get() != null) {
            Animation.get().doChange();
        }
        this.repaintNow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTArc arc = (PTArc)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            arc.setColor((Color)event.getNewValue());
        } else if ("fillColor".equals(eventName)) {
            arc.setFillColor((Color)event.getNewValue());
        } else if ("textColor".equals(eventName)) {
            arc.setTextColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "Arc";
    }
}

