/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.Highlight;
import animal.animator.Swap;
import animal.editor.Editor;
import animal.editor.animators.TimedAnimatorEditor;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.main.Animal;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class SwapEditor
extends TimedAnimatorEditor
implements GraphicObjectSpecificAnimation {
    private static final long serialVersionUID = -3355178488198635871L;
    private JComboBox firstCB;
    private JComboBox secondCB;
    private JRadioButton poly;
    private JRadioButton arc;
    private int a = -1;
    private int b = -1;
    private int commonLength = -1;
    private static final String TYPE_POLY = "SwapEditor.swapTypePolyline";
    private static final String TYPE_ARC = "SwapEditor.swapTypeArc";

    @Override
    protected void buildGUI() {
        super.buildGUI();
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel sw = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        sw.add((Component)generator.generateJLabel("SwapEditor.swapCells"), gbc);
        gbc.gridx = 1;
        gbc.anchor = 10;
        this.firstCB = new JComboBox();
        this.firstCB.addItemListener(this);
        sw.add((Component)this.firstCB, gbc);
        gbc.gridx = 2;
        this.secondCB = new JComboBox();
        this.secondCB.addItemListener(this);
        sw.add((Component)this.secondCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.ipadx = 10;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.gridheight = 2;
        sw.add((Component)generator.generateJLabel("SwapEditor.swapType"), gbc);
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        Animal privateAnimal = new Animal();
        this.poly = new JRadioButton(AnimalTranslator.translateMessage(TYPE_POLY), privateAnimal.getImageIcon("swapPoly.gif"), true);
        this.poly.setPressedIcon(privateAnimal.getImageIcon("swapPolySelected.gif"));
        this.poly.setSelectedIcon(privateAnimal.getImageIcon("swapPolySelected.gif"));
        this.poly.addActionListener(this);
        sw.add((Component)this.poly, gbc);
        gbc.gridy = 2;
        this.arc = new JRadioButton(AnimalTranslator.translateMessage(TYPE_ARC), privateAnimal.getImageIcon("swapArc.gif"), false);
        this.arc.setPressedIcon(privateAnimal.getImageIcon("swapArcSelected.gif"));
        this.arc.setSelectedIcon(privateAnimal.getImageIcon("swapArcSelected.gif"));
        this.arc.addActionListener(this);
        sw.add((Component)this.arc, gbc);
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.poly);
        typeGroup.add(this.arc);
        this.addLayer(sw);
        this.finish();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() instanceof ObjectSelectionButton) {
            this.firstCB.removeItemListener(this);
            this.secondCB.removeItemListener(this);
            this.firstCB.removeAllItems();
            this.secondCB.removeAllItems();
            if (this.objectNums != null && this.objectNums.length >= 1) {
                this.commonLength = -1;
                int now = 0;
                int j = 0;
                while (j < this.objectNums.length) {
                    if (this.objectSB.hasMultiSelection()) {
                        int[] elements = ((ObjectSelectionButton)e.getSource()).getObjectNums();
                        if (elements != null && elements.length > j) {
                            now = elements[j];
                        }
                    } else {
                        now = ((ObjectSelectionButton)e.getSource()).getObjectNum();
                    }
                    int length = -1;
                    if (SwapEditor.getGraphicObject(now) instanceof PTArray) {
                        length = ((PTArray)SwapEditor.getGraphicObject(now)).getSize();
                    }
                    if (this.commonLength == -1) {
                        this.commonLength = length;
                    } else if (length < this.commonLength) {
                        this.commonLength = length;
                    }
                    ++j;
                }
                if (this.commonLength >= 2) {
                    this.checkStoredIndices();
                    int i = 0;
                    while (i < this.commonLength) {
                        if (i != this.b && this.checkActivation(i)) {
                            this.firstCB.addItem(String.valueOf(i));
                        }
                        if (i != this.a && this.checkActivation(i)) {
                            this.secondCB.addItem(String.valueOf(i));
                        }
                        ++i;
                    }
                    this.firstCB.setSelectedItem(String.valueOf(this.a));
                    this.secondCB.setSelectedItem(String.valueOf(this.b));
                }
            }
            this.firstCB.addItemListener(this);
            this.secondCB.addItemListener(this);
        } else if (e.getSource() == this.firstCB || e.getSource() == this.secondCB) {
            this.a = this.calcIndex(this.firstCB);
            this.b = this.calcIndex(this.secondCB);
            JComboBox current = this.firstCB;
            JComboBox other = this.secondCB;
            if (e.getSource() == this.secondCB) {
                current = this.secondCB;
                other = this.firstCB;
            }
            other.removeItemListener(this);
            Object selectedItem = other.getSelectedItem();
            other.removeAllItems();
            int i = 0;
            while (i < this.commonLength) {
                if (!String.valueOf(i).equals(current.getSelectedItem()) && this.checkActivation(i)) {
                    other.addItem(String.valueOf(i));
                }
                ++i;
            }
            if (selectedItem != null && !selectedItem.equals(current.getSelectedItem())) {
                other.setSelectedItem(selectedItem);
            }
            other.addItemListener(this);
        }
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        int i;
        super.extractAttributesFrom(eo);
        Swap swap = (Swap)eo;
        PTGraphicObject ao = null;
        if (this.objectNums != null && this.objectNums.length > 0) {
            i = 0;
            while (i < this.objectNums.length) {
                if (this.objectSB.hasMultiSelection()) {
                    if (this.objectSB.getObjectNums() != null) {
                        ao = SwapEditor.getGraphicObject(this.objectSB.getObjectNums()[i]);
                    }
                } else if (this.objectSB.getObjectNum() != 0) {
                    ao = SwapEditor.getGraphicObject(this.objectSB.getObjectNum());
                }
                int length = -1;
                if (ao instanceof PTArray) {
                    length = ((PTArray)ao).getSize();
                }
                if (this.commonLength == -1) {
                    this.commonLength = length;
                } else if (length < this.commonLength) {
                    this.commonLength = length;
                }
                ++i;
            }
        }
        this.firstCB.removeItemListener(this);
        this.secondCB.removeItemListener(this);
        this.firstCB.removeAllItems();
        this.secondCB.removeAllItems();
        if (this.commonLength >= 2) {
            this.a = swap.getSwapElements()[0] < 0 ? 0 : swap.getSwapElements()[0];
            this.b = swap.getSwapElements()[1] <= 0 ? 1 : swap.getSwapElements()[1];
            i = 0;
            while (i < this.commonLength) {
                if (i != this.b && this.checkActivation(i)) {
                    this.firstCB.addItem(String.valueOf(i));
                }
                if (i != this.a && this.checkActivation(i)) {
                    this.secondCB.addItem(String.valueOf(i));
                }
                ++i;
            }
            this.firstCB.setSelectedItem(String.valueOf(this.a));
            this.secondCB.setSelectedItem(String.valueOf(this.b));
        }
        this.firstCB.addItemListener(this);
        this.secondCB.addItemListener(this);
        switch (swap.getAnimationType()) {
            case 0: {
                this.poly.setSelected(true);
                break;
            }
            case 1: {
                this.arc.setSelected(true);
            }
        }
    }

    private boolean checkActivation(int index) {
        if (!Highlight.realDeactivation()) {
            return true;
        }
        if (this.objectSB.hasMultiSelection()) {
            int size;
            int n = size = this.objectSB.getObjectNums() == null ? -1 : this.objectSB.getObjectNums().length;
            if (size <= 0) {
                return false;
            }
            int x = 0;
            while (x < size) {
                if (SwapEditor.getGraphicObject(this.objectSB.getObjectNums()[x]) instanceof PTIntArray && !((PTArray)SwapEditor.getGraphicObject(this.objectSB.getObjectNums()[x])).isActivated(index)) {
                    return false;
                }
                ++x;
            }
        } else if (this.objectSB.getObjectNum() == 0 || !((PTArray)SwapEditor.getGraphicObject(this.objectSB.getObjectNum())).isActivated(index)) {
            return false;
        }
        return true;
    }

    @Override
    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        Swap swap = (Swap)eo;
        if (this.poly.isSelected()) {
            swap.setAnimationType(0);
        } else if (this.arc.isSelected()) {
            swap.setAnimationType(1);
        }
        if (this.objectSB.hasMultiSelection()) {
            if (this.objectSB.getObjectNums() != null) {
                swap.setObjects(this.objectSB.getObjectNums());
            }
        } else if (this.objectSB.getObjectNum() != 0) {
            swap.setObject(this.objectSB.getObjectNum());
        }
        swap.setSwapElements(this.calcIndex(this.firstCB), this.calcIndex(this.secondCB));
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        SwapEditor result = new SwapEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public EditableObject createObject() {
        Swap s = new Swap();
        this.storeAttributesInto(s);
        return s;
    }

    private int calcIndex(JComboBox cBox) {
        cBox.removeItemListener(this);
        int index = this.getInt((String)cBox.getSelectedItem(), -1);
        cBox.addItemListener(this);
        return index;
    }

    private boolean checkStoredIndices() {
        if (this.b >= this.commonLength || this.b < 0) {
            int n = this.b = this.a == this.commonLength - 1 ? this.a - 1 : this.commonLength - 1;
        }
        if (this.a >= this.commonLength || this.a < 0) {
            this.a = this.b == this.commonLength - 1 ? 0 : this.commonLength - 1;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        Object first = this.firstCB.getSelectedItem();
        Object second = this.secondCB.getSelectedItem();
        if (first == null || second == null || first.equals(second)) {
            new JDialog(this, AnimalTranslator.translateMessage("SwapEditor.invalidCellSelection"), true);
            return false;
        }
        if (this.objectSB.getObjectNums() == null) {
            new JDialog(this, AnimalTranslator.translateMessage("AnimatorEditor.noObjectSelectedException"), true);
            return false;
        }
        if (!this.checkActivation(this.calcIndex(this.firstCB))) {
            new JDialog(this, AnimalTranslator.translateMessage("SwapEditor.inactiveElementException", new Object[]{this.calcIndex(this.firstCB)}), true);
            return false;
        }
        if (!this.checkActivation(this.calcIndex(this.secondCB))) {
            new JDialog(this, AnimalTranslator.translateMessage("SwapEditor.inactiveElementException", new Object[]{this.calcIndex(this.secondCB)}), true);
            return false;
        }
        return super.apply();
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"IntArray", "StringArray"};
    }
}

