/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.Scale;
import animal.editor.Editor;
import animal.editor.animators.TimedAnimatorEditor;
import animal.graphics.PTPoint;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class ScaleEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -7598478572744872282L;
    private ObjectSelectionButton center;
    private JTextField xScaleFactorTF;
    private JTextField yScaleFactorTF;

    @Override
    protected void buildGUI() {
        super.buildGUI();
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        JPanel c = new JPanel(new FlowLayout(0));
        c.add(generator.generateJLabel("ScaleEditor.scaleCenterLabel"));
        this.center = new ObjectSelectionButton(false);
        c.add(this.center);
        c.add(generator.generateJLabel("ScaleEditor.scaleFactorXLabel"));
        this.xScaleFactorTF = new JTextField(5);
        c.add(this.xScaleFactorTF);
        c.add(generator.generateJLabel("ScaleEditor.scaleFactorYLabel"));
        this.yScaleFactorTF = new JTextField(5);
        c.add(this.yScaleFactorTF);
        this.addLayer(c);
        this.finish();
    }

    @Override
    public void setProperties(XProperties props) {
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Scale scale = (Scale)eo;
        this.center.setObjectNum(scale.getCenterNum());
        this.xScaleFactorTF.setText(String.valueOf(scale.getXScaleFactor()));
        this.yScaleFactorTF.setText(String.valueOf(scale.getYScaleFactor()));
    }

    @Override
    public void storeAttributesInto(EditableObject scale) {
        super.storeAttributesInto(scale);
        if (scale instanceof Scale) {
            Scale scaler = (Scale)scale;
            scaler.setCenterNum(this.center.getObjectNum());
            scaler.setXScaleFactor(this.getDouble(this.xScaleFactorTF.getText(), 1.0));
            scaler.setYScaleFactor(this.getDouble(this.yScaleFactorTF.getText(), 1.0));
        }
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        ScaleEditor result = new ScaleEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public EditableObject createObject() {
        Scale r = new Scale();
        this.storeAttributesInto(r);
        return r;
    }

    @Override
    protected String isOK() {
        String result = super.isOK();
        if (result != null) {
            return result;
        }
        this.center.checkObjects();
        int num = this.center.getObjectNum();
        if (num == 0) {
            return AnimalTranslator.translateMessage("ScaleEditor.scaleNoCenter");
        }
        if (!(ScaleEditor.getGraphicObject(num) instanceof PTPoint)) {
            return AnimalTranslator.translateMessage("ScaleEditor.scaleCenterNotPoint");
        }
        return null;
    }
}

