/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.TimedAnimator;
import animal.editor.Editor;
import animal.editor.IndexedContentChooserListSupport;
import animal.editor.animators.TimedAnimatorEditor;
import animal.graphics.PTGraphicObject;
import animal.main.Animation;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;

public abstract class IndexedTimedAnimatorEditor
extends TimedAnimatorEditor
implements GraphicObjectSpecificAnimation {
    private static final long serialVersionUID = -6321391140925997292L;
    protected IndexedContentChooserListSupport indexChooser;

    @Override
    protected void buildGUI() {
        super.buildGUI();
        this.getContentPane().remove(this.basicPanel);
        this.installBoxLayout();
        this.addBox(this.createTimedAnimatorControls());
        this.addBox(this.createIndexChooser());
        this.methodChoice.setVisible(false);
    }

    protected Box createTimedAnimatorControls() {
        Box c = new Box(2);
        c.add(this.basicPanel);
        return c;
    }

    protected Box createIndexChooser() {
        this.indexChooser = new IndexedContentChooserListSupport();
        this.indexChooser.setShowOnlyObjectsWithMethods(true);
        return this.indexChooser.getContentBox();
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        return null;
    }

    @Override
    public void storeAttributesInto(EditableObject eo) {
        this.createMethodChoiceModel();
        super.storeAttributesInto(eo);
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        String method = this.getMethodFromEditableObject(eo);
        super.extractAttributesFrom(eo);
        if (method != null) {
            this.splitAndSetData(method);
        }
    }

    private void splitAndSetData(String method) {
        String[] tokens = method.split("\\s");
        if (tokens.length >= 3 && this.indexChooser.setSelectedKindOfObject(tokens[0]) && this.indexChooser.setSelectedMethod(tokens[1]) && tokens[2].length() > 4) {
            String[] indexTuples = tokens[2].contains("][") ? tokens[2].substring(2, tokens[2].length() - 2).split("\\]\\[") : new String[]{tokens[2].substring(2, tokens[2].length() - 2)};
            Vector<Vector<Integer>> tuples = new Vector<Vector<Integer>>();
            Vector<Integer> tmpVector = new Vector<Integer>();
            int i = 0;
            while (i < indexTuples.length) {
                tmpVector.clear();
                String[] indices = indexTuples[i].split(",");
                if (indices.length >= 1) {
                    try {
                        String[] stringArray = indices;
                        int n = indices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String index = stringArray[n2];
                            tmpVector.add(Integer.parseInt(index));
                            ++n2;
                        }
                        tuples.add(tmpVector);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            this.indexChooser.addIndicesToList(tuples);
        }
    }

    protected String getMethodFromEditableObject(EditableObject eo) {
        if (eo instanceof TimedAnimator) {
            return ((TimedAnimator)eo).getMethod();
        }
        return null;
    }

    private void createMethodChoiceModel() {
        String methodChoice = "";
        methodChoice = String.valueOf(methodChoice) + this.indexChooser.getSelectedMethod() + " " + this.indexChooser.getChosenIndexTuples();
        this.methodChoice.setModel(new DefaultComboBoxModel<Object>(new Object[]{methodChoice}));
        this.methodChoice.setSelectedIndex(0);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() instanceof ObjectSelectionButton) {
            this.setDataForIndexChooser();
        }
    }

    private void setDataForIndexChooser() {
        if (this.objectNums != null) {
            PTGraphicObject[] objects = new PTGraphicObject[this.objectNums.length];
            int i = 0;
            while (i < objects.length) {
                objects[i] = Animation.get().getGraphicObject(this.objectNums[i]);
                ++i;
            }
            this.indexChooser.setData(objects, this.getApplicableMethods(((TimedAnimator)this.getCurrentObject()).getProperty(0.0)));
        }
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"IndexableContentContainer"};
    }
}

