/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.ColorChanger;
import animal.editor.Editor;
import animal.editor.animators.TimedAnimatorEditor;
import animal.misc.ColorChoice;
import animal.misc.EditableObject;
import animal.misc.XProperties;
import java.awt.Color;
import javax.swing.JPanel;
import translator.AnimalTranslator;

public class ColorChangerEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -243298461803526770L;
    private ColorChoice color;

    @Override
    protected void buildGUI() {
        super.buildGUI();
        JPanel c = new JPanel();
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("ColorChangerEditor.targetColor"));
        this.color = new ColorChoice();
        c.add(this.color);
        this.addLayer(c);
        this.finish();
    }

    @Override
    public void setProperties(XProperties props) {
        super.setProperties(props);
        this.color.setColor(props.getColorProperty("color", Color.black));
    }

    @Override
    public void getProperties(XProperties props) {
        super.getProperties(props);
        props.put("color", this.color.getColor());
    }

    @Override
    public void extractAttributesFrom(EditableObject colorChanger) {
        super.extractAttributesFrom(colorChanger);
        this.color.setColor(((ColorChanger)colorChanger).getColor());
    }

    @Override
    public void storeAttributesInto(EditableObject colorChanger) {
        super.storeAttributesInto(colorChanger);
        ((ColorChanger)colorChanger).setColor(this.color.getColor());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        ColorChangerEditor result = new ColorChangerEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public EditableObject createObject() {
        ColorChanger c = new ColorChanger();
        this.storeAttributesInto(c);
        return c;
    }
}

