/*
 * Decompiled with CFR 0.152.
 */
package animal.dialog;

import animal.main.Animal;
import animal.main.AnimalConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import translator.AnimalTranslator;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -5083531199461628721L;
    private static AboutDialog dialog = null;
    private Animal animal;
    private AbstractButton okButton;

    public AboutDialog(Animal animalInstance) {
        super(animalInstance, AnimalTranslator.translateMessage("about.label", null), false);
        this.animal = animalInstance;
        String htmlString = this.createHTMLRendition();
        JEditorPane textArea = new JEditorPane("text/html", htmlString);
        textArea.setEditable(false);
        textArea.setPreferredSize(new Dimension(640, 480));
        textArea.setCaretPosition(0);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(new SoftBevelBorder(1));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroller, "Center");
        this.okButton = new JButton(AnimalTranslator.translateMessage("ok", null));
        this.getContentPane().add((Component)this.okButton, "South");
        this.pack();
        this.okButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AboutDialog.this.windowClosing();
            }
        });
        dialog = this;
    }

    private String createHTMLRendition() {
        StringBuilder sb = new StringBuilder(16392);
        String homeURL = "http://www.algoanim.info/Animal2";
        sb.append("<html>");
        sb.append("\n\n<body>");
        sb.append("\n\n<div align='center'><img src='graphics/Animal.png' ");
        sb.append("alt='Animal Logo' /></div>");
        sb.append("\n\n<h1 style='text-align: center; font-variant: small-caps'>Animal</h1>");
        sb.append("\n\n<h2 style='text-align: center;'>");
        sb.append("<span style='text-color: red'>A</span>dvanced ");
        sb.append("<span style='text-color: red'>N</span>avigation");
        sb.append(" and <span style='text-color: red'>I</span>nteractive ");
        sb.append("<span style='text-color: red'>M</span>odeling for ");
        sb.append("<span style='text-color: red'>A</span>nimations ");
        sb.append(" in <span style='text-color: red'>L</span>ectures</h2>");
        String versionInfo = AnimalConfiguration.getDefaultConfiguration().getVersionLine("versionInfoLine");
        sb.append("\n\n<p><em>Version: ").append(versionInfo).append("</em></p>");
        sb.append("\n\n<p>&copy; 1998 Markus Sch&uuml;ler, Guido R&ouml;&szlig;ling [1.1]");
        sb.append("\n\n<br />&copy; 1999+ Guido R&ouml;&szlig;ling [1.2+]");
        sb.append("\n<br />Contact email: <code>roessling@acm.org</code>");
        sb.append("\n<br />Home page: <a href='").append(homeURL);
        sb.append("'>").append(homeURL).append("</a></p>");
        sb.append("\n\n<h2>Contributors</h2>\n\n");
        try {
            BufferedReader bis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("contributors.txt"), "MacRoman"));
            String line = null;
            while ((line = bis.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        sb.append("\n\n");
        if (Animal.generatorDemo == null) {
            this.animal.openGenerator();
            Animal.generatorDemo.setVisible(false);
        }
        sb.append(Animal.generatorDemo.getContentAuthors());
        sb.append("</body>\n</html>\n");
        return sb.toString();
    }

    public static AboutDialog getAboutDialog(Animal animalInstance) {
        if (dialog == null) {
            dialog = new AboutDialog(animalInstance);
        }
        return dialog;
    }

    @Override
    public void setVisible(boolean showIt) {
        if (!this.isVisible()) {
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(showIt);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.windowClosing();
        }
    }

    public void windowClosing() {
        dialog = null;
        this.setVisible(false);
        this.dispose();
    }
}

