/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;

public class VariableIncrease
extends Animator {
    private static final int FILE_VERSION = 1;
    public static final String TYPE_LABEL = "VariableIncrease";
    private transient AnimationState animState;
    private String name;

    public VariableIncrease() {
    }

    public VariableIncrease(int step, String name) {
        super(step, (int[])null);
        this.name = name;
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.animState = animationState;
    }

    @Override
    public void action(long time, double ticks) {
        this.execute();
    }

    @Override
    public void execute() {
        super.execute();
        String value = this.animState.getVariables().get(this.name).getValue();
        try {
            int newValue = Integer.parseInt(value) + 1;
            this.animState.getVariables().get(this.name).setValue(Integer.toString(newValue));
            AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getVariableView().setStep(this.getStep());
        }
        catch (NumberFormatException e) {
            System.out.println("WARNING: " + this.name + " is not a number, ignoring INC command");
        }
    }

    public void counterAction(int value) {
        this.animState.getVariables().get(this.name).setValue(Integer.toString(value + 1));
        AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getVariableView().setStep(this.getStep());
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    @Override
    public boolean isChangingAnimator() {
        return false;
    }

    @Override
    public boolean isGraphicalObjectAnimator() {
        return false;
    }

    @Override
    public void discard() {
        this.animState = null;
        this.name = null;
        super.discard();
    }

    @Override
    public String toString() {
        return "Variable Increase: " + this.name;
    }
}

