/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.TimedAnimator;
import animal.gui.GraphicVector;
import animal.main.AnimationState;
import animal.misc.XProperties;

public class TimedShow
extends TimedAnimator {
    public static final String TYPE_LABEL = "TimedShow";
    private static final long serialVersionUID = 5575863619518931021L;
    private transient GraphicVector graphicVector;

    public TimedShow() {
    }

    public TimedShow(int step, int objectNum, int totalTimeOrTicks, String method, boolean show) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, method, show);
    }

    public TimedShow(int step, int[] objectNums, int totalTimeOrTicks, String method, boolean show) {
        this(step, objectNums, totalTimeOrTicks, 0, method, show);
    }

    public TimedShow(int step, int[] objectNums, int totalTimeOrTicks, int offset, String method, boolean show) {
        super(step, objectNums, totalTimeOrTicks, method);
        this.setShow(show);
        this.setOffset(offset);
        if (method == null) {
            this.setMethod(show ? "show" : "hide");
        } else {
            this.setMethod(method);
        }
    }

    public TimedShow(XProperties props) {
        this.setProperties(props);
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.graphicVector = animationState.getCurrentObjects();
    }

    @Override
    public void execute() {
        block5: {
            super.execute();
            if (this.getMethod() != null && !this.getMethod().equalsIgnoreCase(this.getAnimatorName())) {
                return;
            }
            if (this.objects == null || this.objects.length <= 0) break block5;
            if (this.isShow()) {
                int a = 0;
                while (a < this.objects.length) {
                    this.graphicVector.addElement(this.objects[a], 2);
                    ++a;
                }
            } else {
                int a = 0;
                while (a < this.objects.length) {
                    this.graphicVector.removeElement(this.objects[a]);
                    ++a;
                }
            }
        }
    }

    @Override
    public String getAnimatorName() {
        if (this.isShow()) {
            return "show";
        }
        return "hide";
    }

    @Override
    public int getFileVersion() {
        return 2;
    }

    @Override
    public Object getProperty(double factor) {
        return new Boolean(false);
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{"Show", "Hide"};
    }

    @Override
    public boolean isChangingAnimator() {
        return false;
    }

    public boolean isShow() {
        return this.getProperties().getProperty("method", "Show").equalsIgnoreCase("Show");
    }

    public void setShow(boolean show) {
        this.getProperties().put("method", show ? "Show" : "Hide");
    }

    @Override
    public void discard() {
        if (this.graphicVector != null) {
            this.graphicVector.removeAllElements();
            this.graphicVector = null;
        }
        super.discard();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getAnimatorName());
        String showHideMethodName = this.getMethod();
        if (showHideMethodName != null && !showHideMethodName.equals("show") && !showHideMethodName.equals("hide")) {
            sb.append("(").append(showHideMethodName).append(")");
        }
        sb.append(" ").append(super.toString());
        return sb.toString();
    }
}

