/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.PerformableAction;
import animal.animator.QuestionAction;
import animal.main.Animal;
import animal.misc.FillInBlanksInterface;
import java.util.Hashtable;

public class FillInBlanksQuestionAction
extends QuestionAction
implements PerformableAction {
    private static final long serialVersionUID = -3577126547590602694L;
    public static final String ANSWER_COUNTER_TAG = "answerCounter";
    public static final String CORRECT_ANSWER_COUNTER_TAG = "correctAnswerCounter";
    public static final String TYPE_LABEL = "FillInBlanksQuestion";
    private Hashtable<String, String> answers = new Hashtable(17);
    private FillInBlanksInterface handler = null;
    boolean constructed = false;
    private Hashtable<String, String> correctAnswers = new Hashtable(17);

    public FillInBlanksQuestionAction() {
        this("none");
    }

    public FillInBlanksQuestionAction(String theTitle) {
        this.setType(1);
        this.setTitle(theTitle);
        this.handler = (FillInBlanksInterface)Animal.getInteractionHandler().getHandlerFor(0, theTitle);
    }

    @Override
    public void perform() {
        Animal.getInteractionHandler().initialize(this.handler, this.constructed, this.getQuestionText());
        this.constructed = true;
        Animal.getInteractionHandler().performQuestionOperation(this.handler);
    }

    @Override
    public void addAnswer(String answerText) {
        int answerCounter = this.getProperties().getIntProperty(ANSWER_COUNTER_TAG, 0) + 1;
        this.getProperties().put(ANSWER_COUNTER_TAG, answerCounter);
        this.answers.put(String.valueOf(answerCounter), answerText);
        this.handler.AddAnswer(answerText);
    }

    public void addCorrectFIBAnswer(String correctAnswerText) {
        int correctAnswerCounter = this.getProperties().getIntProperty(CORRECT_ANSWER_COUNTER_TAG, 0) + 1;
        this.getProperties().put(ANSWER_COUNTER_TAG, correctAnswerCounter);
        this.correctAnswers.put(String.valueOf(correctAnswerCounter), correctAnswerText);
        this.handler.AddAnswer(correctAnswerText);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("Fill In the Blanks: question: '").append(this.getQuestionText()).append("'");
        int nrAnswers = this.answers.size();
        sb.append(" Possible answers: [").append(nrAnswers).append("]: {");
        int i = 1;
        while (i <= nrAnswers) {
            sb.append("{").append(i).append(". '").append(this.answers.get(String.valueOf(i))).append("'} ");
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

