/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.TimedAnimator;
import animal.main.AnimationState;
import animal.misc.XProperties;
import java.beans.PropertyChangeEvent;

public class DepthChanger
extends TimedAnimator {
    public static final String DEPTH_LABEL = "DepthChanger.depth";
    public static final String TYPE_LABEL = "DepthChanger";
    private static final long serialVersionUID = 5575863252518931027L;
    private int[] originalDepths = null;

    public DepthChanger() {
    }

    public DepthChanger(int step, int objectNum, int totalTimeOrTicks, String method, int depth) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, method, depth);
    }

    public DepthChanger(int step, int[] objectNums, int totalTimeOrTicks, String method, int depth) {
        super(step, objectNums, totalTimeOrTicks, method);
        this.setDepth(depth);
    }

    public DepthChanger(XProperties props) {
        this.setProperties(props);
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        if (this.objects != null) {
            this.originalDepths = new int[this.objects.length];
            int i = 0;
            while (i < this.originalDepths.length) {
                this.originalDepths[i] = this.objects[i].getDepth();
                ++i;
            }
        }
    }

    @Override
    public void action(long time, double ticks) {
        int totalTimeOrTicks = this.getDuration();
        if (this.hasFinished()) {
            return;
        }
        double elapsed = (this.isUnitIsTicks() ? ticks : (double)time) - (double)this.getStartTimeOrTicks() - (double)this.getOffset();
        float factor = (float)elapsed / (float)totalTimeOrTicks;
        if (totalTimeOrTicks == 0 && elapsed >= 0.0 || factor >= 1.0f) {
            this.execute();
        } else {
            if (factor < 0.0f) {
                return;
            }
            Object newProperty = null;
            int a = 0;
            while (a < this.objects.length) {
                int origDepth = this.objects[a].getDepth();
                int newDepth = this.getDepth();
                int interpolatedDepth = origDepth + (int)(factor * (float)(origDepth - newDepth));
                this.objects[a].propertyChange(new PropertyChangeEvent(this, this.getMethod(), new Integer(origDepth), new Integer(interpolatedDepth)));
                this.oldProperty = newProperty;
                ++a;
            }
        }
    }

    @Override
    public String getAnimatorName() {
        return "DepthChange";
    }

    public int getDepth() {
        return this.getProperties().getIntProperty(DEPTH_LABEL, Integer.MAX_VALUE);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public Object getProperty(double factor) {
        int[] objectNums = this.getObjectNums();
        if (objectNums == null || objectNums.length == 0) {
            return new Integer(this.getDepth());
        }
        if (this.originalDepths == null) {
            this.originalDepths = new int[objectNums.length];
            int i = 0;
            while (i < this.originalDepths.length) {
                this.originalDepths[i] = this.objects[i].getDepth();
                ++i;
            }
        }
        return new Integer(this.getDepth());
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{"DepthChange"};
    }

    public void setDepth(int depth) {
        this.getProperties().put(DEPTH_LABEL, depth);
    }

    public void setOriginalDepths(int depth) {
        int[] objectNums = this.getObjectNums();
        if (objectNums != null && objectNums.length != 0) {
            this.originalDepths = new int[objectNums.length];
            int i = 0;
            while (i < this.originalDepths.length) {
                this.originalDepths[i] = depth;
                ++i;
            }
        }
    }

    @Override
    public void discard() {
        super.discard();
    }

    @Override
    public String toString() {
        return "set depth to " + this.getDepth() + " on " + super.toString();
    }
}

