/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.TimedAnimator;
import animal.editor.Editor;
import animal.editor.animators.AnimatorEditor;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;
import animal.misc.AnimalInfoFrame;
import animal.misc.EditableObject;
import animal.misc.MessageDisplay;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jhave.support.InfoFrameInterface;
import translator.AnimalTranslator;

public abstract class Animator
extends EditableObject {
    public static final String METHOD_LABEL = "method";
    public static final String OID_LABEL = "objectNums";
    public static final String STEP_LABEL = "step";
    private static final long serialVersionUID = -8003195822156146231L;
    public static XProperties DefaultProperties;
    public static InfoFrameInterface infoFrame;
    public static Hashtable<String, String> registeredHandlers;
    protected transient boolean finished = false;
    protected transient PTGraphicObject[] objects;
    private int animationStep = 0;

    static {
        infoFrame = null;
        if (registeredHandlers == null) {
            registeredHandlers = new Hashtable(23);
        }
        Hashtable<String, Editor> animalEditors = Animal.get().getEditors();
        Enumeration<String> e = animalEditors.keys();
        String editorName = null;
        Editor editor = null;
        String type = null;
        while (e.hasMoreElements()) {
            editorName = e.nextElement();
            editor = animalEditors.get(editorName);
            if (editor == null || !(editor instanceof AnimatorEditor)) continue;
            type = "animal.animator." + editorName;
            try {
                String[] handledKeywords;
                Class<?> targetClass = Class.forName(type);
                Animator animator = (Animator)targetClass.newInstance();
                if (animator == null || (handledKeywords = animator.handledKeywords()) == null) continue;
                int i = 0;
                while (i < handledKeywords.length) {
                    registeredHandlers.put(handledKeywords[i].toLowerCase(), type);
                    ++i;
                }
            }
            catch (ClassNotFoundException classNotFound) {
                MessageDisplay.errorMsg("classNotFoundException", new Object[]{type});
            }
            catch (IllegalAccessException illegalAccess) {
                MessageDisplay.errorMsg("illegalAccessException", new Object[]{type});
            }
            catch (InstantiationException instantiationException) {
                MessageDisplay.errorMsg("instantiationException", new Object[]{type});
            }
        }
    }

    public Animator() {
        if (DefaultProperties == null) {
            Animator.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
    }

    public Animator(int step, int objectNum) {
        this(step, new int[]{objectNum});
    }

    public Animator(int step, int[] objectNums) {
        this();
        this.setStep(step);
        this.setObjectNums(objectNums);
    }

    public Animator(int step, Vector<Integer> objectNums) {
        this();
        this.setStep(step);
        this.setObjectNumVector(objectNums);
    }

    private void setObjectNumVector(Vector<Integer> objectNums) {
        int nrElems = objectNums.size();
        int[] objectNumbers = new int[nrElems];
        int i = 0;
        while (i < nrElems) {
            objectNumbers[i] = objectNums.elementAt(i);
            ++i;
        }
        this.getProperties().put(OID_LABEL, objectNumbers);
    }

    public Animator(XProperties props) {
        this.setProperties(props);
    }

    public abstract int getFileVersion();

    public static XProperties extractDefaultProperties(XProperties props, String prefix) {
        return props.getElementsForPrefix(prefix);
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = Animator.extractDefaultProperties(properties, "Animator");
    }

    public void init(AnimationState animationState, long time, double ticks) {
        int[] objectNums = this.getObjectNums();
        if (objectNums != null) {
            this.objects = new PTGraphicObject[objectNums.length];
            int a = 0;
            while (a < objectNums.length) {
                this.objects[a] = animationState.getCloneByNum(objectNums[a]);
                ++a;
            }
            this.finished = false;
        } else if (!(this instanceof TimedAnimator)) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("noObjectsSetException", new Object[]{String.valueOf(animationState.getStep()), this.getAnimatorName()}), 4);
        }
    }

    public abstract void action(long var1, double var3);

    public void execute() {
        this.setFinished(true);
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public void setFinished(boolean finishState) {
        this.finished = finishState;
    }

    public boolean animatesObjectByID(int oid) {
        int[] oids = this.getObjectNums();
        if (oids == null || oids.length == 0) {
            return false;
        }
        boolean found = false;
        int i = 0;
        while (i < oids.length && !found) {
            found = oids[i] == oid;
            ++i;
        }
        return found;
    }

    public abstract String getAnimatorName();

    public int[] getObjectNums() {
        return this.getProperties().getIntArrayProperty(OID_LABEL);
    }

    public int getStep() {
        if (this.animationStep != this.getProperties().getIntProperty(STEP_LABEL, 1)) {
            System.err.println("Step != : " + this.animationStep + ", " + this.getProperties().getIntProperty(STEP_LABEL, 1));
        }
        return this.getProperties().getIntProperty(STEP_LABEL, 1);
    }

    public int[] getTemporaryObjects() {
        return null;
    }

    public abstract String[] handledKeywords();

    public boolean isChangingAnimator() {
        return true;
    }

    public boolean isGraphicalObjectAnimator() {
        return true;
    }

    public static InfoFrameInterface getInfoFrame() {
        if (infoFrame == null) {
            infoFrame = new AnimalInfoFrame();
        }
        return infoFrame;
    }

    public static void setInfoFrame(InfoFrameInterface anInfoFrame) {
        infoFrame = anInfoFrame;
    }

    public void setObjectNums(int[] objectNumbers) {
        this.getProperties().put(OID_LABEL, objectNumbers);
    }

    public abstract String getType();

    public void setStep(int targetStep) {
        this.animationStep = targetStep;
        this.getProperties().put(STEP_LABEL, targetStep);
    }

    public void discard() {
        this.setObjectNums(null);
        this.objects = null;
    }

    public static String printIDs(int[] ids) {
        int n = ids.length;
        StringBuilder sb = new StringBuilder(ids.length * 5);
        int i = 0;
        while (i < n) {
            sb.append(ids[i]).append(' ');
            ++i;
        }
        return sb.toString();
    }

    public void scavenge(boolean[] usedValues) {
        int[] objectNums = this.getObjectNums();
        int oidLengths = objectNums.length;
        int usedLength = usedValues.length;
        int i = 0;
        while (i < oidLengths) {
            if (usedLength >= objectNums[i]) {
                usedValues[objectNums[i] - 1] = true;
            }
            ++i;
        }
    }

    public String toString() {
        return ObjectSelectionButton.getNumArrayString(this.getObjectNums());
    }

    public String toString(int length) {
        return this.toString().substring(0, length);
    }

    @Override
    public void setProperties(XProperties props) {
        super.setProperties(props);
        if (props != null) {
            this.setStep(props.getIntProperty(STEP_LABEL, 1));
        }
    }
}

