/*
 * Decompiled with CFR 0.152.
 */
package algorithm.animalTranslator.library;

import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.library.Library;
import algorithm.fileHandler.FileHandler;

public abstract class AdvancedLibrary
extends Library {
    public AdvancedLibrary(FileHandler fileHandlerToUse) {
        this.setFileHandler(fileHandlerToUse);
    }

    public void advancedCreateWorkSheet(int x, int y) {
        this.addRectangle("background", new Pos(5, 5), new Pos(5 + x, 5 + y), "color white filled fillColor white", null);
    }

    public void advancedCreateWorkSheet() {
        this.advancedCreateWorkSheet(1200, 800);
    }

    public void advancedAddHeaderMM(String title) {
        this.addHeader("2.0", title, "algorithm by Michael Maur <mmaur@web.de>");
    }

    public void advancedArrayReduction(String arrayID, Node node, int[] theArray) {
        this.addArray(arrayID, node, "color blue fillColor white elementColor black elemHighlight red cellHighlight gray horizontal", theArray.length, theArray, null, new TimeOffset(0), null);
    }

    public void advancedArrayReduction(String arrayID, Node node, String[] theArray) {
        this.addArray(arrayID, node, "color blue fillColor white elementColor black elemHighlight red cellHighlight gray horizontal", theArray.length, theArray, null, new TimeOffset(0), null);
    }

    public void advancedArrayReduction(String arrayID, Node node, String theString) {
        this.addArray(arrayID, node, "color blue fillColor white elementColor black elemHighlight red cellHighlight gray horizontal", theString.length(), theString, null, new TimeOffset(0), null);
    }

    public void advancedArrayStandard(String arrayID, Node node, int[] theArray) {
        this.addArray(arrayID, node, "color blue fillColor white elementColor black elemHighlight red cellHighlight yellow horizontal", theArray.length, theArray, null, new TimeOffset(0), null);
    }

    public void advancedArrayStandard(String arrayID, Node node, String[] theArray) {
        this.addArray(arrayID, node, "color blue fillColor white elementColor black elemHighlight red cellHighlight yellow horizontal", theArray.length, theArray, null, new TimeOffset(0), null);
    }

    public void advancedArrayStandard(String arrayID, Node node, String theString) {
        this.addArray(arrayID, node, "color blue fillColor white elementColor black elemHighlight red cellHighlight yellow horizontal", theString.length(), theString, null, new TimeOffset(0), null);
    }

    public void advancedHighlightArrayCells(String arrayID, int beginIndex, int endIndex) {
        if (beginIndex >= 0 && endIndex >= 0 && beginIndex <= endIndex) {
            this.compositeStepStart();
            int i = beginIndex;
            while (i <= endIndex) {
                this.highlightArrayCell(arrayID, i, null, new TimeOffset(0));
                ++i;
            }
            this.compositeStepEnd();
        }
    }

    public void advancedHighlightArrayCell(String arrayID, int index) {
        this.highlightArrayCell(arrayID, index, null, new TimeOffset(0));
    }

    public void advancedUnhighlightArrayCells(String arrayID, int beginIndex, int endIndex) {
        if (beginIndex >= 0 && endIndex >= 0 && beginIndex <= endIndex) {
            this.compositeStepStart();
            int i = beginIndex;
            while (i <= endIndex) {
                this.unhighlightArrayCell(arrayID, i, null, new TimeOffset(0));
                ++i;
            }
            this.compositeStepEnd();
        }
    }

    public void advancedUnhighlightArrayCell(String arrayID, int index) {
        this.unhighlightArrayCell(arrayID, index, null, new TimeOffset(0));
    }

    public void advancedHighlightArrayElems(String arrayID, int beginIndex, int endIndex) {
        if (beginIndex >= 0 && endIndex >= 0 && beginIndex <= endIndex) {
            this.compositeStepStart();
            int i = beginIndex;
            while (i <= endIndex) {
                this.highlightArrayElem(arrayID, i, null, new TimeOffset(0));
                ++i;
            }
            this.compositeStepEnd();
        }
    }

    public void advancedHighlightArrayElem(String arrayID, int index) {
        this.highlightArrayElem(arrayID, index, null, new TimeOffset(0));
    }

    public void advancedUnhighlightArrayElems(String arrayID, int beginIndex, int endIndex) {
        if (beginIndex >= 0 && endIndex >= 0 && beginIndex <= endIndex) {
            this.compositeStepStart();
            int i = beginIndex;
            while (i <= endIndex) {
                this.unhighlightArrayElem(arrayID, i, null, new TimeOffset(0));
                ++i;
            }
            this.compositeStepEnd();
        }
    }

    public void advancedUnhighlightArrayElem(String arrayID, int index) {
        this.unhighlightArrayElem(arrayID, index, null, new TimeOffset(0));
    }

    public void advancedHighlightArrayElemSwitch(String arrayID, int toUnhighlight, int toHighlight) {
        this.compositeStepStart();
        this.advancedUnhighlightArrayElem(arrayID, toUnhighlight);
        this.advancedHighlightArrayElem(arrayID, toHighlight);
        this.compositeStepEnd();
    }

    public void advancedCodeGroupConfig(String groupID, Node node, String options, TimeOffset timeOffset, String[] lines, int[] indentations, String[] lineNames) {
        int[] indents = indentations;
        String[] lineN = lineNames;
        if (lines != null) {
            int cfr_ignored_0 = lines.length;
        }
        try {
            this.checkID(groupID);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        boolean initializeIndentations = false;
        boolean initializeLineNames = false;
        if (indents == null) {
            indents = new int[lines.length];
            initializeIndentations = true;
        }
        if (lineN == null) {
            lineN = new String[lines.length];
            initializeLineNames = true;
        }
        int i = 0;
        while (i < lines.length) {
            if (initializeIndentations) {
                indents[i] = 0;
            }
            ++i;
        }
        if (indents.length == lineN.length) {
            int cfr_ignored_1 = indents.length;
            int cfr_ignored_2 = lines.length;
        }
        this.compositeStepStart();
        this.addCodeGroup(groupID, node, options, timeOffset);
        i = 0;
        while (i < lines.length) {
            this.addCodeLine(lines[i], lineN[i], groupID, indents[i], new TimeOffset(0));
            ++i;
        }
        this.compositeStepEnd();
    }

    public void advancedCodeGroupConfig(String groupID, Node node, String options, TimeOffset timeOffset, String[] lines, int[] indentations) {
        this.advancedCodeGroupConfig(groupID, node, options, timeOffset, lines, indentations, null);
    }

    public void advancedCodeGroupConfig(String groupID, Node node, String options, TimeOffset timeOffset, String[] lines) {
        this.advancedCodeGroupConfig(groupID, node, options, timeOffset, lines, null);
    }

    public void advancedCodeGroupStandard(String groupID, Node node, TimeOffset timeOffset, String[] lines, int[] indentations) {
        this.advancedCodeGroupConfig(groupID, node, "color black highlightColor red contextColor red", timeOffset, lines, indentations, null);
    }

    public void advancedCodeGroupStandard(String groupID, Node node, TimeOffset timeOffset, String[] lines) {
        this.advancedCodeGroupStandard(groupID, node, timeOffset, lines, null);
    }

    public void advancedTextLine(String lineID, Node node, String options, TimeOffset timeOffset, String lineContent) {
        try {
            this.checkID(lineID);
            this.checkString(lineContent);
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        this.compositeStepStart();
        this.addCodeGroup(String.valueOf(lineID) + "_group", node, options, timeOffset);
        this.addCodeLine(lineContent, lineID, String.valueOf(lineID) + "_group", 0, new TimeOffset(0));
        this.compositeStepEnd();
    }
}

