/*
 * Decompiled with CFR 0.152.
 */
package algoanim.variables;

import algoanim.variables.Variable;
import algoanim.variables.VariableFactory;
import java.util.HashMap;

public class VariableContext {
    protected VariableContext father = null;
    protected VariableContext son = null;
    private HashMap<String, Variable> variables = new HashMap();

    public VariableContext() {
    }

    public VariableContext(VariableContext myFather) {
        this();
        this.father = myFather;
    }

    public VariableContext dropSon() {
        this.son = null;
        return this;
    }

    public void defineKey(String type, String key) {
        this.variables.put(key, VariableFactory.newVariable(type));
    }

    public void defineKey(String type, String key, String value) {
        this.defineKey(type, key);
        this.setValue(key, value);
    }

    public void deleteKey(String key) {
        if (this.variables.containsKey(key)) {
            this.variables.remove(key);
        } else if (this.father != null) {
            this.father.deleteKey(key);
        }
    }

    public Variable getVariable(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.get(key);
        }
        if (this.father != null) {
            return this.father.getVariable(key);
        }
        return null;
    }

    public Integer getInt(String key) {
        return this.getVariable(key).getValue(Integer.class);
    }

    public Float getFloat(String key) {
        return this.getVariable(key).getValue(Float.class);
    }

    public Boolean getBool(String key) {
        return this.getVariable(key).getValue(Boolean.class);
    }

    public String getString(String key) {
        return this.getVariable(key).getValue(String.class);
    }

    public HashMap<String, String> listContext() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : this.variables.keySet()) {
            res.put(key, this.variables.get(key).getValue(String.class));
        }
        if (this.father != null) {
            res.putAll(this.father.listGlobal());
        }
        return res;
    }

    public HashMap<String, String> listGlobal() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : this.variables.keySet()) {
            Variable var = this.variables.get(key);
            if (!var.isGlobal().booleanValue()) continue;
            res.put(key, var.getValue(String.class));
        }
        if (this.father != null) {
            res.putAll(this.father.listGlobal());
        }
        return res;
    }

    public HashMap<String, String> listAll() {
        if (this.father == null) {
            return this.listContext();
        }
        HashMap<String, String> res = this.father.listAll();
        for (String key : this.variables.keySet()) {
            res.put(key, this.variables.get(key).getValue(String.class));
        }
        if (this.father != null) {
            res.putAll(this.father.listGlobal());
        }
        return res;
    }

    public void setValue(String key, String value) {
        if (this.variables.containsKey(key)) {
            this.variables.get(key).setValue(value);
        } else if (this.father != null) {
            this.father.setValue(key, value);
        } else {
            System.err.println("variable not found: " + key);
        }
    }

    public void setGlobal(String key) {
        if (this.variables.containsKey(key)) {
            this.variables.get(key).setGlobal();
        }
    }

    public VariableContext contextOpen() {
        this.son = new VariableContext(this);
        return this.son;
    }

    public VariableContext contextClose() {
        return this.father.dropSon();
    }

    public VariableContext getContext() {
        if (this.son != null) {
            return this.son.getContext();
        }
        return this;
    }

    public static void main(String[] args) {
        VariableContext field = new VariableContext();
        field.defineKey("int", "global");
        field.setGlobal("global");
        field.setValue("global", "13");
        field.defineKey("int", "a");
        field.setValue("a", "5");
        field.defineKey("double", "b");
        field.setValue("b", "1.23456");
        field.defineKey("double", "b");
        field.setValue("b", "1.23456");
        System.out.println("erster Context: " + field.listAll());
        field = field.contextOpen();
        field.setValue("a", "3");
        field.defineKey("double", "b");
        field.setValue("b", "6.54321");
        field.defineKey("int", "c");
        field.setValue("c", "6.54321");
        field.setValue("global", "19");
        System.out.println("zweiter Context: " + field.listAll());
        field = field.contextClose();
        System.out.println("zurck zum ersten: " + field.listAll());
    }
}

