/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.primitives.Primitive;
import algoanim.primitives.generators.GeneratorInterface;
import algoanim.properties.StackProperties;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public abstract class VisualStack<T>
extends Primitive {
    private Stack<T> stack;
    private List<T> initContent;
    private Node upperLeft;
    private StackProperties properties;

    public VisualStack(GeneratorInterface g, Node upperLeftCorner, List<T> content, String name, DisplayOptions display, StackProperties sp) {
        super(g, display);
        if (upperLeftCorner == null) {
            throw new IllegalArgumentException("The coordinate of the upper left Node shouldn't be null!");
        }
        this.upperLeft = upperLeftCorner;
        this.initContent = content;
        this.stack = new Stack();
        if (this.initContent != null) {
            this.fillStack();
        }
        this.properties = sp;
        this.setName(name);
    }

    private void fillStack() {
        ListIterator<T> li = this.initContent.listIterator();
        while (li.hasNext()) {
            this.stack.push(li.next());
        }
    }

    public void push(T elem) {
        this.stack.push(elem);
    }

    public T pop() {
        return this.stack.pop();
    }

    public T top() {
        return this.stack.peek();
    }

    public boolean isEmpty() {
        return this.stack.empty();
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }

    public StackProperties getProperties() {
        return this.properties;
    }

    public Stack<T> getStack() {
        return this.stack;
    }

    public List<T> getInitContent() {
        return this.initContent;
    }
}

