/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.exceptions.NotEnoughNodesException;
import algoanim.primitives.Primitive;
import algoanim.primitives.generators.PolygonGenerator;
import algoanim.properties.PolygonProperties;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;

public class Polygon
extends Primitive {
    private PolygonGenerator generator = null;
    private Node[] nodes;
    private PolygonProperties properties;

    public Polygon(PolygonGenerator pg, Node[] theNodes, String name, DisplayOptions display, PolygonProperties pp) throws NotEnoughNodesException {
        super(pg, display);
        if (theNodes.length < 2) {
            throw new NotEnoughNodesException("A polygon needs at least 2 points.");
        }
        this.nodes = theNodes;
        this.properties = pp;
        this.generator = pg;
        this.setName(name);
        this.generator.create(this);
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public PolygonProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

