/*
 * Decompiled with CFR 0.152.
 */
package algoanim.interactionsupport;

import algoanim.interactionsupport.InteractiveQuestion;
import algoanim.primitives.generators.Language;
import java.util.Collection;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultipleSelectionQuestion
extends InteractiveQuestion {
    public static final String INVALID_OPTION = "INVALID";
    protected int numberOfAnswerOptions = 0;
    protected HashMap<String, Boolean> correctnessStatus = new HashMap(11);
    protected HashMap<String, String> answerOptions = new HashMap(11);
    protected HashMap<String, Integer> pointsForAnswer = new HashMap(11);

    public MultipleSelectionQuestion(Language lang, String id) {
        super(lang, id);
    }

    public String addAnswerOption(String option) {
        if (option != null && option.length() > 0) {
            String id = String.valueOf(++this.numberOfAnswerOptions);
            this.answerOptions.put(id, option);
            return id;
        }
        return INVALID_OPTION;
    }

    public String addAnswerOption(String option, boolean isCorrect, String feedbackString, int points) {
        String id = this.addAnswerOption(option);
        this.setCorrectnessStatus(id, isCorrect);
        this.setFeedbackForAnswerOption(id, feedbackString);
        this.setPointsForAnswer(id, points);
        return id;
    }

    public Set<String> getAnswerSet() {
        return this.answerOptions.keySet();
    }

    public Object[] getAnswerArray() {
        return this.answerOptions.keySet().toArray();
    }

    public String getAnswerString(String questionID) {
        return this.answerOptions.get(questionID);
    }

    public Boolean getCorrectnessStatus(String questionID) {
        return this.correctnessStatus.get(questionID);
    }

    public String getFeedbackForOption(String id) {
        return (String)this.feedback.get(id);
    }

    public int getPointsForOption(String id) {
        Integer nrPoints = this.pointsForAnswer.get(id);
        if (nrPoints != null) {
            return nrPoints;
        }
        return 0;
    }

    @Override
    public void setPointsPossible(int nrPoints) {
        int localSum = 0;
        Collection<Integer> pointList = this.pointsForAnswer.values();
        for (Integer point : pointList) {
            if (point <= 0) continue;
            localSum += point.intValue();
        }
        this.pointsPossible = localSum;
    }

    public void setCorrectnessStatus(String id, boolean isCorrect) {
        if (this.answerOptions.containsKey(id)) {
            this.correctnessStatus.put(id, new Boolean(isCorrect));
            int pp = this.getPointsPossible();
            if (pp == 0) {
                pp = 1;
            }
            if (!this.pointsForAnswer.containsKey(id)) {
                this.pointsForAnswer.put(id, pp);
            }
        } else {
            throw new NoSuchElementException("There is no answer with ID " + id);
        }
    }

    public void setFeedbackForAnswerOption(String id, String feedbackString) {
        this.feedback.put(id, feedbackString);
    }

    public void setPointsForAnswer(String id, int points) {
        this.pointsForAnswer.put(id, points);
        if (points > 0) {
            this.pointsPossible += points;
        }
    }
}

