/*
 * Decompiled with CFR 0.152.
 */
package algoanim.annotations;

import algoanim.annotations.Executor;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Variables;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Annotation {
    public static final String LABEL = "label";
    public static final String DECLARE = "declare";
    public static final String SET = "set";
    public static final String DISCARD = "discard";
    public static final String INC = "inc";
    public static final String DEC = "dec";
    public static final String EVAL = "eval";
    public static final String HIGHLIGHT = "highlight";
    public static final String GLOBAL = "global";
    public static final String OPENCONTEXT = "openContext";
    public static final String CLOSECONTEXT = "closeContext";
    private String name;
    private Vector<String> parameters = new Vector();

    public Annotation(String name) {
        this.name = name;
    }

    public void addParameter(String param) {
        this.parameters.add(param);
    }

    public String toString() {
        String res = "@" + this.name;
        if (this.parameters.size() > 0) {
            res = String.valueOf(res) + "(";
            int i = 0;
            while (i < this.parameters.size()) {
                res = String.valueOf(res) + "\"" + this.parameters.get(i) + "\"";
                if (i != this.parameters.size() - 1) {
                    res = String.valueOf(res) + ", ";
                }
                ++i;
            }
            res = String.valueOf(res) + ")";
        }
        return res;
    }

    public static Vector<Annotation> parse(String line) {
        Vector<Annotation> result = new Vector<Annotation>();
        String value = "[a-zA-Z0-9,.-_ ]+";
        String regexp = "@([a-zA-Z]+)(?:\\((\"" + value + "\"(, \"" + value + "\")*)?\\))?";
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(line);
        while (m.find()) {
            String name = m.group(1);
            String options = m.group(2);
            Annotation props = new Annotation(name);
            if (options != null) {
                String par_re = "\"(" + value + ")\"";
                Pattern par_p = Pattern.compile(par_re);
                Matcher par_m = par_p.matcher(options);
                while (par_m.find()) {
                    props.addParameter(par_m.group(1));
                }
            }
            result.add(props);
        }
        return result;
    }

    public static void main(String[] args) {
        Annotation.parse("@name(\"p1\", \"p2\", \"p3\") @another @nochwas(\"23d\")");
        Annotation.parse("pseudocode // @blubb");
        Annotation.parse("pseudocode // @blubb()");
        Annotation.parse("pseudocode // @bla(\"abc\")");
        Annotation.parse("pseudocode // @wasanders(\"abc\", \"def\")");
        Annotation.parse("pseudocode // @wasanders(\"abc\", \"def ein text mit leerzeichen\")");
        Annotation.parse("pseudocode // @adsfasf(\"abc\", \"12\")");
    }

    public String getName() {
        return this.name;
    }

    public Vector<String> getParameters() {
        return this.parameters;
    }

    public Executor getExecutor(Variables vars, SourceCode src) {
        return null;
    }
}

