/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.primitives.ArrayBasedQueue;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.StringArray;
import algoanim.primitives.generators.ArrayBasedQueueGenerator;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.Node;
import algoanim.util.Timing;
import java.awt.Color;
import java.util.List;

public class AnimalArrayBasedQueueGenerator<T>
extends AnimalGenerator
implements ArrayBasedQueueGenerator<T> {
    private static int count = 1;
    private Node upperLeft;
    private ArrayProperties ap;
    private StringArray array;
    private String[] data;
    private int head = -1;
    private int tail = -1;
    private int capacity;
    private ArrayMarker head_am;
    private ArrayMarker tail_am;
    private ArrayMarker ht_am;
    private boolean hiddenProp;
    private boolean tail_am_hidden;
    private boolean highlightedFrontElem;
    private boolean highlightedFrontCell;
    private boolean highlightedTailElem;
    private boolean highlightedTailCell;

    public AnimalArrayBasedQueueGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ArrayBasedQueue<T> abq) {
        if (this.isNameUsed(abq.getName()) || abq.getName() == "") {
            abq.setName("ArrayBasedQueue" + count);
            ++count;
        }
        this.upperLeft = abq.getUpperLeft();
        this.ap = new ArrayProperties();
        this.ap.set("color", abq.getProperties().get("color"));
        this.ap.set("fillColor", Color.WHITE);
        this.ap.set("elementColor", abq.getProperties().get("elementColor"));
        this.ap.set("elemHighlight", abq.getProperties().get("elemHighlight"));
        this.ap.set("cellHighlight", abq.getProperties().get("cellHighlight"));
        this.ap.set("depth", abq.getProperties().get("depth"));
        this.hiddenProp = (Boolean)abq.getProperties().get("hidden");
        this.ap.set("hidden", this.hiddenProp);
        this.capacity = abq.getCapacity();
        this.data = new String[this.capacity];
        int i = 0;
        while (i < this.capacity) {
            this.data[i] = "";
            ++i;
        }
        List content = abq.getInitContent();
        if (content != null) {
            if (content.size() > abq.getCapacity()) {
                throw new ArrayIndexOutOfBoundsException("The initial content of the ArrayBasedQueue has " + content.size() + " elements, but it may" + " not have more elements as the capacity of the ArrayBasedQueue" + " = " + abq.getCapacity());
            }
            int i2 = 0;
            while (i2 < content.size()) {
                this.data[i2] = content.get(i2).toString();
                ++this.tail;
                ++i2;
            }
        }
        ArrayDisplayOptions ado = (ArrayDisplayOptions)abq.getDisplayOptions();
        this.array = this.lang.newStringArray(this.upperLeft, this.data, "", ado, this.ap);
        ArrayMarkerProperties tail_amp = new ArrayMarkerProperties();
        tail_amp.set("label", "tail");
        tail_amp.set("color", this.ap.get("color"));
        tail_amp.set("depth", this.ap.get("depth"));
        tail_amp.set("hidden", this.hiddenProp);
        ArrayMarkerProperties head_amp = new ArrayMarkerProperties();
        head_amp.set("label", "head");
        head_amp.set("color", this.ap.get("color"));
        head_amp.set("depth", this.ap.get("depth"));
        head_amp.set("hidden", this.hiddenProp);
        ArrayMarkerProperties ht_amp = new ArrayMarkerProperties();
        ht_amp.set("label", "head, tail");
        ht_amp.set("color", this.ap.get("color"));
        ht_amp.set("depth", this.ap.get("depth"));
        ht_amp.set("hidden", this.hiddenProp);
        this.head_am = this.lang.newArrayMarker(this.array, 0, "head", ado == null ? null : ado.getOffset(), head_amp);
        this.ht_am = this.lang.newArrayMarker(this.array, 0, "head_tail", ado == null ? null : ado.getOffset(), ht_amp);
        if (this.tail == -1) {
            this.tail_am = this.lang.newArrayMarker(this.array, 0, "tail", ado == null ? null : ado.getOffset(), tail_amp);
            this.tail_am.hide();
            this.tail_am_hidden = true;
            this.head_am.hide();
            this.ht_am.hide();
        } else {
            this.head = 0;
            if (this.tail == this.head) {
                this.head_am.hide();
            } else {
                this.ht_am.hide();
                this.tail_am = this.lang.newArrayMarker(this.array, this.tail, "tail", ado == null ? null : ado.getOffset(), tail_amp);
            }
        }
    }

    @Override
    public void dequeue(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        int newHead = -1;
        if (this.highlightedFrontCell) {
            this.unhighlightFrontCell(abq, delay, duration);
        }
        if (this.highlightedFrontElem) {
            this.unhighlightFrontElem(abq, delay, duration);
        }
        if (this.head == this.tail) {
            this.ht_am.hide(delay);
            this.tail = -1;
        } else {
            newHead = (this.head + 1) % this.capacity;
            this.lang.nextStep(0);
            this.head_am.move(newHead, delay, duration);
            if (newHead == this.tail) {
                this.tail_am.hide(delay);
                this.tail_am_hidden = true;
                this.head_am.hide(delay);
                this.lang.nextStep(0);
                this.ht_am.move(newHead, delay, duration);
                if (!this.hiddenProp) {
                    this.ht_am.show();
                }
            }
        }
        this.array.put(this.head, "", delay, duration);
        this.head = newHead;
    }

    @Override
    public void enqueue(ArrayBasedQueue<T> abq, T elem, Timing delay, Timing duration) {
        if (this.highlightedTailCell) {
            this.unhighlightTailCell(abq, delay, duration);
        }
        if (this.highlightedTailElem) {
            this.unhighlightTailElem(abq, delay, duration);
        }
        if (this.tail == -1) {
            this.head = 0;
            this.lang.nextStep(0);
            this.ht_am.move(0, delay, duration);
            if (!this.hiddenProp) {
                this.ht_am.show(delay);
            }
        } else if (this.tail == this.head) {
            this.ht_am.hide(delay);
            this.lang.nextStep(0);
            this.head_am.move(this.head, delay, duration);
            if (!this.hiddenProp) {
                this.head_am.show(delay);
            }
        }
        this.tail = (this.tail + 1) % this.capacity;
        this.lang.nextStep(0);
        this.tail_am.move(this.tail, delay, duration);
        this.array.put(this.tail, elem.toString(), delay, duration);
        if (this.tail != this.head && this.tail_am_hidden && !this.hiddenProp) {
            this.tail_am.show(delay);
            this.tail_am_hidden = false;
        }
    }

    @Override
    public void front(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.highlightFrontCell(abq, delay, duration);
        this.highlightFrontElem(abq, delay, duration);
    }

    @Override
    public void highlightFrontCell(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.highlightCell(this.head, delay, duration);
        this.highlightedFrontCell = true;
    }

    @Override
    public void highlightFrontElem(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.highlightElem(this.head, delay, duration);
        this.highlightedFrontElem = true;
    }

    @Override
    public void highlightTailCell(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.highlightCell(this.tail, delay, duration);
        this.highlightedTailCell = true;
    }

    @Override
    public void highlightTailElem(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.highlightElem(this.tail, delay, duration);
        this.highlightedTailElem = true;
    }

    @Override
    public void isEmpty(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
    }

    @Override
    public void isFull(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
    }

    @Override
    public void tail(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.highlightTailCell(abq, delay, duration);
        this.highlightTailElem(abq, delay, duration);
    }

    @Override
    public void unhighlightFrontCell(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.unhighlightCell(this.head, delay, duration);
        this.highlightedFrontCell = false;
    }

    @Override
    public void unhighlightFrontElem(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.unhighlightElem(this.head, delay, duration);
        this.highlightedFrontElem = false;
    }

    @Override
    public void unhighlightTailCell(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.unhighlightCell(this.tail, delay, duration);
        this.highlightedTailCell = false;
    }

    @Override
    public void unhighlightTailElem(ArrayBasedQueue<T> abq, Timing delay, Timing duration) {
        this.array.unhighlightElem(this.tail, delay, duration);
        this.highlightedTailElem = false;
    }
}

