/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.interactionsupport.DocumentationLink;
import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.GroupInfo;
import algoanim.interactionsupport.InteractiveElement;
import algoanim.interactionsupport.InteractiveQuestion;
import algoanim.interactionsupport.MultipleChoiceQuestion;
import algoanim.interactionsupport.MultipleSelectionQuestion;
import algoanim.interactionsupport.TrueFalseQuestion;
import algoanim.interactionsupport.generators.InteractiveElementGenerator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Calendar;

public class AVInteractionTextGenerator
extends AnimalGenerator
implements InteractiveElementGenerator {
    private StringBuilder idc = new StringBuilder(24096);
    private String fileName;

    public AVInteractionTextGenerator(AnimalScript as) {
        this(as, null);
    }

    public AVInteractionTextGenerator(AnimalScript as, String key) {
        super(as);
        if (key == null) {
            Calendar cal = Calendar.getInstance();
            StringBuilder sb = new StringBuilder(30);
            sb.append("intDef");
            this.formatTwoCharKey(sb, cal.get(1));
            this.formatTwoCharKey(sb, cal.get(2));
            this.formatTwoCharKey(sb, cal.get(5));
            this.formatTwoCharKey(sb, cal.get(11));
            this.formatTwoCharKey(sb, cal.get(12));
            this.formatTwoCharKey(sb, cal.get(13));
            this.formatTwoCharKey(sb, cal.get(14));
            sb.append(".txt");
            this.fileName = sb.toString();
        } else {
            this.fileName = key;
        }
        as.addLine("interactionDefinition \"" + this.fileName + "\"");
    }

    private void formatTwoCharKey(StringBuilder sb, int value) {
        if (value < 10) {
            sb.append("0");
        }
        sb.append(value);
    }

    @Override
    public void createInteractiveElementCode(InteractiveElement element) {
        if (element instanceof TrueFalseQuestion) {
            this.createTFQuestionCode((TrueFalseQuestion)element);
        } else if (element instanceof MultipleChoiceQuestion) {
            this.createMCQuestionCode((MultipleChoiceQuestion)element);
        } else if (element instanceof MultipleSelectionQuestion) {
            this.createMSQuestionCode((MultipleSelectionQuestion)element);
        } else if (element instanceof DocumentationLink) {
            this.createDocumentationLinkCode((DocumentationLink)element);
        } else if (element instanceof FillInBlanksQuestion) {
            this.createFIBQuestionCode((FillInBlanksQuestion)element);
        } else if (element instanceof GroupInfo) {
            this.createGroupInfoCode((GroupInfo)element);
        }
    }

    @Override
    public void createDocumentationLink(DocumentationLink docuLink) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("interaction \"").append(docuLink.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createDocumentationLinkCode(DocumentationLink docuLink) {
        this.idc.append("documentation \"").append(docuLink.getID());
        this.idc.append("\"\n\"").append(docuLink.getTargetURI().toString());
        this.idc.append("\"\nendtext");
        this.idc.append("\n\n");
    }

    public void createGroupInfoCode(GroupInfo group) {
        this.idc.append("groupInfo \"").append(group.getID());
        this.idc.append("\"\n  ").append("nrRepeats ").append(group.getNrRepeats());
        this.idc.append("\nendtext");
        this.idc.append("\n\n");
    }

    @Override
    public void createTFQuestion(TrueFalseQuestion q) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("interaction \"").append(q.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    private void createStandardCode(String tag, InteractiveQuestion question) {
        this.idc.append(tag).append(" \"").append(question.getID()).append("\"");
        if (question.getPointsPossible() > 0) {
            this.idc.append("\n  points ").append(question.getPointsPossible());
        }
        if (question.getQuestionGroup() != null) {
            this.idc.append("\n  questionGroup \"");
            this.idc.append(question.getQuestionGroup()).append("\"");
        }
        this.idc.append("\n\"").append(question.getPrompt());
        this.idc.append("\"\nendtext");
    }

    public void createTFQuestionCode(TrueFalseQuestion tfQuestion) {
        this.createStandardCode("tfQuestion", tfQuestion);
        this.idc.append("\n  answer\n");
        this.idc.append(tfQuestion.getAnswerStatus() ? "t" : "f");
        this.idc.append("\nendAnswer");
        String comment = tfQuestion.getFeedbackForOption(!tfQuestion.getAnswerStatus());
        if (comment != null) {
            this.idc.append("\n  comment\n\"").append(comment);
            this.idc.append("\"\n  endComment");
        }
        this.idc.append("\n\n");
    }

    @Override
    public void createFIBQuestion(FillInBlanksQuestion q) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("interaction \"").append(q.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createFIBQuestionCode(FillInBlanksQuestion fibQuestion) {
        this.createStandardCode("fibQuestion", fibQuestion);
        this.idc.append("\n  answer\n\"");
        this.idc.append(fibQuestion.getAnswer());
        this.idc.append("\"\nendAnswer");
        this.idc.append("\n  comment\n\"");
        this.idc.append(fibQuestion.getFeedback());
        this.idc.append("\"\n  endComment");
        this.idc.append("\n\n");
    }

    @Override
    public void createMCQuestion(MultipleChoiceQuestion mcQuestion) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("interaction \"").append(mcQuestion.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createMCQuestionCode(MultipleChoiceQuestion mcQuestion) {
        String comment = null;
        String prompt = null;
        this.createStandardCode("mcQuestion", mcQuestion);
        Object[] answerKeys = mcQuestion.getAnswerArray();
        int i = 1;
        while (i <= answerKeys.length) {
            int points;
            prompt = mcQuestion.getAnswerString("" + i);
            if (prompt != null) {
                this.idc.append("\n\"").append(prompt).append("\"\nendChoice");
            }
            if ((points = mcQuestion.getPointsForOption("" + i)) != 0) {
                this.idc.append("\n  points ").append(points);
            }
            if ((comment = mcQuestion.getFeedbackForOption("" + i)) != null) {
                this.idc.append("\n  comment\n\"").append(comment).append("\"");
                this.idc.append("\n  endComment");
            }
            ++i;
        }
        this.idc.append("\n  answer\n").append(mcQuestion.getCorrectAnswerID());
        this.idc.append("\nendAnswer\n\n");
    }

    @Override
    public void createMSQuestion(MultipleSelectionQuestion msQuestion) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("interaction \"").append(msQuestion.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createMSQuestionCode(MultipleSelectionQuestion msQuestion) {
        String comment = null;
        String prompt = null;
        this.createStandardCode("mcQuestion", msQuestion);
        StringBuilder fakeID = new StringBuilder(32);
        Object[] answerKeys = msQuestion.getAnswerArray();
        int i = 1;
        while (i <= answerKeys.length) {
            int points;
            prompt = msQuestion.getAnswerString("" + i);
            if (prompt != null) {
                this.idc.append("\n\"").append(prompt).append("\"\nendChoice");
            }
            if ((points = msQuestion.getPointsForOption("" + i)) != 0) {
                this.idc.append("\n  points ").append(points);
            }
            if ((comment = msQuestion.getFeedbackForOption("" + i)) != null) {
                this.idc.append("\n  comment\n\"").append(comment).append("\"");
                this.idc.append("\n  endComment");
            }
            if (msQuestion.getCorrectnessStatus("" + i) == Boolean.TRUE || points > 0) {
                fakeID.append("\n").append("" + i);
            }
            ++i;
        }
        this.idc.append("\n  answer").append(fakeID.toString());
        this.idc.append("\nendAnswer\n\n");
    }

    @Override
    public void finalizeInteractiveElements() {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(this.fileName));
            fw.write(this.idc.toString());
            ((Writer)fw).close();
            System.err.println("Wrote file " + this.fileName + ".");
        }
        catch (Exception ex) {
            System.err.println("Error while writing file:");
            System.err.println("Filename: " + this.fileName);
            System.err.println(ex.getMessage());
        }
    }
}

