/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.parser;

import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.GraphEntry;
import gfgaa.gui.graphs.basic.BasicGraphEntry;
import gfgaa.gui.others.GraphDataBase;
import gfgaa.gui.parser.BNFNode;
import gfgaa.gui.parser.ParserActionInterface;
import gfgaa.gui.parser.ParserTreeInterface;
import gfgaa.gui.parser.ParserUnit;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JEditorPane;

public final class GraphScriptParser
implements ParserTreeInterface {
    private boolean debug = false;
    private BNFNode root = new BNFNode(0, 1, "");
    private BNFNode lauf;
    private ParserUnit data = new ParserUnit(3, 2);

    public GraphScriptParser(GraphDataBase gb) {
        BNFNode knoten1 = new BNFNode(37, 1, "%");
        knoten1.newInstance(this.root);
        BNFNode knoten2 = new BNFNode(-3, 1, "graphscript");
        knoten2.newInstance(knoten1);
        int size = gb.size();
        BNFNode extension = new BNFNode(10, size + 2, "EOL");
        extension.newInstance(knoten2);
        extension.newInstance(extension);
        int i = 0;
        while (i < size) {
            GraphEntry entry = gb.get(i);
            if (entry.getTyp() == AbstractGraph.GRAPHTYP_BASIC) {
                ((BasicGraphEntry)entry).getSecondParserRoot().newInstance(extension);
            }
            entry.getParserRoot().newInstance(extension);
            ++i;
        }
    }

    private boolean testToken(StreamTokenizer tok, int type, int pos) {
        if (type == -3) {
            String sCode = this.lauf.getCode(pos);
            return tok.sval.equals(sCode) || sCode.equals("char");
        }
        return true;
    }

    private void retry(StreamTokenizer tok) throws IOException {
        if (this.data.give != this.data.done) {
            --this.data.give;
        }
        int type = tok.ttype;
        while (type != 10 && type != -1) {
            type = tok.nextToken();
        }
        do {
            int size = this.lauf.getLength();
            int i = 0;
            while (i < size) {
                if (this.lauf.getToken(i) == 10) {
                    this.lauf = this.lauf.setNext(i);
                    return;
                }
                ++i;
            }
            this.lauf = this.lauf.setNext(0);
        } while (this.lauf.getLength() != 0);
    }

    private void parseFile(ParserUnit data, Reader myReader) throws IOException {
        int type;
        StreamTokenizer tok = new StreamTokenizer(myReader);
        tok.eolIsSignificant(true);
        tok.lowerCaseMode(true);
        this.lauf = this.root;
        do {
            type = tok.nextToken();
            boolean correct = false;
            int gr = this.lauf.getLength() - 1;
            int a = -1;
            while (a < gr && !correct) {
                ++a;
                if (this.debug) {
                    System.out.print(a);
                }
                if (type != this.lauf.getToken(a)) continue;
                correct = this.testToken(tok, type, a);
            }
            if (this.debug) {
                System.out.print("?" + correct);
            }
            if (!correct) {
                if (data.state != 1) {
                    String keywordError = "Error in Line " + tok.lineno() + "\t-> Unknown or False Keyword ->" + " Found \"";
                    switch (tok.ttype) {
                        case -2: {
                            keywordError = String.valueOf(keywordError) + (int)tok.nval;
                            break;
                        }
                        case -3: {
                            keywordError = String.valueOf(keywordError) + tok.sval;
                            break;
                        }
                        case 10: {
                            keywordError = String.valueOf(keywordError) + "EOL";
                            break;
                        }
                        case -1: {
                            keywordError = String.valueOf(keywordError) + "EOF";
                            break;
                        }
                        default: {
                            keywordError = String.valueOf(keywordError) + (char)tok.ttype;
                        }
                    }
                    keywordError = String.valueOf(keywordError) + "\" instead of " + this.lauf.getCode(0);
                    gr = this.lauf.getLength();
                    a = 1;
                    while (a < gr) {
                        keywordError = String.valueOf(keywordError) + " | " + this.lauf.getCode(a);
                        ++a;
                    }
                    keywordError = String.valueOf(keywordError) + "\n\t-> Parser ignored this line\n";
                    data.errorMessages.add(keywordError);
                    this.retry(tok);
                    continue;
                }
                data.state = 7;
                data.errorMessages.add(0, "** Parsing stopped after Critical Errors.\n");
                return;
            }
            if (this.debug) {
                System.out.println(">> " + this.lauf.getCode(a));
            }
            this.lauf = this.lauf.setNext(a);
            ParserActionInterface act = this.lauf.getAction();
            if (act == null || act.execute(tok, data)) continue;
            this.retry(tok);
        } while (type != -1);
        switch (data.state) {
            case 1: {
                data.state = 7;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                data.state = 6;
                break;
            }
            default: {
                data.state = 7;
            }
        }
        data.errorMessages.add(0, "** Parsing finished with " + data.errorMessages.size() + " Error(s).\n");
        if (this.debug) {
            int i = 0;
            while (i < data.errorMessages.size()) {
                System.out.println(data.errorMessages.get(i));
                ++i;
            }
        }
    }

    public int parse(String filename) {
        if (this.debug) {
            System.out.println("STARTE PARSING [FILE]");
        }
        this.data.init();
        try {
            this.parseFile(this.data, new FileReader(filename));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return -1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -2;
        }
        return this.data.state;
    }

    public int parse(JEditorPane pane) {
        if (this.debug) {
            System.out.println("STARTE PARSING [PANE]");
        }
        this.data.init();
        try {
            this.parseFile(this.data, new StringReader(pane.getText()));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return -1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -2;
        }
        return this.data.state;
    }

    @Override
    public BNFNode getRoot() {
        return null;
    }

    public AbstractGraph getParsedGraph() {
        return this.data.graph;
    }

    public ArrayList<String> getErrorMessages() {
        return this.data.errorMessages;
    }
}

