/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.others;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphScriptPanel;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.exceptions.GraphTypeException;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.CreateGraphPanel;
import gfgaa.gui.graphs.GraphEntry;
import gfgaa.gui.graphs.KantenPanelInterface;
import gfgaa.gui.graphs.MatrixPanelInterface;
import gfgaa.gui.others.LanguageInterface;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class GraphDataBase {
    GraphAlgController mainclass;
    GraphEntry selected;
    ArrayList<GraphEntry> data;
    private HashMap<Integer, GraphEntry> link;

    public GraphDataBase(GraphAlgController mainclass) {
        this.mainclass = mainclass;
        this.data = new ArrayList();
        this.link = new HashMap();
    }

    public void addGraphType(GraphEntry entry) throws GraphTypeException {
        ArrayList<String> eMessage = new ArrayList<String>();
        if (!(entry.createCreateGraphPanel() instanceof CreateGraphPanel)) {
            eMessage.add("Error #01 -> The CreateGraphPanel must be an instance of the CreateGraphPanel.");
        }
        if (!(entry.createKantenPanel() instanceof KantenPanelInterface)) {
            eMessage.add("Error #02 -> The CreateGraphPanel must implement the KantenPanelInterface.");
        }
        if (!(entry.createMatrixPanel() instanceof MatrixPanelInterface)) {
            eMessage.add("Error #03 -> The CreateGraphPanel must implement the MatrixPanelInterface.");
        }
        if (!eMessage.isEmpty()) {
            throw new GraphTypeException(entry, eMessage);
        }
        this.addGraph(entry);
    }

    public void addGraph(GraphEntry entry) {
        if (this.link.containsKey(entry.getTyp())) {
            throw new IllegalArgumentException("GraphTyp is already contained.");
        }
        this.link.put(entry.getTyp(), entry);
        String refTitle = entry.getTitle();
        int size = this.data.size();
        int i = 0;
        while (i < size) {
            String title = this.get(i).getTitle();
            if (refTitle.compareTo(title) < 0) {
                this.data.add(i, entry);
                return;
            }
            ++i;
        }
        this.data.add(entry);
    }

    public void changeLanguageSettings() {
        ArrayList<GraphEntry> newData = new ArrayList<GraphEntry>();
        int size = this.data.size();
        int i = 0;
        while (i < size) {
            GraphEntry entry = this.get(i);
            String refTitle = entry.getTitle();
            boolean added = false;
            int j = 0;
            while (j < i && !added) {
                String title = this.get(j).getTitle();
                if (refTitle.compareTo(title) < 0) {
                    newData.add(j, entry);
                    added = true;
                }
                ++j;
            }
            if (!added) {
                newData.add(entry);
            }
            ++i;
        }
        this.data = newData;
    }

    public GraphEntry get(int pos) {
        return this.data.get(pos);
    }

    public int getIndex(GraphEntry entry) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            if (this.get(i) == entry) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        return this.data.size();
    }

    public void transfer() {
        GraphScriptPanel s = (GraphScriptPanel)this.mainclass.getPanel(6);
        s.showGraphData(this.selected.transfer().toString());
    }

    public void selectEntry(GraphEntry entry) {
        this.selected = entry;
    }

    public int getIndexOf(String title) {
        int size = this.data.size();
        int i = 0;
        while (i < size) {
            GraphEntry entry = this.data.get(i);
            if (entry.getTitle().equals(title)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void setGraph(AbstractGraph graph) {
        GraphEntry entry;
        this.selected = entry = this.link.get(graph.getGraphTyp());
        entry.setGraph(graph);
        this.mainclass.getPanel(1).refreshPanelComponents();
    }

    public AbstractGraph getSelectedGraph() {
        if (this.selected != null) {
            return this.selected.getGraph();
        }
        return null;
    }

    public Integer getGraphTyp() {
        return this.selected.getTyp();
    }

    public GraphEntry getSelectedEntry() {
        return this.selected;
    }

    public GraphEntry getEntry(int index) {
        return this.data.get(index);
    }

    public void showGraphTypDialog() {
        new GraphTypDialog().setVisible(true);
    }

    public void initialize() {
        this.selected = this.link.get(AbstractGraph.GRAPHTYP_BASIC);
    }

    private class GraphTypDialog
    extends JDialog
    implements LanguageInterface {
        private static final long serialVersionUID = -4992726681533122100L;

        public GraphTypDialog() {
            super((Frame)GraphDataBase.this.mainclass.getGUI(), true);
            if (GraphDataBase.this.mainclass.getLanguageSettings() == 0) {
                this.setTitle("Graphtypus Einstellungen");
            } else {
                this.setTitle("Graphtyp Settings");
            }
            this.setSize(330, 320);
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
            this.setContentPane(new GraphTypPanel());
        }

        void close() {
            this.setVisible(false);
        }

        private final class GraphTypPanel
        extends SPanel {
            private static final long serialVersionUID = -2911161207553048185L;
            private JButton create;
            private JButton exit;
            JComboBox typChooser;
            JScrollPane typDescr;

            public GraphTypPanel() {
                this.setLayout(null);
                this.createTypChooserComponents();
                this.add(this.createResetButton());
                this.add(this.createReturnButton());
                this.changeLanguageSettings(((GraphTypDialog)GraphTypDialog.this).GraphDataBase.this.mainclass.getLanguageSettings());
            }

            @Override
            public void paint(Graphics g) {
                int[] pos;
                Dimension size = this.getSize();
                pos = new int[]{(size.width - 210) / 2, (size.width - 275) / 2, pos[1] + 175, (size.height - 275) / 2, pos[3] + 250};
                this.typDescr.setLocation((size.width - 300) / 2, pos[3] + 40);
                this.typChooser.setLocation((size.width - 250) / 2, pos[3]);
                this.create.setLocation(pos[0], pos[4]);
                this.exit.setLocation(pos[0] + 110, pos[4]);
                super.paint(g);
            }

            private void createTypChooserComponents() {
                final JEditorPane typContent = new JEditorPane();
                typContent.setEditable(false);
                this.typDescr = new JScrollPane(typContent);
                this.typDescr.setSize(300, 190);
                this.typDescr.setBorder(BorderFactory.createEtchedBorder());
                this.typDescr.setVerticalScrollBarPolicy(22);
                this.add(this.typDescr);
                this.typChooser = new JComboBox();
                this.typChooser.setSize(250, 25);
                int size = ((GraphTypDialog)GraphTypDialog.this).GraphDataBase.this.data.size();
                int i = 0;
                while (i < size) {
                    this.typChooser.addItem(((GraphTypDialog)GraphTypDialog.this).GraphDataBase.this.data.get(i));
                    ++i;
                }
                this.typChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        typContent.setText(((GraphEntry)GraphTypPanel.this.typChooser.getSelectedItem()).getDescription());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).GraphTypPanel.this.typDescr.getVerticalScrollBar().setValue(0);
                            }
                        });
                    }
                });
                this.typChooser.setSelectedItem(((GraphTypDialog)GraphTypDialog.this).GraphDataBase.this.selected);
                this.add(this.typChooser);
            }

            private JButton createResetButton() {
                this.create = new JButton();
                this.create.setBounds(110, 260, 100, 25);
                this.add(new SComponent(this.create, new String[]{"Erzeugen", "Create"}, new String[]{"Erzeugt einen leeren Graphen des ausgew\u2030hlten Graphentypus.", "Creates an empty graph of the selected typ."}));
                this.create.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((GraphTypDialog)((GraphTypPanel)GraphTypPanel.this).GraphTypDialog.this).GraphDataBase.this.selected = (GraphEntry)GraphTypPanel.this.typChooser.getSelectedItem();
                        ((GraphTypDialog)((GraphTypPanel)GraphTypPanel.this).GraphTypDialog.this).GraphDataBase.this.selected.createGraph();
                        ((GraphTypDialog)((GraphTypPanel)GraphTypPanel.this).GraphTypDialog.this).GraphDataBase.this.mainclass.getPanel(1).refreshPanelComponents();
                        ((GraphTypDialog)((GraphTypPanel)GraphTypPanel.this).GraphTypDialog.this).GraphDataBase.this.mainclass.repaint();
                    }
                });
                return this.create;
            }

            private JButton createReturnButton() {
                this.exit = new JButton();
                this.exit.setBounds(215, 260, 100, 25);
                this.add(new SComponent(this.exit, new String[]{"Schlie\ufb02en", "Close"}, new String[]{"Schlie\ufb02t das Fenster.", "Closes the window."}));
                this.exit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GraphTypDialog.this.close();
                    }
                });
                return this.exit;
            }

            @Override
            public void refreshPanelComponents() {
            }
        }
    }
}

