/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs.basic;

import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.basic.Edge;
import gfgaa.gui.graphs.basic.Node;
import java.util.ArrayList;

public final class Graph
extends AbstractGraph {
    public Graph(boolean directed, boolean weighted) {
        super(18);
        this.setDirected(directed);
        this.setWeighted(weighted);
    }

    @Override
    public Integer getGraphTyp() {
        return AbstractGraph.GRAPHTYP_BASIC;
    }

    @Override
    public int maxsize() {
        return 18;
    }

    public void initializeNodeValues() {
        int anz = this.getNumberOfNodes();
        int i = 0;
        while (i < anz) {
            ((Node)this.getNode(i)).setNodeValue(0);
            ++i;
        }
    }

    public void initializeVisitedFlags() {
        int anz = this.getNumberOfNodes();
        int i = 0;
        while (i < anz) {
            ((Node)this.getNode(i)).setVisited(false);
            ++i;
        }
    }

    @Override
    public void setDirected(boolean directed) {
        if (!directed && this.isDirected()) {
            ArrayList<Edge> toRemove = new ArrayList<Edge>();
            int i = 0;
            while (i < this.getNumberOfNodes()) {
                Node node = (Node)this.getNode(i);
                int anz = node.getNumberOfEdges();
                int j = 0;
                while (j < anz) {
                    Edge edge = (Edge)node.getEdge(j);
                    String sTag = edge.getTag();
                    if (sTag.charAt(0) > sTag.charAt(3)) {
                        String sEdge = String.valueOf(sTag.charAt(3)) + "->" + sTag.charAt(0);
                        if (!this.containsTag(sEdge)) {
                            Node target = (Node)edge.getTarget();
                            Node source = (Node)edge.getSource();
                            Edge newEdge = new Edge(target, source, edge.getWeight());
                            target.addEdge(newEdge);
                            source.addAgainstEdge(newEdge);
                        }
                        toRemove.add(edge);
                    }
                    ++j;
                }
                ++i;
            }
            int anz = toRemove.size();
            int i2 = 0;
            while (i2 < anz) {
                this.removeEdge((Edge)toRemove.get(i2));
                ++i2;
            }
        }
        super.setDirected(directed);
    }
}

