/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs.basic;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.GraphEntry;
import gfgaa.gui.graphs.basic.CreateBasicGraphPanel;
import gfgaa.gui.graphs.basic.Edge;
import gfgaa.gui.graphs.basic.Graph;
import gfgaa.gui.graphs.basic.KantenPanel;
import gfgaa.gui.graphs.basic.MatrixPanel;
import gfgaa.gui.graphs.basic.Node;
import gfgaa.gui.graphs.basic.Uppercorner;
import gfgaa.gui.parser.BNFNode;
import gfgaa.gui.parser.bnftree.BasicTree;

public final class BasicGraphEntry
extends GraphEntry {
    private BasicTree parserTree = new BasicTree();

    public BasicGraphEntry(GraphAlgController mainclass) {
        super(mainclass);
        this.createGraph();
    }

    @Override
    public String getTitle() {
        if (this.mainclass.getLanguageSettings() == 0) {
            return "Basis Graph";
        }
        return "Basic graph";
    }

    @Override
    public String getDescription() {
        if (this.mainclass.getLanguageSettings() == 0) {
            return "Die Auswahl Basis Graph rep\u2030sentiert den\nStandard Graphen. Dieser kann gewichtet\noder ungewichtet, wie auch gerichtet oder\nungerichtet sein.\n\nDer Basis Graph kann maximal 18 Knoten\nenthalten. Seine Kantengewichte sind echt\npositiv und auf das Intervall [1, 99] beschr\u2030nkt.\n\nDiese Graphklasse eignet sich beispielsweise\nf\u00b8r DFS, Kruskal oder F\u2030rbungsproblem\nAnimationen.";
        }
        return "The selection basicgraph represents the\nstandard graph. This graphtyp can optionally\nbe weighted and/or directed.\n\nThe basic graph can contain up to 18 nodes.\nThe weights of the edges have to be strict\npositiv. Only integers from the interval of\n[1, 99] may be used.\n\nThis graphtyp is applicable e.g. for dfs, kruskal\nor graphcoloring animations.";
    }

    @Override
    public BNFNode getParserRoot() {
        return this.parserTree.getRoot();
    }

    public BNFNode getSecondParserRoot() {
        return this.parserTree.getSecondRoot();
    }

    @Override
    public AbstractGraph createGraph() {
        this.graph = new Graph(true, true);
        return this.graph;
    }

    @Override
    public void setGraph(AbstractGraph graph) {
        if (graph instanceof Graph) {
            this.graph = graph;
        }
    }

    @Override
    public StringBuffer transfer() {
        Edge edge;
        int j;
        Node node;
        boolean weighted;
        int transferModus = this.mainclass.getTransferMode();
        StringBuffer buf = new StringBuffer("%graphscript\n\n");
        if (transferModus == 1) {
            buf.append("matrix ");
        } else {
            buf.append("graph ");
        }
        buf.append(this.graph.getNumberOfNodes());
        if (this.graph.isDirected()) {
            buf.append(" directed");
        }
        if (weighted = this.graph.isWeighted()) {
            buf.append(" weighted\n\n");
        }
        if (this.graph.getCorner() == null) {
            this.graph.setCorner(new Uppercorner(0, 0));
        }
        buf.append("\ngraphcoordinates at " + this.graph.getCorner().x + " " + this.graph.getCorner().y + "\n\n");
        if (this.graph.getStartNode() != null) {
            buf.append("startknoten " + this.graph.getStartNode().getTag() + "\n");
        }
        if (this.graph.getTargetNode() != null) {
            buf.append("zielknoten " + this.graph.getTargetNode().getTag() + "\n\n");
        }
        StringBuffer edgeBuf = new StringBuffer("");
        int size = this.graph.getNumberOfNodes();
        int i = 0;
        while (i < size) {
            node = (Node)this.graph.getNode(i);
            buf.append("node " + node.getTag());
            buf.append(" at " + node.getXPos() + " " + node.getYPos() + "\n");
            if (transferModus == 0) {
                int anz = node.getNumberOfEdges();
                j = 0;
                while (j < anz) {
                    edge = (Edge)node.getEdge(j);
                    edgeBuf.append("edge " + edge.getSource().getTag());
                    edgeBuf.append(" " + edge.getTarget().getTag());
                    if (weighted) {
                        edgeBuf.append(" weight " + edge.getWeight());
                    }
                    edgeBuf.append("\n");
                    ++j;
                }
            }
            ++i;
        }
        if (transferModus == 1) {
            i = 0;
            while (i < size) {
                node = (Node)this.graph.getNode(i);
                edgeBuf.append("[");
                j = 0;
                while (j < size) {
                    edge = (Edge)node.getEdgeTo(this.graph.getNode(j));
                    if (edge == null) {
                        edgeBuf.append("0");
                    } else if (weighted) {
                        edgeBuf.append(edge.getWeight());
                    } else {
                        edgeBuf.append("1");
                    }
                    if (++j == size) continue;
                    edgeBuf.append("|");
                }
                edgeBuf.append("]\n");
                ++i;
            }
        }
        buf.append("\n");
        buf.append(edgeBuf);
        buf.append("\n");
        return buf;
    }

    @Override
    public SPanel createKantenPanel() {
        return new KantenPanel(this.mainclass);
    }

    @Override
    public SPanel createMatrixPanel() {
        return new MatrixPanel(this.mainclass);
    }

    @Override
    public SPanel createCreateGraphPanel() {
        return new CreateBasicGraphPanel(this.mainclass);
    }
}

