/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.components;

import gfgaa.gui.components.SComponent;
import gfgaa.gui.others.LanguageInterface;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class SPanel
extends JPanel
implements LanguageInterface {
    private static final long serialVersionUID = -7451788822691266894L;
    private JTabbedPane tabs;
    private Vector<SPanel> containedPanels = new Vector(1, 1);
    private Vector<SComponent> langComponents = new Vector(1, 1);

    private String[] convertArray(String[][] translations) {
        int t = 0;
        String[] trans = new String[translations.length * translations[0].length];
        int i = 0;
        while (i < translations[0].length) {
            int j = 0;
            while (j < translations.length) {
                trans[t++] = translations[j][i];
                ++j;
            }
            ++i;
        }
        return trans;
    }

    private int[] subArray(int[] iArray, int start, int end) {
        int[] nArray = new int[end - start];
        int j = 0;
        int i = start;
        while (i < end) {
            nArray[j] = iArray[i];
            ++j;
            ++i;
        }
        return nArray;
    }

    protected void add(SPanel panel, boolean bFlag) {
        this.containedPanels.add(panel);
        if (bFlag) {
            this.add(panel);
        }
    }

    protected void setTabbedPane(JTabbedPane tabs, String[][] translations) {
        this.add(new SComponent(tabs, this.convertArray(translations)));
        this.tabs = tabs;
    }

    protected SPanel getPanelAtTab(int pos) {
        return this.containedPanels.get(pos);
    }

    protected int getNumberOfTabs() {
        return this.containedPanels.size();
    }

    protected boolean hasTabbedPanels() {
        return this.tabs != null;
    }

    public void changeLanguageSettings(int languageFlag) {
        int i = 0;
        while (i < this.containedPanels.size()) {
            this.containedPanels.get(i).changeLanguageSettings(languageFlag);
            ++i;
        }
        i = 0;
        while (i < this.langComponents.size()) {
            this.langComponents.get(i).changeLanguageSettings(languageFlag);
            ++i;
        }
    }

    public void setTopLevelPanel(int[] panelId) {
        int l = panelId.length;
        if (panelId == null || l <= 0) {
            return;
        }
        if (panelId[0] > -1 && panelId[0] < this.getNumberOfTabs()) {
            SPanel sub;
            this.tabs.setSelectedIndex(panelId[0]);
            if (l > 1 && (sub = this.getPanelAtTab(panelId[0])).hasTabbedPanels()) {
                sub.setTopLevelPanel(this.subArray(panelId, 1, panelId.length));
            }
            this.repaint();
        }
    }

    public abstract void refreshPanelComponents();

    protected void add(SComponent comp) {
        this.langComponents.add(comp);
    }

    protected SComponent get(int pos) {
        return this.langComponents.get(pos);
    }

    protected Object getAsObject(int pos) {
        return this.langComponents.get(pos);
    }

    protected int getLangComponentCount() {
        return this.langComponents.size();
    }
}

