/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.components;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.components.IntegerTextFieldEx;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.others.ProgressDialog;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CodePreview
extends JDialog {
    private static final long serialVersionUID = -6414656080255443396L;
    private GraphAlgController mainclass;
    private CodePreviewPanel.InfoDialog infoDialog;
    private Vector sCode;
    private CodePreview cpv = this;

    public CodePreview(Vector sCode, GraphAlgController mainclass) {
        super((Frame)mainclass.getGUI(), true);
        this.mainclass = mainclass;
        this.setTitle("Code Preview");
        this.sCode = sCode;
        this.setSize(600, 500);
        this.setResizable(false);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setContentPane(new CodePreviewPanel());
        this.setVisible(true);
    }

    private void close() {
        if (this.infoDialog != null) {
            this.infoDialog.setVisible(false);
        }
        this.setVisible(false);
        this.dispose();
    }

    private class CodePreviewPanel
    extends SPanel {
        private static final long serialVersionUID = 367392582025882490L;
        private JButton close;
        private JButton info;
        private JButton next;
        private JButton previous;
        private JScrollPane scrollPane;
        private int pagesize = 10000;
        private int pagenumber = 1;
        private int maxpage = 1;
        private int startIndex = 0;
        private int endIndex = this.pagesize;

        public CodePreviewPanel() {
            this.setLayout(null);
            this.createButtons();
            this.refreshPanelComponents();
            this.loadScriptCode();
            this.changeLanguageSettings(CodePreview.this.mainclass.getLanguageSettings());
        }

        private void createButtons() {
            this.info = new JButton();
            this.info.setBounds(0, 0, 149, 25);
            this.info.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CodePreview.this.infoDialog == null) {
                        CodePreview.this.infoDialog = new InfoDialog();
                    }
                    CodePreview.this.infoDialog.setVisible(true);
                }
            });
            this.add(new SComponent(this.info, new String[]{"Einstellungen", "Settings"}));
            this.add(this.info);
            this.previous = new JButton();
            this.previous.setBounds(150, 0, 149, 25);
            this.previous.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CodePreviewPanel.this.startIndex > 0) {
                        CodePreviewPanel codePreviewPanel = CodePreviewPanel.this;
                        codePreviewPanel.startIndex = codePreviewPanel.startIndex - CodePreviewPanel.this.pagesize;
                        CodePreviewPanel.this.endIndex = CodePreviewPanel.this.startIndex + CodePreviewPanel.this.pagesize;
                        CodePreviewPanel.this.loadScriptCode();
                        CodePreviewPanel codePreviewPanel2 = CodePreviewPanel.this;
                        codePreviewPanel2.pagenumber = codePreviewPanel2.pagenumber - 1;
                    }
                    if (CodePreview.this.infoDialog != null) {
                        CodePreview.this.infoDialog.refreshPanelComponents();
                    }
                }
            });
            this.add(new SComponent(this.previous, new String[]{"Vorherige Seite", "Previous Page"}));
            this.add(this.previous);
            this.next = new JButton();
            this.next.setBounds(300, 0, 149, 25);
            this.next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CodePreviewPanel.this.endIndex < CodePreview.this.sCode.size()) {
                        CodePreviewPanel codePreviewPanel = CodePreviewPanel.this;
                        codePreviewPanel.startIndex = codePreviewPanel.startIndex + CodePreviewPanel.this.pagesize;
                        CodePreviewPanel.this.endIndex = CodePreviewPanel.this.startIndex + CodePreviewPanel.this.pagesize;
                        CodePreviewPanel.this.loadScriptCode();
                        CodePreviewPanel codePreviewPanel2 = CodePreviewPanel.this;
                        codePreviewPanel2.pagenumber = codePreviewPanel2.pagenumber + 1;
                    }
                    if (CodePreview.this.infoDialog != null) {
                        CodePreview.this.infoDialog.refreshPanelComponents();
                    }
                }
            });
            this.add(new SComponent(this.next, new String[]{"N\u2030chste Seite", "Next Page"}));
            this.add(this.next);
            this.close = new JButton();
            this.close.setBounds(450, 0, 144, 25);
            this.close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodePreview.this.close();
                }
            });
            this.add(new SComponent(this.close, new String[]{"Schlie\ufb02en", "Close"}));
            this.add(this.close);
        }

        private void loadScriptCode() {
            LoadingThread load = new LoadingThread();
            ProgressDialog pd = new ProgressDialog(load, CodePreview.this.mainclass.getGUI());
            load.setProgressDialog(pd);
            pd.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodePreviewPanel.this.scrollPane.getVerticalScrollBar().setValue(0);
                }
            });
            this.refreshPanelComponents();
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            this.update();
            super.paint(g);
        }

        @Override
        public void refreshPanelComponents() {
            this.previous.setEnabled(this.startIndex > 0);
            this.next.setEnabled(this.endIndex < CodePreview.this.sCode.size());
        }

        public void update() {
            int width = this.getSize().width;
            int w = (width - 2) / 4;
            this.info.setBounds(0, 0, w, 25);
            this.previous.setBounds(w + 1, 0, w, 25);
            this.next.setBounds(2 * w + 2, 0, w, 25);
            this.close.setBounds(3 * w + 3, 0, width - 3 * w - 4, 25);
            this.scrollPane.setBounds(0, 26, width, this.getHeight() - 26);
        }

        private class InfoDialog
        extends JDialog {
            private static final long serialVersionUID = -7849160552388209578L;

            public InfoDialog() {
                super((Dialog)CodePreview.this.cpv, false);
                String title = "Informationen";
                if (CodePreview.this.mainclass.getLanguageSettings() == 1) {
                    title = "Informations";
                }
                this.setTitle(title);
                this.setSize(250, 170);
                this.setResizable(false);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
                this.setContentPane(new InfoPanel());
            }

            private void close() {
                this.setVisible(false);
                CodePreview.this.infoDialog = null;
                this.dispose();
            }

            public void refreshPanelComponents() {
                ((SPanel)this.getContentPane()).refreshPanelComponents();
            }

            private class InfoPanel
            extends SPanel {
                private static final long serialVersionUID = -8859557441105896511L;
                private JLabel vecSizeLabel;
                private JLabel pageSizeLabel;
                private JLabel currentPageLabel;
                private JEditorPane vecSize;
                private IntegerTextFieldEx pageSize;
                private IntegerTextFieldEx currentPage;
                private IntegerTextFieldEx maxPage;
                private JButton apply;
                private JButton close;

                public InfoPanel() {
                    this.setLayout(null);
                    this.createVecSize();
                    this.createPageSize();
                    this.createCurrentPage();
                    this.createButtons();
                    this.changeLanguageSettings(CodePreview.this.mainclass.getLanguageSettings());
                }

                private void createVecSize() {
                    this.vecSizeLabel = new JLabel();
                    this.vecSizeLabel.setBounds(20, 20, 130, 25);
                    this.add(new SComponent(this.vecSizeLabel, new String[]{"Datenmenge:", "Amount of data:"}));
                    this.add(this.vecSizeLabel);
                    this.vecSize = new JEditorPane();
                    this.vecSize.setBorder(BorderFactory.createEtchedBorder());
                    this.vecSize.setBounds(150, 20, 90, 25);
                    this.vecSize.setEditable(false);
                    String ent = " Eintr\u2030ge";
                    if (CodePreview.this.mainclass.getLanguageSettings() == 1) {
                        ent = " entries";
                    }
                    this.vecSize.setText(String.valueOf(CodePreview.this.sCode.size()) + ent);
                    this.add(this.vecSize);
                }

                private void createPageSize() {
                    this.pageSizeLabel = new JLabel();
                    this.pageSizeLabel.setBounds(20, 50, 130, 25);
                    this.add(new SComponent(this.pageSizeLabel, new String[]{"Aktuelle Seitengr\u02c6\ufb02e:", "Current pagesize:"}));
                    this.add(this.pageSizeLabel);
                    this.pageSize = new IntegerTextFieldEx(1000, 50000);
                    this.pageSize.setBorder(BorderFactory.createEtchedBorder());
                    this.pageSize.setBounds(150, 50, 90, 25);
                    this.pageSize.setText("" + CodePreviewPanel.this.pagesize);
                    this.add(this.pageSize);
                }

                private void createCurrentPage() {
                    this.currentPageLabel = new JLabel();
                    this.currentPageLabel.setBounds(20, 80, 130, 25);
                    this.add(new SComponent(this.currentPageLabel, new String[]{"Aktuelle Seite:", "Current page"}));
                    this.add(this.currentPageLabel);
                    CodePreviewPanel.this.maxpage = CodePreview.this.sCode.size() / CodePreviewPanel.this.pagesize + 1;
                    this.currentPage = new IntegerTextFieldEx(1, CodePreviewPanel.this.maxpage);
                    this.currentPage.setBounds(150, 80, 40, 25);
                    this.currentPage.setText("" + CodePreviewPanel.this.pagenumber);
                    this.add(this.currentPage);
                    this.maxPage = new IntegerTextFieldEx();
                    this.maxPage.setBounds(200, 80, 40, 25);
                    this.maxPage.setEditable(false);
                    this.maxPage.setText("" + CodePreviewPanel.this.maxpage);
                    this.add(this.maxPage);
                }

                private void createButtons() {
                    this.apply = new JButton();
                    this.apply.setBounds(20, 115, 105, 25);
                    this.apply.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int newPageSize = InfoPanel.this.pageSize.getValue();
                            if (CodePreviewPanel.this.pagesize != newPageSize) {
                                CodePreviewPanel.this.pagesize = newPageSize;
                                CodePreviewPanel.this.startIndex = CodePreviewPanel.this.startIndex / CodePreviewPanel.this.pagesize * CodePreviewPanel.this.pagesize;
                                CodePreviewPanel.this.endIndex = CodePreviewPanel.this.startIndex + CodePreviewPanel.this.pagesize;
                                CodePreviewPanel.this.loadScriptCode();
                                CodePreviewPanel.this.pagenumber = CodePreviewPanel.this.startIndex / CodePreviewPanel.this.pagesize + 1;
                            } else {
                                int newPage = InfoPanel.this.currentPage.getValue();
                                if (newPage != CodePreviewPanel.this.pagenumber) {
                                    CodePreviewPanel.this.startIndex = CodePreviewPanel.this.pagesize * (newPage - 1);
                                    CodePreviewPanel.this.endIndex = CodePreviewPanel.this.startIndex + CodePreviewPanel.this.pagesize;
                                    CodePreviewPanel.this.loadScriptCode();
                                    CodePreviewPanel.this.pagenumber = newPage;
                                }
                            }
                            InfoPanel.this.refreshPanelComponents();
                        }
                    });
                    this.add(new SComponent(this.apply, new String[]{"Anpassen", "Apply"}));
                    this.add(this.apply);
                    this.close = new JButton("Close");
                    this.close.setBounds(135, 115, 105, 25);
                    this.close.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InfoDialog.this.close();
                        }
                    });
                    this.add(new SComponent(this.close, new String[]{"Schlie\ufb02en", "Close"}));
                    this.add(this.close);
                }

                @Override
                public void refreshPanelComponents() {
                    this.pageSize.setText("" + CodePreviewPanel.this.pagesize);
                    CodePreviewPanel.this.maxpage = CodePreview.this.sCode.size() / CodePreviewPanel.this.pagesize + 1;
                    this.maxPage.setText("" + CodePreviewPanel.this.maxpage);
                    this.currentPage.setMinMaxValues(1, CodePreviewPanel.this.maxpage);
                    this.currentPage.setText("" + CodePreviewPanel.this.pagenumber);
                }

                @Override
                public void paint(Graphics g) {
                    int[] pos;
                    Dimension size = this.getSize();
                    pos = new int[]{(size.width - 220) / 2, pos[0] + 130, (size.height - 120) / 2, pos[2] + 30, pos[2] + 60, pos[2] + 95};
                    this.vecSizeLabel.setLocation(pos[0], pos[2]);
                    this.pageSizeLabel.setLocation(pos[0], pos[3]);
                    this.currentPageLabel.setLocation(pos[0], pos[4]);
                    this.vecSize.setLocation(pos[1], pos[2]);
                    this.pageSize.setLocation(pos[1], pos[3]);
                    this.currentPage.setLocation(pos[1], pos[4]);
                    this.maxPage.setLocation(pos[0] + 180, pos[4]);
                    this.apply.setLocation(pos[0], pos[5]);
                    this.close.setLocation(pos[0] + 115, pos[5]);
                    super.paint(g);
                }
            }
        }

        private class LoadingThread
        extends Thread {
            private ProgressDialog pd;

            private LoadingThread() {
            }

            @Override
            public void run() {
                int pageIndex;
                int size = CodePreview.this.sCode.size();
                if (CodePreviewPanel.this.endIndex > size) {
                    CodePreviewPanel.this.endIndex = size;
                }
                if ((pageIndex = CodePreviewPanel.this.endIndex % CodePreviewPanel.this.pagesize) == 0) {
                    pageIndex = CodePreviewPanel.this.pagesize;
                }
                int oldVal = -1;
                int k = CodePreviewPanel.this.startIndex;
                int i = 0;
                while (k < CodePreviewPanel.this.endIndex) {
                    int newVal = (int)(((double)i + 1.0) / (double)pageIndex * 100.0);
                    if (oldVal != newVal) {
                        this.pd.setProgress(newVal);
                    }
                    ++k;
                    ++i;
                }
                this.pd.close();
            }

            protected void setProgressDialog(ProgressDialog pd) {
                this.pd = pd;
            }
        }
    }
}

