/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.components.SPanel;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class ParserPanel
extends SPanel {
    private static final long serialVersionUID = 5001891154257512791L;
    private GraphAlgController mainclass;
    private JEditorPane outpars;
    JScrollPane scroll;

    public ParserPanel(GraphAlgController mainclass) {
        this.setLayout(new BorderLayout());
        this.mainclass = mainclass;
        this.mainclass.addPanel(7, this);
        this.outpars = new JEditorPane();
        this.outpars.setEditable(false);
        this.scroll = new JScrollPane(this.outpars);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.add(this.scroll);
    }

    protected void displayMessage(ArrayList<String> eData) {
        String sData = "";
        int anz = eData.size();
        int i = 0;
        while (i < anz) {
            sData = String.valueOf(sData) + eData.get(i);
            ++i;
        }
        this.outpars.setText(sData);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParserPanel.this.scroll.getVerticalScrollBar().setValue(0);
            }
        });
    }

    protected void displayMessage(String sData) {
        this.outpars.setText(sData);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParserPanel.this.scroll.getVerticalScrollBar().setValue(0);
            }
        });
    }

    protected void displayErrorMessage(int errorId, String filename) {
        String eMes = "** Following Error has occured while loading the File " + filename + "\n";
        switch (errorId) {
            case 1: {
                eMes = String.valueOf(eMes) + "Maximum File Size reached -> Loading stopped";
                break;
            }
            case 2: {
                eMes = String.valueOf(eMes) + "Unable to find the File";
                break;
            }
            case 3: {
                eMes = String.valueOf(eMes) + "Unable to read the File";
                break;
            }
            case 4: {
                eMes = String.valueOf(eMes) + "Unable to close the File";
                break;
            }
            default: {
                System.out.println("Internal Error @ParserPanel.displayErrorMessage\nUnknown Error Id -> " + errorId);
                return;
            }
        }
        this.outpars.setText(eMes);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParserPanel.this.scroll.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void refreshPanelComponents() {
    }
}

