/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.graphs.AbstractEdge;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.graphs.AbstractNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Vector;

public final class GraphDrawer {
    private Color[] colorSettings;
    private Vector<Eigenkante> data = new Vector(1, 1);
    private int edgeId;
    private boolean eigenkante;
    private Graphics g;
    private Point nStart;
    private Point nZiel;
    private int tagsize;
    private int tagXPos;
    private int tagYPos;
    private int weightXPos;
    private int weightYPos;
    private int winkel;
    private String weightLabel;
    private HashMap weightLabelSet;

    public GraphDrawer() {
        this.colorSettings = new Color[]{Color.LIGHT_GRAY, Color.BLACK, Color.BLACK, Color.BLACK, Color.RED, Color.BLACK, Color.WHITE, Color.BLACK, Color.BLUE, Color.RED, Color.BLACK};
    }

    protected void setGraphics(Graphics g) {
        this.g = g;
    }

    private int aktualizeEigenkante(String tag) {
        Eigenkante ek = this.getEigenkante(tag);
        if (ek == null) {
            this.data.add(new Eigenkante(tag, 0));
            return 0;
        }
        return ek.getWinkel();
    }

    private Eigenkante getEigenkante(String tag) {
        int anz = this.data.size();
        int i = 0;
        while (i < anz) {
            Eigenkante ek = this.data.get(i);
            if (ek.getTag().equals(tag)) {
                return ek;
            }
            ++i;
        }
        return null;
    }

    protected int getEigenkanteWinkel(String tag) {
        Eigenkante ek = this.getEigenkante(tag);
        if (ek != null) {
            return ek.getWinkel();
        }
        return 0;
    }

    protected void setEigenkanteWinkel(String tag, int winkel) {
        Eigenkante ek = this.getEigenkante(tag);
        if (ek != null) {
            ek.setWinkel(winkel > 360 ? 0 : winkel);
        }
    }

    protected void setColorSettings(Color[] colorSettings) {
        this.colorSettings = colorSettings;
    }

    private double maximum(double valueA, double valueB) {
        double maximum = valueB;
        if (valueA > valueB) {
            maximum = valueA;
        }
        if (maximum == 0.0) {
            maximum = 1.0;
        }
        return maximum;
    }

    public static double[] drehung(double[] vektor, double winkel) {
        return new double[]{Math.cos(winkel) * vektor[0] - Math.sin(winkel) * vektor[1], Math.sin(winkel) * vektor[0] + Math.cos(winkel) * vektor[1]};
    }

    public static int[] getKreisposition(double[] vektor, double radius) {
        double[] cpos;
        cpos = new double[]{cpos[0] + vektor[0], cpos[1] + vektor[1]};
        while (GraphDrawer.zweinorm(cpos) < radius) {
        }
        return new int[]{(int)cpos[0], (int)cpos[1]};
    }

    public static double zweinorm(double[] vektor) {
        double sum = 0.0;
        int i = 0;
        while (i < vektor.length) {
            sum += vektor[i] * vektor[i];
            ++i;
        }
        return Math.sqrt(sum);
    }

    private void drawOwnEdge(Graphics g, AbstractEdge edge, int radius, boolean arrow, boolean weight) {
        double[] vektor;
        AbstractNode start = edge.getSource();
        this.winkel = this.aktualizeEigenkante(edge.getTag());
        double[] npos = GraphDrawer.drehung(new double[]{radius, -radius}, (double)this.winkel * Math.PI / 180.0);
        this.nStart = new Point((int)npos[0] + start.getXPos(), (int)npos[1] + start.getYPos());
        g.drawArc(this.nStart.x - radius, this.nStart.y - radius, 2 * radius, 2 * radius, -this.winkel - (arrow ? 60 : 90), arrow ? 240 : 270);
        if (arrow) {
            double yk;
            vektor = GraphDrawer.drehung(new double[]{0.0, -radius}, (double)(this.winkel + 90) * Math.PI / 180.0);
            this.nZiel = new Point(start.getXPos() + (int)vektor[0], start.getYPos() + (int)vektor[1]);
            double xk = Math.abs(vektor[0]);
            if (xk > (yk = Math.abs(vektor[1])) && xk != 0.0) {
                vektor[0] = vektor[0] / xk;
                vektor[1] = vektor[1] / xk;
            } else if (yk != 0.0) {
                vektor[0] = vektor[0] / yk;
                vektor[1] = vektor[1] / yk;
            }
            int[] cpos = GraphDrawer.getKreisposition(vektor, 12.0);
            npos = GraphDrawer.drehung(new double[]{cpos[0], cpos[1]}, -0.39269908169872414);
            Point mid = new Point(this.nZiel.x + (int)npos[0], this.nZiel.y + (int)npos[1]);
            cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, -0.916297857297023), 12.0);
            Point leftWing = new Point(mid.x + cpos[0], mid.y + cpos[1]);
            cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, 0.13089969389957468), 12.0);
            Point rightWing = new Point(mid.x + cpos[0], mid.y + cpos[1]);
            int[] x = new int[]{this.nZiel.x, leftWing.x, mid.x, rightWing.x};
            int[] y = new int[]{this.nZiel.y, leftWing.y, mid.y, rightWing.y};
            g.setColor(this.colorSettings[4]);
            g.fillPolygon(x, y, 4);
        }
        if (weight) {
            vektor = GraphDrawer.drehung(new double[]{0.0, -radius * 5 / 3}, (double)(this.winkel + 45) * Math.PI / 180.0);
            Point pos = new Point(start.getXPos() + (int)vektor[0], start.getYPos() + (int)vektor[1]);
            g.setColor(this.colorSettings[3]);
            Font serif = new Font("Serif", 1, 15);
            String sTag = "" + edge.getWeight();
            Rectangle2D sis = serif.getStringBounds(sTag, new FontRenderContext(new AffineTransform(), false, false));
            g.setFont(serif);
            this.weightXPos = pos.x;
            this.weightYPos = pos.y + (int)sis.getHeight() / 4;
            g.drawString(sTag, pos.x - (int)sis.getWidth() / 2, this.weightYPos);
        }
    }

    public boolean drawResidualEdge(Graphics g, AbstractNode start, AbstractNode ziel, AbstractEdge edge, int radius) {
        boolean secondEdge;
        this.g = g;
        boolean bl = secondEdge = edge.getSource().getTag() != '+' && edge.getTarget().getTag() != '-';
        if (secondEdge) {
            this.edgeId = edge.getSource() == start ? 1 : 2;
        } else {
            if (edge.getSource() != start) {
                return false;
            }
            this.edgeId = 0;
        }
        int distX = start.getXPos() - ziel.getXPos();
        int distY = start.getYPos() - ziel.getYPos();
        if (distX > -radius && distX < radius && distY > -radius && distY < radius) {
            return false;
        }
        double maximum = this.maximum(Math.abs(distX), Math.abs(distY));
        double[] vektor = new double[]{(double)distX / maximum, (double)distY / maximum};
        int[] cpos = GraphDrawer.getKreisposition(vektor, radius);
        if (secondEdge) {
            double[] npos1 = GraphDrawer.drehung(new double[]{cpos[0], cpos[1]}, -0.2617993877991494);
            double[] npos2 = GraphDrawer.drehung(new double[]{cpos[0], cpos[1]}, 0.2617993877991494);
            this.nStart = new Point(start.getXPos() - (int)npos1[0], start.getYPos() - (int)npos1[1]);
            this.nZiel = new Point(ziel.getXPos() + (int)npos2[0], ziel.getYPos() + (int)npos2[1]);
        } else {
            this.nStart = new Point(start.getXPos() - cpos[0], start.getYPos() - cpos[1]);
            this.nZiel = new Point(ziel.getXPos() + cpos[0], ziel.getYPos() + cpos[1]);
        }
        g.setColor(this.colorSettings[8 + this.edgeId % 2]);
        g.drawLine(this.nStart.x, this.nStart.y, this.nZiel.x, this.nZiel.y);
        cpos = GraphDrawer.getKreisposition(vektor, 12.0);
        Point mid = new Point(this.nZiel.x + cpos[0], this.nZiel.y + cpos[1]);
        cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, -0.5235987755982988), 12.0);
        Point leftWing = new Point(mid.x + cpos[0], mid.y + cpos[1]);
        cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, 0.5235987755982988), 12.0);
        Point rightWing = new Point(mid.x + cpos[0], mid.y + cpos[1]);
        int[] x = new int[]{this.nZiel.x, leftWing.x, mid.x, rightWing.x};
        int[] y = new int[]{this.nZiel.y, leftWing.y, mid.y, rightWing.y};
        g.setColor(this.colorSettings[10]);
        g.fillPolygon(x, y, 4);
        this.drawWeight(edge, distX, distY, vektor, this.edgeId);
        return true;
    }

    private void drawWeight(AbstractEdge edge, int distX, int distY, double[] vektor, int directionId) {
        double maximum = this.maximum(Math.abs((double)distX * 0.3), Math.abs((double)distY * 0.3));
        Point pos = new Point((int)((double)this.nZiel.x + maximum * vektor[0]), (int)((double)this.nZiel.y + maximum * vektor[1]));
        int[] cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, 1.5707963267948966), 10.0);
        Point posA = new Point(pos.x + cpos[0], pos.y + cpos[1]);
        this.g.setColor(this.colorSettings[3]);
        Font serif = new Font("Serif", 1, 15);
        switch (directionId) {
            case 0: {
                this.weightLabel = "*";
                break;
            }
            default: {
                this.weightLabel = "" + edge.getWeight();
            }
        }
        Rectangle2D sis = serif.getStringBounds(this.weightLabel, new FontRenderContext(new AffineTransform(), false, false));
        this.g.setFont(serif);
        this.weightXPos = posA.x;
        this.weightYPos = posA.y + (int)sis.getHeight() / 4;
        this.g.drawString(this.weightLabel, posA.x - (int)sis.getWidth() / 2, this.weightYPos);
    }

    public void drawEdge(Graphics g, AbstractEdge edge, int radius, boolean arrow, boolean weight) {
        this.g = g;
        AbstractNode start = edge.getSource();
        AbstractNode ziel = edge.getTarget();
        char startTag = start.getTag();
        char zielTag = ziel.getTag();
        AbstractGraph graph = start.getGraph();
        this.edgeId = 0;
        boolean secondEdge = false;
        if (graph.containsTag(String.valueOf(zielTag) + "->" + startTag)) {
            secondEdge = true;
            if (startTag > zielTag) {
                this.edgeId = 1;
            }
        }
        boolean bl = this.eigenkante = start == ziel;
        if (this.eigenkante) {
            this.drawOwnEdge(g, edge, radius, arrow, weight);
            return;
        }
        int distX = start.getXPos() - ziel.getXPos();
        int distY = start.getYPos() - ziel.getYPos();
        if (distX > -radius && distX < radius && distY > -radius && distY < radius) {
            return;
        }
        double maximum = this.maximum(Math.abs(distX), Math.abs(distY));
        double[] vektor = new double[]{(double)distX / maximum, (double)distY / maximum};
        int[] cpos = GraphDrawer.getKreisposition(vektor, radius);
        if (secondEdge) {
            double[] npos1 = GraphDrawer.drehung(new double[]{cpos[0], cpos[1]}, -0.2617993877991494);
            double[] npos2 = GraphDrawer.drehung(new double[]{cpos[0], cpos[1]}, 0.2617993877991494);
            this.nStart = new Point(start.getXPos() - (int)npos1[0], start.getYPos() - (int)npos1[1]);
            this.nZiel = new Point(ziel.getXPos() + (int)npos2[0], ziel.getYPos() + (int)npos2[1]);
        } else {
            this.nStart = new Point(start.getXPos() - cpos[0], start.getYPos() - cpos[1]);
            this.nZiel = new Point(ziel.getXPos() + cpos[0], ziel.getYPos() + cpos[1]);
        }
        g.setColor(this.colorSettings[1 + this.edgeId]);
        g.drawLine(this.nStart.x, this.nStart.y, this.nZiel.x, this.nZiel.y);
        if (arrow) {
            cpos = GraphDrawer.getKreisposition(vektor, 12.0);
            Point mid = new Point(this.nZiel.x + cpos[0], this.nZiel.y + cpos[1]);
            cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, -0.5235987755982988), 12.0);
            Point leftWing = new Point(mid.x + cpos[0], mid.y + cpos[1]);
            cpos = GraphDrawer.getKreisposition(GraphDrawer.drehung(vektor, 0.5235987755982988), 12.0);
            Point rightWing = new Point(mid.x + cpos[0], mid.y + cpos[1]);
            int[] x = new int[]{this.nZiel.x, leftWing.x, mid.x, rightWing.x};
            int[] y = new int[]{this.nZiel.y, leftWing.y, mid.y, rightWing.y};
            g.setColor(this.colorSettings[4]);
            g.fillPolygon(x, y, 4);
        }
        if (weight) {
            this.drawWeight(edge, distX, distY, vektor, -1);
        }
    }

    public void drawNodes(Graphics g, AbstractNode node, int radius) {
        this.g = g;
        this.tagsize = radius - 5;
        Font serifBold = new Font("Serif", 1, this.tagsize);
        g.setFont(serifBold);
        g.setColor(this.colorSettings[6]);
        g.fillOval(node.getXPos() - radius / 2, node.getYPos() - radius / 2, radius, radius);
        String sTag = "" + node.getTag();
        Rectangle2D sis = serifBold.getStringBounds(sTag, new FontRenderContext(new AffineTransform(), false, false));
        g.setColor(this.colorSettings[7]);
        this.tagXPos = node.getXPos();
        this.tagYPos = node.getYPos() + (int)sis.getHeight() / 4;
        g.drawString(sTag, node.getXPos() - (int)sis.getWidth() / 2, this.tagYPos);
        g.setColor(this.colorSettings[5]);
        g.drawOval(node.getXPos() - radius / 2, node.getYPos() - radius / 2, radius, radius);
    }

    public Color[] getColorSettings() {
        return this.colorSettings;
    }

    public int getEdgeEndXPos() {
        return this.nZiel.x;
    }

    public int getEdgeEndYPos() {
        return this.nZiel.y;
    }

    public int getEdgeStartXPos() {
        return this.nStart.x;
    }

    public int getEdgeStartYPos() {
        return this.nStart.y;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public int getStartAngle() {
        return this.winkel;
    }

    public int getTagSize() {
        return this.tagsize;
    }

    public int getTagXPos() {
        return this.tagXPos;
    }

    public int getTagYPos() {
        return this.tagYPos;
    }

    public int getWeightXPos() {
        return this.weightXPos;
    }

    public int getWeightYPos() {
        return this.weightYPos;
    }

    public boolean isEigenkante() {
        return this.eigenkante;
    }

    public boolean isSecondEdge() {
        return this.edgeId == 0;
    }

    public String getWeightLabel() {
        return this.weightLabel;
    }

    public int getEdgeId() {
        return this.edgeId;
    }

    public void setWeightLabelSet(HashMap weightLabelSet) {
        this.weightLabelSet = weightLabelSet;
    }

    public HashMap getWeightLabelSet() {
        return this.weightLabelSet;
    }

    private final class Eigenkante {
        private String tag;
        private int winkel;

        public Eigenkante(String tag, int winkel) {
            this.tag = tag;
            this.winkel = winkel;
        }

        public String getTag() {
            return this.tag;
        }

        public int getWinkel() {
            return this.winkel;
        }

        public void setWinkel(int winkel) {
            this.winkel = winkel;
        }
    }
}

