/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.PreviewPanel;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.GraphEntry;
import gfgaa.gui.graphs.basic.CreateBasicGraphPanel;
import gfgaa.gui.graphs.basic.KantenPanel;
import gfgaa.gui.graphs.basic.MatrixPanel;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public final class EditGraphPanel
extends SPanel {
    private static final long serialVersionUID = -3169622283996991032L;
    private GraphAlgController mainclass;
    private JSplitPane split;
    private SPanel kanten;
    private SPanel matrix;
    private SPanel vorlage;
    private JTabbedPane input;
    private String[][] tabTitels;

    public EditGraphPanel(GraphAlgController mainclass) {
        this.setLayout(null);
        this.mainclass = mainclass;
        this.mainclass.addPanel(1, this);
        this.add(this.createSplitPane());
    }

    @Override
    public void changeLanguageSettings(int languageFlag) {
        if (this.kanten != null) {
            this.kanten.changeLanguageSettings(languageFlag);
            this.matrix.changeLanguageSettings(languageFlag);
            this.vorlage.changeLanguageSettings(languageFlag);
        }
        super.changeLanguageSettings(languageFlag);
    }

    @Override
    public void refreshPanelComponents() {
        GraphEntry entry = this.mainclass.getGraphDatabase().getSelectedEntry();
        this.kanten = entry.createKantenPanel();
        this.matrix = entry.createMatrixPanel();
        this.vorlage = entry.createCreateGraphPanel();
        int flag = this.mainclass.getLanguageSettings();
        this.input.removeAll();
        this.input.add(this.tabTitels[flag][0], this.vorlage);
        this.input.add(this.tabTitels[flag][1], this.kanten);
        this.input.add(this.tabTitels[flag][2], this.matrix);
    }

    private JSplitPane createSplitPane() {
        PreviewPanel previewPanel = new PreviewPanel(this.mainclass);
        this.split = new JSplitPane(1, previewPanel, this.createInputTab());
        this.split.setBounds(20, 15, 750, 485);
        this.split.setEnabled(false);
        this.setStaticSplitEnabled(false);
        return this.split;
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        this.split.setLocation((size.width - 750) / 2, (size.height - 485) / 2);
        super.paint(g);
    }

    private JTabbedPane createInputTab() {
        this.tabTitels = new String[][]{{"Eigenschaften", "Bearbeiten", "Matrix"}, {"Attributes", "Edit", "Matrix"}};
        this.input = new JTabbedPane();
        this.input.setMinimumSize(new Dimension(290, 500));
        this.setTabbedPane(this.input, this.tabTitels);
        KantenPanel kanten = new KantenPanel(this.mainclass);
        MatrixPanel matrix = new MatrixPanel(this.mainclass);
        CreateBasicGraphPanel vorlage = new CreateBasicGraphPanel(this.mainclass);
        int flag = this.mainclass.getLanguageSettings();
        this.input.add(this.tabTitels[flag][0], vorlage);
        this.input.add(this.tabTitels[flag][1], kanten);
        this.input.add(this.tabTitels[flag][2], matrix);
        this.add(kanten, false);
        this.add(matrix, false);
        this.add(vorlage, false);
        return this.input;
    }

    public void setStaticSplitEnabled(boolean enabled) {
        this.split.setEnabled(enabled);
    }

    public void resetSplit() {
        this.split.setDividerLocation(450);
    }

    public void setMaxSplit() {
        this.split.setDividerLocation(336);
    }
}

