/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.TicksTiming;
import algoanim.util.Timing;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class SimpleSort2
implements Generator {
    private static final String AUTHOR = "Alper,Bilal,G\u00f6khan";
    private static final Node COORDINATES_HEADER = new Coordinates(10, 20);
    private static final Node COORDINATES_ARRAY = new Coordinates(10, 100);
    private static final Node COORDINATES_SOURCECODE = new Coordinates(40, 140);
    private static final Coordinates COORDINATES_DESCRIPTION = new Coordinates(10, 350);
    IntArray array;
    ArrayMarker i;
    ArrayMarker j;
    AnimalScript lang = new AnimalScript("SimpleSort Animation", "Alper,Bilal,G\u00f6khan", 640, 480);
    ArrayProperties arp;
    ArrayMarkerProperties ami;
    ArrayMarkerProperties amj;
    SourceCodeProperties scProps;
    SourceCode sc;
    boolean negativeExample = false;
    boolean positiveExample = false;
    Text description;
    Timing defaultTiming;
    private String[] descriptionText;
    private Hashtable<String, Integer> descriptionVars;

    public SimpleSort2() {
        this.lang.setStepMode(true);
        this.initSimpleSort();
    }

    private void initSimpleSort() {
        this.defaultTiming = new TicksTiming(15);
        Text header = this.lang.newText(COORDINATES_HEADER, "Simplesort", "header", this.defaultTiming);
        header.setFont(new Font("Serif", 1, 40), null, this.defaultTiming);
        this.description = this.lang.newText(COORDINATES_DESCRIPTION, "Beschreibung des Simplesort", "description", this.defaultTiming);
        this.description.setFont(new Font("Serif", 0, 20), null, this.defaultTiming);
        this.descriptionText = new String[9];
        this.descriptionText[0] = "Die Methode erh\u2030lt als Eingabe einen Array mit Zahlen.";
        this.descriptionText[1] = "Die ben\u02c6tigten Zeiger i und j werden initialisiert.";
        this.descriptionText[2] = "Der Zeiger i ist an der Position %pos.";
        this.descriptionText[3] = "Der Zeiger j geht um eine Position weiter nach rechts. ";
        this.descriptionText[4] = "Ist die Bedingung %i > %j  erf\u00b8llt? ";
        this.descriptionText[5] = "%i ist gr\u02c6\ufb02er als %j, also erfolgt hier eine Vertauschung.";
        this.descriptionText[6] = "Die Bedingung %i > %j ist nicht erf\u00b8llt, daher erfolgt keine Vertauschung.";
        this.descriptionText[7] = "Der Zeiger j positioniert sich an der Stelle i+1.";
        this.descriptionText[8] = "Die sortierte Liste";
        this.descriptionVars = new Hashtable();
        this.lang.newRect(new Coordinates(COORDINATES_DESCRIPTION.getX() - 5, COORDINATES_DESCRIPTION.getY() - 5), new Coordinates(COORDINATES_DESCRIPTION.getX() + 560, COORDINATES_DESCRIPTION.getY() + 20), "rect_description", this.defaultTiming);
    }

    public void simpleSort(int[] arrayContents) {
        this.array = this.lang.newIntArray(COORDINATES_ARRAY, arrayContents, "array", null, this.arp);
        this.showSourceCode();
        this.sc.highlight(0);
        this.showDescription(0);
        this.lang.addLabel("Einf\u00b8hrung");
        this.lang.nextStep();
        this.i = this.lang.newArrayMarker(this.array, 0, "i", null, this.ami);
        this.j = this.lang.newArrayMarker(this.array, 1, "j", null, this.amj);
        this.sc.toggleHighlight(0, 1);
        this.showDescription(1);
        this.i.show();
        this.array.highlightCell(0, null, this.defaultTiming);
        this.lang.addLabel("Initialisierung der Variablen");
        this.lang.nextStep();
        this.sc.unhighlight(1);
        while (this.i.getPosition() < arrayContents.length - 1) {
            this.array.highlightCell(this.i.getPosition(), null, this.defaultTiming);
            this.sc.highlight(2);
            this.showDescription(2);
            this.lang.nextStep();
            this.sc.unhighlight(2);
            this.j.move(this.i.getPosition() + 1, null, this.defaultTiming);
            while (this.j.getPosition() < arrayContents.length) {
                this.sc.highlight(3);
                if (this.j.getPosition() == this.i.getPosition() + 1) {
                    this.showDescription(7);
                } else {
                    this.showDescription(3);
                }
                this.lang.nextStep();
                this.sc.toggleHighlight(3, 4);
                this.showDescription(4);
                if (!this.negativeExample || !this.positiveExample) {
                    if (arrayContents[this.i.getPosition()] > arrayContents[this.j.getPosition()]) {
                        if (!this.positiveExample) {
                            this.lang.addLabel("Vergleich der Elemente (positiv)");
                            this.positiveExample = true;
                        }
                    } else if (!this.negativeExample) {
                        this.lang.addLabel("Vergleich der Elemente (negativ)");
                        this.negativeExample = true;
                    }
                }
                if (arrayContents[this.i.getPosition()] > arrayContents[this.j.getPosition()]) {
                    this.lang.nextStep();
                    this.array.highlightCell(this.j.getPosition(), null, this.defaultTiming);
                    this.lang.nextStep();
                    this.sc.toggleHighlight(4, 5);
                    this.showDescription(5);
                    this.array.swap(this.i.getPosition(), this.j.getPosition(), null, this.defaultTiming);
                    this.array.unhighlightCell(this.j.getPosition(), null, this.defaultTiming);
                    this.lang.nextStep();
                    this.sc.unhighlight(5);
                } else {
                    this.lang.nextStep();
                    this.showDescription(6);
                    this.array.highlightElem(this.j.getPosition(), null, this.defaultTiming);
                    this.lang.nextStep();
                    this.array.unhighlightElem(this.j.getPosition(), null, this.defaultTiming);
                    this.sc.unhighlight(4);
                }
                this.lang.nextStep();
                this.j.increment(null, this.defaultTiming);
            }
            this.i.increment(null, this.defaultTiming);
        }
        this.array.highlightCell(this.array.getLength() - 1, null, this.defaultTiming);
        this.lang.nextStep();
        this.lang.addLabel("Die sortierte Liste");
        this.array.hide();
        this.i.hide();
        this.j.hide();
        this.array = this.lang.newIntArray(COORDINATES_ARRAY, arrayContents, "array", null, this.arp);
        this.showDescription(8);
        this.lang.nextStep();
    }

    private void updateDescription() {
        this.descriptionVars.put("%i", this.array.getData(this.i.getPosition()));
        if (this.j.getPosition() < this.array.getData().length) {
            this.descriptionVars.put("%j", this.array.getData(this.j.getPosition()));
        }
        this.descriptionVars.put("%pos", this.i.getPosition());
    }

    private void showDescription(int pos) {
        if (pos != 0) {
            this.updateDescription();
        }
        String descriptionNewText = this.descriptionText[pos];
        for (String key : this.descriptionVars.keySet()) {
            if (!descriptionNewText.contains(key)) continue;
            descriptionNewText = descriptionNewText.replace(key, String.valueOf(this.descriptionVars.get(key)));
        }
        this.description.setText(descriptionNewText, null, this.defaultTiming);
    }

    private String showSourceCode() {
        this.sc = this.lang.newSourceCode(COORDINATES_SOURCECODE, "sourceCode", null, this.scProps);
        this.addCodeLine("public void simpleSort(int[] arrayContents) {", 0);
        this.addCodeLine("int i, j;", 1);
        this.addCodeLine("for(i=0; i<arrayContents.length; i++){", 1);
        this.addCodeLine("for (j=i+1; j<arrayContents.length;j++){", 2);
        this.addCodeLine("if(arrayContents[i]>arrayContents[j])", 3);
        this.addCodeLine("swap(arrayContents, i, j);", 4);
        this.addCodeLine("}", 3);
        this.addCodeLine("}", 2);
        this.addCodeLine("}", 1);
        return this.sc.toString();
    }

    public static void main(String[] args) {
        SimpleSort2 s = new SimpleSort2();
        int[] a = new int[]{7, 3, 2, 4, 1, 13, 52, 13, 5, 1};
        s.simpleSort(a);
        s.getLang().writeFile("D:\\SimpleSort.asu");
        System.out.println(s.getLang());
    }

    public AnimalScript getLang() {
        return this.lang;
    }

    private void addCodeLine(String codeLine, int space) {
        this.sc.addCodeLine(codeLine, null, space, null);
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        this.arp = (ArrayProperties)arg0.get(0);
        this.ami = (ArrayMarkerProperties)arg0.get(1);
        this.amj = (ArrayMarkerProperties)arg0.get(2);
        this.scProps = (SourceCodeProperties)arg0.get(3);
        this.simpleSort((int[])arg1.get("intArray"));
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Simple Sort";
    }

    @Override
    public String getAnimationAuthor() {
        return AUTHOR;
    }

    @Override
    public String getCodeExample() {
        return "public void simpleSort(int[] arrayContents) {\nint i, j;\nfor(i=0; i<arrayContents.length; i++){\nfor (j=i+1; j<arrayContents.length;j++){\nif(arrayContents[i]>arrayContents[j])\nswap(arrayContents, i, j);\n}\n}\n}";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Simplesort ist ein stabiles in-place Sortierverfahren.\nIn seiner einfachsten Form hat Simplesort \nf\u00b8r ein Array der L\u2030nge n n der Landau-Notation\neinen Zeit-Aufwand von O(n2). \nSimplesort zeichnet sich durch einen besonders \neinfachen Algorithmus aus.Die intuitive Idee \nhinter Simplesort ist, dass man die Positionen \nim zu sortierenden Arrays nacheinander betrachtet\nund das jeweils passende Element einsortiert.\nsiehe www.wikipedia.de";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "Simple Sort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public void init() {
    }
}

