/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

public class ShakerSort
implements Generator {
    Language lang;
    ArrayProperties ap;
    ArrayMarkerProperties lgp;
    ArrayMarkerProperties rgp;
    TextProperties tpn;
    TextProperties tpz1;
    TextProperties tpz2;
    RectProperties rp;
    SourceCodeProperties scp;

    @Override
    public void init() {
        this.lang = new AnimalScript("ShakerSort", "Eduard Metlewski", 300, 200);
        this.lang.setStepMode(true);
        this.scp = new SourceCodeProperties();
        this.scp.set("color", Color.BLUE);
        this.scp.set("highlightColor", Color.RED);
        this.rp = new RectProperties();
        this.rp.set("filled", true);
        this.rp.set("fillColor", Color.gray);
        this.tpn = new TextProperties();
        this.tpn.set("color", Color.CYAN);
        this.tpn.set("centered", true);
        this.tpz1 = new TextProperties();
        this.tpz1.set("color", Color.RED);
        this.tpz1.set("centered", true);
        this.tpz2 = new TextProperties();
        this.tpz2.set("color", Color.green);
        this.tpz2.set("centered", true);
        this.ap = new ArrayProperties();
        this.ap.set("cellHighlight", Color.GREEN);
        this.ap.set("elemHighlight", Color.RED);
        this.ap.set("elementColor", Color.BLACK);
        this.ap.set("filled", true);
        this.ap.set("fillColor", Color.GRAY);
        this.lgp = new ArrayMarkerProperties();
        this.lgp.set("label", "l");
        this.lgp.set("color", Color.green);
        this.rgp = new ArrayMarkerProperties();
        this.rgp.set("label", "r");
        this.rgp.set("color", Color.green);
    }

    public void shakerSort(int[] a) {
        boolean fertig = false;
        boolean nachlinks = false;
        MsTiming time = new MsTiming(300);
        SourceCode sc = this.lang.newSourceCode(new Coordinates(20, 150), "Code", null, this.scp);
        sc.addCodeLine("while(lg<rg){", null, 0, null);
        sc.addCodeLine("    nach Rechts:", null, 0, null);
        sc.addCodeLine("        A[i]>A[i+1]:", null, 0, null);
        sc.addCodeLine("            ja--> swap(A[i],A[i+1]);", null, 0, null);
        sc.addCodeLine("                      i++;", null, 0, null);
        sc.addCodeLine("            nein--> i++;", null, 0, null);
        sc.addCodeLine("--------------------------------------------------------", null, 0, null);
        sc.addCodeLine("    nach Links:", null, 0, null);
        sc.addCodeLine("        A[i-1]>A[i]:", null, 0, null);
        sc.addCodeLine("            ja--> swap(A[i-1],A[i]);", null, 0, null);
        sc.addCodeLine("                      i--;", null, 0, null);
        sc.addCodeLine("            nein--> i--;", null, 0, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.newRect(new Coordinates(0, 0), new Coordinates(130, 40), "o", null);
        this.lang.newRect(new Coordinates(5, 5), new Coordinates(125, 35), "in", null, this.rp);
        this.lang.newText(new Coordinates(60, 5), "ShakerSort", "name", null, this.tpn);
        Text zustand1 = this.lang.newText(new Coordinates(60, 18), "array nicht sortiert", "zustand", null, this.tpz1);
        IntArray array = this.lang.newIntArray(new Coordinates(40, 100), a, "array", null, this.ap);
        ArrayMarker lg = this.lang.newArrayMarker(array, 0, "lg", null, this.lgp);
        ArrayMarker rg = this.lang.newArrayMarker(array, a.length - 1, "rg", null, this.rgp);
        this.lang.nextStep();
        int temp = lg.getPosition();
        sc.highlight(0);
        sc.highlight(12);
        while (!fertig) {
            if (!nachlinks) {
                if (lg.getPosition() + 1 == rg.getPosition()) {
                    fertig = true;
                }
                sc.highlight(1);
                sc.highlight(2);
                if (array.getData(temp) > array.getData(temp + 1)) {
                    array.highlightElem(temp, null, null);
                    array.highlightElem(temp + 1, null, null);
                    this.lang.nextStep();
                    sc.highlight(3);
                    this.lang.nextStep();
                    array.swap(temp, temp + 1, null, time);
                    this.lang.nextStep();
                    sc.highlight(4);
                    this.lang.nextStep();
                    sc.unhighlight(3);
                    sc.unhighlight(4);
                    this.lang.nextStep();
                    array.unhighlightElem(temp, null, null);
                    array.unhighlightElem(temp + 1, null, null);
                    ++temp;
                    this.lang.nextStep();
                    sc.unhighlight(2);
                    this.lang.nextStep();
                } else {
                    array.highlightElem(temp, null, null);
                    array.highlightElem(temp + 1, null, null);
                    this.lang.nextStep();
                    sc.highlight(5);
                    this.lang.nextStep();
                    array.unhighlightElem(temp, null, null);
                    array.unhighlightElem(temp + 1, null, null);
                    sc.unhighlight(5);
                    ++temp;
                    this.lang.nextStep();
                    sc.unhighlight(2);
                    this.lang.nextStep();
                }
                sc.unhighlight(1);
                if (temp != rg.getPosition()) continue;
                nachlinks = true;
                array.highlightCell(temp, null, null);
                this.lang.nextStep();
                rg.move(--temp, null, time);
                this.lang.nextStep();
                continue;
            }
            if (lg.getPosition() + 1 == rg.getPosition()) {
                fertig = true;
            }
            sc.highlight(7);
            sc.highlight(8);
            if (array.getData(temp) < array.getData(temp - 1)) {
                array.highlightElem(temp, null, null);
                array.highlightElem(temp - 1, null, null);
                this.lang.nextStep();
                sc.highlight(9);
                this.lang.nextStep();
                array.swap(temp, temp - 1, null, time);
                this.lang.nextStep();
                sc.highlight(10);
                this.lang.nextStep();
                array.unhighlightElem(temp, null, null);
                array.unhighlightElem(temp - 1, null, null);
                this.lang.nextStep();
                sc.unhighlight(9);
                sc.unhighlight(10);
                --temp;
                this.lang.nextStep();
                sc.unhighlight(8);
                this.lang.nextStep();
            } else {
                array.highlightElem(temp, null, null);
                array.highlightElem(temp - 1, null, null);
                this.lang.nextStep();
                sc.highlight(11);
                this.lang.nextStep();
                array.unhighlightElem(temp, null, null);
                array.unhighlightElem(temp - 1, null, null);
                sc.unhighlight(11);
                --temp;
                this.lang.nextStep();
                sc.unhighlight(8);
                this.lang.nextStep();
            }
            sc.unhighlight(7);
            if (temp != lg.getPosition()) continue;
            nachlinks = false;
            array.highlightCell(temp, null, null);
            this.lang.nextStep();
            sc.unhighlight(8);
            this.lang.nextStep();
            lg.move(++temp, null, time);
            this.lang.nextStep();
        }
        array.highlightCell(lg.getPosition(), null, null);
        lg.hide();
        rg.hide();
        this.lang.nextStep();
        zustand1.hide();
        this.lang.newText(new Coordinates(60, 15), "array sortiert", "zustand", null, this.tpz2);
        sc.hide();
        this.lang.writeFile("ShakerSort.asu");
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "ShakerSort";
    }

    @Override
    public String getDescription() {
        return "ShakerSort ist eine kluge Version von BubbleSort";
    }

    @Override
    public String getCodeExample() {
        return "while(lg<rg){\nnach Recht:\nif(A[i]>A[i+1])\nja-->swap(A[i],A[i+1])\ni++\nnein-->i++\nnach Links:\nif(A[i-1]>A[i])\nja-->swap(A[i-1],A[i])\ni--\nnein-->i--\n";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String getAlgorithmName() {
        return "ShakerSort";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        int[] a = (int[])primitives.get("a");
        this.shakerSort(a);
        return this.lang.toString();
    }

    @Override
    public String getAnimationAuthor() {
        return "Eduard Metlewski";
    }
}

