/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Hidden;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class CountingSort
implements Generator {
    private Language language;
    private int[] sourceArray;
    private int minimum;
    private int maximum;
    private SourceCode pseudoCodeText;
    private int windowSizeX;
    private int windowSizeY;
    private boolean useCodeMarker;
    private String codeMarker;
    private Color textHighlightColor;
    private Color codeHighlightColor;
    private Color arrayCellHighlightColor;
    private Color arrayElementHighlightColor;
    private Text[] highlightArrows;
    private int currentHighlight;
    private IntArray visualSourceArray;
    private IntArray visualCounterArray;
    private IntArray visualTargetArray;
    private Text visualMinimum;
    private Text visualMaximum;
    private ArrayProperties sourceArrayProperties;
    private ArrayProperties counterArrayProperties;
    private ArrayProperties targetArrayProperties;
    private TextProperties normalTextProperties;
    private static final String[] pseudoCodeString = new String[]{"Ermittle den Wertebereich der zu sortierenden Zahlen, falls er nicht vorgegeben ist.", "Erzeuge eine neue Liste('Z\u221a\u00a7hlliste'), die einen Eintrag f\u221a\u00bar jedes Element des Wertebereiches hat.", "Initialisiere alle Elemente der Z\u221a\u00a7hlliste mit 0.", "F\u221a\u00bar jedes Element der zu sortierenden Liste:", "Erh\u221a\u2202he den entsprechenden Eintrag in der Z\u221a\u00a7hlliste um eins.", "F\u221a\u00bar jedes Element der Z\u221a\u00a7hlliste, beginnend von vorne:", "Ersetze das Element durch die Summe des aktuellen und des vorherigen Elementes.", "Erzeuge eine neue Liste von der Gr\u221a\u2202\u221a\u00fce der zu sortierenden Liste, die Zielliste.", "F\u221a\u00bar jedes Element der zu sortierenden Liste, beginnend von hinten:", "Interpretiere den Betrag als Index f\u221a\u00bar die Z\u221a\u00a7hlliste.", "Der dort gespeicherte Wert ist wiederum der Index f\u221a\u00bar die Zielliste. (Indexiert beginnend bei 1.)", "Kopiere das aktuelle Element der zu sortierenden Liste an die ermittelte Stelle der Zielliste.", "Erniedrige den Wert in der Z\u221a\u00a7hlliste um eins."};
    private static final int[] pseudoCodeIndention;

    static {
        int[] nArray = new int[13];
        nArray[2] = 1;
        nArray[4] = 1;
        nArray[6] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        pseudoCodeIndention = nArray;
    }

    public CountingSort() {
        int[] nArray = new int[15];
        nArray[0] = 2;
        nArray[1] = 7;
        nArray[2] = 1;
        nArray[3] = 8;
        nArray[4] = 2;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 8;
        nArray[8] = 2;
        nArray[9] = 8;
        nArray[10] = 4;
        nArray[11] = 5;
        nArray[12] = 9;
        nArray[14] = 5;
        this.sourceArray = nArray;
        this.minimum = 0;
        this.maximum = 9;
        this.windowSizeX = 1000;
        this.windowSizeY = 600;
        this.codeMarker = "-->";
        if (pseudoCodeString.length != pseudoCodeIndention.length) {
            throw new RuntimeException("The sizes of the pseudo code and its indention are unequal!");
        }
    }

    public String generate() {
        this.language = new AnimalScript("Counting-Sort", "Jan Stolzenburg <jan.stolzenburg@arcor.de>", this.getWindowSizeX(), this.getWindowSizeY());
        this.language.setStepMode(true);
        this.makeAnimation();
        return this.language.toString();
    }

    private void makeAnimation() {
        this.makeHeader();
        this.language.nextStep();
        this.makeCode();
        this.language.nextStep();
        this.makeSort();
    }

    private void makeHeader() {
        TextProperties titleProperties = new TextProperties();
        titleProperties.set("color", Color.BLACK);
        titleProperties.set("depth", 1);
        titleProperties.set("font", new Font("SansSerif", 1, 24));
        Text title = this.language.newText(new Coordinates(20, 30), "Counting Sort", "title", null, titleProperties);
        RectProperties titleBoxProperties = new RectProperties();
        titleBoxProperties.set("depth", 2);
        titleBoxProperties.set("color", Color.BLACK);
        titleBoxProperties.set("filled", true);
        titleBoxProperties.set("fillColor", Color.WHITE);
        this.language.newRect(new Offset(-5, -5, title, "NW"), new Offset(5, 5, title, "SE"), "titleBox", null, titleBoxProperties);
    }

    private void makeCode() {
        SourceCodeProperties pseudoCodeTextProperties = new SourceCodeProperties();
        pseudoCodeTextProperties.set("color", Color.BLACK);
        pseudoCodeTextProperties.set("highlightColor", this.codeHighlightColor);
        pseudoCodeTextProperties.set("font", new Font("SansSerif", 0, 16));
        this.pseudoCodeText = this.language.newSourceCode(new Coordinates(30, 80), "Counting-Sort Pseude Code", null, pseudoCodeTextProperties);
        this.highlightArrows = new Text[pseudoCodeString.length];
        if (!this.useCodeMarker) {
            this.codeMarker = "";
        }
        int i = 0;
        while (i < pseudoCodeString.length) {
            this.pseudoCodeText.addCodeLine(pseudoCodeString[i], "line" + String.valueOf(i), pseudoCodeIndention[i], null);
            this.highlightArrows[i] = this.language.newText(new Coordinates(5, 94 + 20 * i), this.codeMarker, "arrowCode" + String.valueOf(i), new Hidden());
            ++i;
        }
    }

    private void prepareSort() {
        this.sourceArrayProperties = new ArrayProperties();
        this.sourceArrayProperties.set("cellHighlight", this.arrayCellHighlightColor);
        this.sourceArrayProperties.set("elemHighlight", this.arrayElementHighlightColor);
        this.sourceArrayProperties.set("fillColor", Color.WHITE);
        this.sourceArrayProperties.set("vertical", true);
        this.counterArrayProperties = new ArrayProperties();
        this.counterArrayProperties.set("cellHighlight", this.arrayCellHighlightColor);
        this.counterArrayProperties.set("elemHighlight", this.arrayElementHighlightColor);
        this.counterArrayProperties.set("fillColor", Color.WHITE);
        this.counterArrayProperties.set("vertical", true);
        this.targetArrayProperties = new ArrayProperties();
        this.targetArrayProperties.set("cellHighlight", this.arrayCellHighlightColor);
        this.targetArrayProperties.set("elemHighlight", this.arrayElementHighlightColor);
        this.targetArrayProperties.set("fillColor", Color.WHITE);
        this.targetArrayProperties.set("vertical", true);
        this.normalTextProperties = new TextProperties();
        this.normalTextProperties.set("font", new Font("SansSerif", 1, 16));
    }

    private void makeSort() {
        this.prepareSort();
        this.showListAndRange();
        this.language.nextStep();
        this.showCounterList();
        this.language.nextStep();
        this.showCount();
        this.language.nextStep();
        this.showSummation();
        this.language.nextStep();
        this.showTargetList();
        this.language.nextStep();
        this.showFillTargetList();
    }

    private void showListAndRange() {
        this.visualSourceArray = this.language.newIntArray(new Coordinates(30, 450), this.sourceArray, "sourceArray", null, this.sourceArrayProperties);
        this.language.nextStep();
        this.highlightPseudoCode(0);
        this.language.newText(new Offset(0, -75, this.visualSourceArray, "NW"), "Gegeben:", "given", null, this.normalTextProperties);
        this.visualMinimum = this.language.newText(new Offset(0, -50, this.visualSourceArray, "NW"), "  Minimum: " + String.valueOf(this.minimum), "minimum", null, this.normalTextProperties);
        this.visualMaximum = this.language.newText(new Offset(0, -25, this.visualSourceArray, "NW"), "  Maximum: " + String.valueOf(this.maximum), "maximum", null, this.normalTextProperties);
    }

    private void showCounterList() {
        this.highlightPseudoCode(1);
        this.visualCounterArray = this.language.newIntArray(new Offset(50, 0, this.visualSourceArray, "NE"), new int[1 + this.maximum - this.minimum], "counterArray", null, this.counterArrayProperties);
        this.language.nextStep();
        this.visualMinimum.changeColor("color", this.textHighlightColor, null, null);
        this.visualCounterArray.highlightCell(0, null, null);
        this.language.nextStep();
        this.visualMinimum.changeColor("color", Color.BLACK, null, null);
        this.visualCounterArray.unhighlightCell(0, null, null);
        this.visualMaximum.changeColor("color", this.textHighlightColor, null, null);
        this.visualCounterArray.highlightCell(this.visualCounterArray.getLength() - 1, null, null);
        this.language.nextStep();
        this.visualMaximum.changeColor("color", Color.BLACK, null, null);
        this.visualCounterArray.unhighlightCell(this.visualCounterArray.getLength() - 1, null, null);
        this.highlightPseudoCode(2, false);
    }

    private void showCount() {
        this.highlightPseudoCode(3);
        int i = 0;
        while (i < this.visualSourceArray.getLength()) {
            this.visualSourceArray.highlightCell(i, null, null);
            this.visualSourceArray.highlightElem(i, null, null);
            int counterIndex = this.visualSourceArray.getData(i) - this.minimum;
            this.language.nextStep();
            this.highlightPseudoCode(4, false);
            this.visualCounterArray.highlightCell(counterIndex, null, null);
            this.visualCounterArray.highlightElem(counterIndex, null, null);
            this.language.nextStep();
            this.visualCounterArray.put(counterIndex, 1 + this.visualCounterArray.getData(counterIndex), null, null);
            this.visualCounterArray.highlightElem(counterIndex, null, null);
            this.language.nextStep();
            this.visualSourceArray.unhighlightCell(i, null, null);
            this.visualSourceArray.unhighlightElem(i, null, null);
            this.visualCounterArray.unhighlightCell(counterIndex, null, null);
            this.visualCounterArray.unhighlightElem(counterIndex, null, null);
            ++i;
        }
    }

    private void showSummation() {
        this.highlightPseudoCode(5);
        int i = 1;
        while (i < this.visualCounterArray.getLength()) {
            this.visualCounterArray.highlightCell(i, null, null);
            this.visualCounterArray.highlightElem(i, null, null);
            this.highlightPseudoCode(6);
            this.visualCounterArray.highlightCell(i - 1, null, null);
            this.visualCounterArray.highlightElem(i - 1, null, null);
            this.language.nextStep();
            this.visualCounterArray.put(i, this.visualCounterArray.getData(i - 1) + this.visualCounterArray.getData(i), null, null);
            this.visualCounterArray.highlightElem(i, null, null);
            this.language.nextStep();
            this.visualCounterArray.unhighlightCell(i - 1, null, null);
            this.visualCounterArray.unhighlightElem(i - 1, null, null);
            this.visualCounterArray.unhighlightCell(i, null, null);
            this.visualCounterArray.unhighlightElem(i, null, null);
            ++i;
        }
    }

    private void showTargetList() {
        this.highlightPseudoCode(7);
        this.visualTargetArray = this.language.newIntArray(new Offset(50, 0, this.visualCounterArray, "NE"), new int[this.visualSourceArray.getLength()], "targetArray", null, this.targetArrayProperties);
    }

    private void showFillTargetList() {
        this.highlightPseudoCode(8);
        int i = this.visualSourceArray.getLength() - 1;
        while (i >= 0) {
            this.visualSourceArray.highlightCell(i, null, null);
            this.visualSourceArray.highlightElem(i, null, null);
            int counterIndex = this.visualSourceArray.getData(i) - this.minimum;
            this.language.nextStep();
            this.highlightPseudoCode(9, false);
            this.visualCounterArray.highlightCell(counterIndex, null, null);
            this.visualCounterArray.highlightElem(counterIndex, null, null);
            int targetIndex = this.visualCounterArray.getData(counterIndex) - 1;
            this.language.nextStep();
            this.highlightPseudoCode(10);
            this.visualTargetArray.highlightCell(targetIndex, null, null);
            this.visualTargetArray.highlightElem(targetIndex, null, null);
            this.language.nextStep();
            this.highlightPseudoCode(11);
            this.visualTargetArray.put(targetIndex, this.visualSourceArray.getData(i), null, null);
            this.visualTargetArray.highlightElem(targetIndex, null, null);
            this.language.nextStep();
            this.visualTargetArray.unhighlightCell(targetIndex, null, null);
            this.visualTargetArray.unhighlightElem(targetIndex, null, null);
            this.visualSourceArray.unhighlightCell(i, null, null);
            this.visualSourceArray.unhighlightElem(i, null, null);
            this.highlightPseudoCode(12);
            this.visualCounterArray.put(counterIndex, this.visualCounterArray.getData(counterIndex) - 1, null, null);
            this.visualCounterArray.highlightElem(counterIndex, null, null);
            this.language.nextStep();
            this.visualCounterArray.unhighlightCell(counterIndex, null, null);
            this.visualCounterArray.unhighlightElem(counterIndex, null, null);
            --i;
        }
    }

    private void highlightPseudoCode(int rowIndex, boolean nextStep) {
        this.pseudoCodeText.unhighlight(this.currentHighlight);
        this.pseudoCodeText.highlight(rowIndex);
        this.highlightArrows[this.currentHighlight].hide();
        this.highlightArrows[rowIndex].show();
        this.currentHighlight = rowIndex;
        if (nextStep) {
            this.language.nextStep();
        }
    }

    private void highlightPseudoCode(int rowIndex) {
        this.highlightPseudoCode(rowIndex, true);
    }

    @Override
    public String generate(AnimationPropertiesContainer properties, Hashtable<String, Object> primitives) {
        String nameSourceArray = "Liste der zu sortierenden Zahlen.";
        String errorSourceArray = "Source array is not specified!";
        String nameMaximum = "Groesste Zahl, die in der Liste vorkommen kann.";
        String errorMaximum = "Greatest possible number is not specified!";
        String nameMinimum = "Kleinste Zahl, die in der Liste vorkommen kann.";
        String errorMinimum = "Smallest possible number is not specified!";
        String nameUseCodeMarker = "Die aktuelle Codezeile mit einem Pfeil markieren?";
        String errorUseCodeMarker = "If a codemarker should be used, is not specified!";
        String nameTextHighlightColor = "Farbe zum Hervorheben von Text.";
        String errorTextHighlightColor = "The color for highlighting text is not specified!";
        String nameCodeHighlightColor = "Farbe zum Hervorheben von Pseudocode.";
        String errorCodeHighlightColor = "The color for highlighting code is not specified!";
        String nameCellHighlightColor = "Hintergrundfarbe zum Hervorheben von Text in Listen.";
        String errorCellHighlightColor = "The background color for highlighted text in lists is not specified!";
        String nameElemHighlightColor = "Farbe zum Hervorheben von Text in Listen.";
        String errorElemHighlightColor = "The color for highlighted text in lists is not specified!";
        this.sourceArray = (int[])this.getParameter(primitives, nameSourceArray, errorSourceArray);
        this.maximum = (Integer)this.getParameter(primitives, nameMaximum, errorMaximum);
        this.minimum = (Integer)this.getParameter(primitives, nameMinimum, errorMinimum);
        this.useCodeMarker = (Boolean)this.getParameter(primitives, nameUseCodeMarker, errorUseCodeMarker);
        this.textHighlightColor = (Color)this.getParameter(primitives, nameTextHighlightColor, errorTextHighlightColor);
        this.codeHighlightColor = (Color)this.getParameter(primitives, nameCodeHighlightColor, errorCodeHighlightColor);
        this.arrayCellHighlightColor = (Color)this.getParameter(primitives, nameCellHighlightColor, errorCellHighlightColor);
        this.arrayElementHighlightColor = (Color)this.getParameter(primitives, nameElemHighlightColor, errorElemHighlightColor);
        if (this.sourceArray.length == 0) {
            this.sourceArray = new int[1];
            System.err.println("The list is empty. I added a zero to prevent trouble!");
        }
        int[] nArray = this.sourceArray;
        int n = this.sourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int elem = nArray[n2];
            if (elem < this.minimum) {
                this.minimum = elem;
                System.err.println("There is at least one element in the list that is smaller than the lower bound!\nI corrected the lower bound.");
            }
            if (elem > this.maximum) {
                this.maximum = elem;
                System.err.println("There is at least one element in the list that is greater than the upper bound!\nI corrected the upper bound.");
            }
            ++n2;
        }
        return this.generate();
    }

    private Object getParameter(Hashtable<String, Object> values, String key, String errorMessage) {
        if (!values.containsKey(key) || values.get(key) == null) {
            throw new RuntimeException(errorMessage);
        }
        return values.get(key);
    }

    private int getWindowSizeX() {
        return this.windowSizeX;
    }

    private int getWindowSizeY() {
        return this.windowSizeY;
    }

    @Override
    public String getCodeExample() {
        String result = "";
        int i = 0;
        while (i < pseudoCodeString.length) {
            int j = 0;
            while (j < pseudoCodeIndention[i]) {
                result = String.valueOf(result) + "  ";
                ++j;
            }
            result = String.valueOf(result) + "- ";
            result = String.valueOf(result) + pseudoCodeString[i] + "\n";
            ++i;
        }
        return result;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Erkl\u221a\u00a7rt und veranschaulicht Counting-Sort.";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "Das Sortierverfahren Counting-Sort";
    }

    public static void main(String[] args) {
        System.out.println(new CountingSort().generate());
    }

    @Override
    public String getAlgorithmName() {
        return "Counting Sort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Jan Stolzenburg";
    }

    @Override
    public void init() {
    }
}

