/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class CombSort
implements Generator {
    private Language lang;
    private static final String DESCRIPTION = "Das Verfahren Combsort ist eine optimierte Version des bekannten Sortierverfahrens Bubblesort.Es benutzt einen kleinerwerdenden 'gap'-(L\u00fccken)-Operator um Elemente zu Vergleichen die weitere als ein Element voneinander entfernt sind.W\u00e4hrend diese L\u00fccke zwischen den verglichenen Elementen kleiner wird, wird das Array in die richtige Reihenfolge gebracht.Zun\u00e4chst werden hierzu Elemente vertauscht, die weiter auseinander liegen, dann solche die n\u00e4her aneinander liegen.Durch Versuche des BYTE Magazins wurde herausgefunden, dass der optimale Verkleinerungsfaktor f\u00fcr die L\u00fccke 1,3 ist.Die Komplexit\u00e4t liegt zwischen O(n^2) im schlechtesten und O(n log n) im besten Fall.";
    private static final String SOURCE_CODE = "public void combSort(int[] array){\n    int gap, i, j;\n    boolean fertig;\n    float shrink = 1.3F;\n    int elements = array.getLength();\n    gap = elements;\n    do{\n       fertig = true;\n       gap = (int)((float)gap/shrink);\n       if (gap<1)\tgap = 1;\n       for (i=0; i<elements-gap; i++){\n          j = i+gap;\n          if (array.getData(i)>array.getData(j)){\n             array.swap(i, j, null, null);\n             fertig = false;\n          }\n       }\n  }\n  while (gap>1 || !fertig);\n  }";
    private int pointerCounter = 0;

    public CombSort() {
        this(new AnimalScript("CombSort Animation", "Florian Kryst und David Kuhn", 640, 480));
    }

    public CombSort(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    protected void sort(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        int[] a = (int[])arg1.get("intArray");
        ArrayMarkerProperties arrayiProps = (ArrayMarkerProperties)arg0.getPropertiesByName("arrayMarker_i");
        ArrayMarkerProperties arrayjProps = (ArrayMarkerProperties)arg0.getPropertiesByName("arrayMarker_j");
        TextProperties variablenProps = (TextProperties)arg0.getPropertiesByName("text");
        ArrayProperties arrayProps = (ArrayProperties)arg0.getPropertiesByName("array");
        SourceCodeProperties scProps = (SourceCodeProperties)arg0.getPropertiesByName("sourceCode");
        Font titleFont = new Font("SansSerif", 1, 30);
        Font standardFont = new Font("SansSerif", 0, 15);
        variablenProps.set("font", titleFont);
        this.lang.newText(new Coordinates(0, 20), "CombSort", "sort_title", null, variablenProps);
        variablenProps.set("font", standardFont);
        Text TextvarGap = this.lang.newText(new Coordinates(300, 60), "", "varGap", null, variablenProps);
        Text TextvarFertig = this.lang.newText(new Coordinates(300, 100), "", "varFertig", null, variablenProps);
        IntArray intArray = this.lang.newIntArray(new Coordinates(20, 100), a, "intArray", null, arrayProps);
        this.lang.nextStep();
        SourceCode sourceCode = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sourceCode.addCodeLine("public void combSort(int[] array){", null, 0, null);
        sourceCode.addCodeLine("int gap, i, j;", null, 1, null);
        sourceCode.addCodeLine("boolean fertig;", null, 1, null);
        sourceCode.addCodeLine("float shrink = 1.3F;", null, 1, null);
        sourceCode.addCodeLine("int elements = array.getLength();", null, 1, null);
        sourceCode.addCodeLine("gap = elements;", null, 1, null);
        sourceCode.addCodeLine("do{", null, 1, null);
        sourceCode.addCodeLine("fertig = true;", null, 2, null);
        sourceCode.addCodeLine("gap = (int)((float)gap/shrink);", null, 2, null);
        sourceCode.addCodeLine("if (gap<1)\tgap = 1;", null, 2, null);
        sourceCode.addCodeLine("for (i=0; i<elements-gap; i++){", null, 2, null);
        sourceCode.addCodeLine("j = i+gap;", null, 3, null);
        sourceCode.addCodeLine("if (array.getData(i)>array.getData(j)){", null, 3, null);
        sourceCode.addCodeLine("array.swap(i, j, null, null);", null, 4, null);
        sourceCode.addCodeLine("fertig = false;", null, 4, null);
        sourceCode.addCodeLine("}", null, 3, null);
        sourceCode.addCodeLine("}", null, 2, null);
        sourceCode.addCodeLine("}", null, 1, null);
        sourceCode.addCodeLine("while (gap>1 || !fertig);", null, 1, null);
        sourceCode.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        ++this.pointerCounter;
        ArrayMarker iMarker = this.lang.newArrayMarker(intArray, 0, "i", null, arrayiProps);
        ++this.pointerCounter;
        ArrayMarker jMarker = this.lang.newArrayMarker(intArray, 0, "j", null, arrayjProps);
        this.lang.nextStep();
        try {
            this.MyCombSort(intArray, sourceCode, iMarker, jMarker, TextvarGap, TextvarFertig);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private void MyCombSort(IntArray array, SourceCode codeSupport, ArrayMarker markerI, ArrayMarker markerJ, Text varGap, Text varFertig) throws LineNotExistsException {
        boolean fertig;
        TicksTiming standardDuration = new TicksTiming(100);
        TicksTiming standardDelay = new TicksTiming(20);
        codeSupport.highlight(0);
        codeSupport.highlight(19);
        this.lang.nextStep();
        codeSupport.unhighlight(0);
        codeSupport.unhighlight(19);
        codeSupport.highlight(1);
        varGap.setText("int gap;", null, null);
        this.lang.nextStep();
        codeSupport.toggleHighlight(1, 0, false, 2, 0);
        varFertig.setText("boolean fertig;", null, null);
        this.lang.nextStep();
        codeSupport.toggleHighlight(2, 0, false, 3, 0);
        float shrink = 1.3f;
        this.lang.nextStep();
        codeSupport.toggleHighlight(3, 0, false, 4, 0);
        int elements = array.getLength();
        this.lang.nextStep();
        codeSupport.toggleHighlight(4, 0, false, 5, 0);
        int gap = elements;
        varGap.setText("int gap = " + gap + ";", null, null);
        this.lang.nextStep();
        codeSupport.unhighlight(5);
        do {
            codeSupport.unhighlight(18);
            codeSupport.highlight(6);
            codeSupport.highlight(17);
            this.lang.nextStep();
            codeSupport.unhighlight(6);
            codeSupport.unhighlight(17);
            codeSupport.highlight(7);
            fertig = true;
            varFertig.setText("boolean fertig = " + fertig + ";", null, null);
            this.lang.nextStep();
            codeSupport.toggleHighlight(7, 0, false, 8, 0);
            gap = (int)((float)gap / shrink);
            varGap.setText("int gap = " + gap + ";", null, null);
            this.lang.nextStep();
            codeSupport.toggleHighlight(8, 0, false, 9, 0);
            if (gap < 1) {
                gap = 1;
            }
            varGap.setText("int gap = " + gap + ";", null, null);
            this.lang.nextStep();
            codeSupport.unhighlight(9);
            int i = 0;
            while (i < elements - gap) {
                markerI.move(i, standardDelay, standardDuration);
                codeSupport.highlight(10);
                codeSupport.highlight(16);
                this.lang.nextStep();
                codeSupport.unhighlight(10);
                codeSupport.unhighlight(16);
                codeSupport.highlight(11);
                int j = i + gap;
                markerJ.move(j, standardDelay, standardDuration);
                this.lang.nextStep();
                codeSupport.unhighlight(11);
                codeSupport.highlight(12);
                codeSupport.highlight(15);
                array.highlightElem(i, i, null, null);
                array.highlightElem(j, j, null, null);
                this.lang.nextStep();
                codeSupport.unhighlight(12);
                codeSupport.unhighlight(15);
                if (array.getData(i) > array.getData(j)) {
                    codeSupport.highlight(13);
                    array.swap(i, j, standardDelay, standardDuration);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(13, 0, false, 14, 0);
                    fertig = false;
                    varFertig.setText("boolean fertig = " + fertig + ";", null, null);
                    this.lang.nextStep();
                    codeSupport.unhighlight(14);
                }
                array.unhighlightElem(0, array.getLength() - 1, null, null);
                ++i;
            }
            codeSupport.highlight(18);
        } while (gap > 1 || !fertig);
        codeSupport.unhighlight(18);
        codeSupport.highlight(0);
        codeSupport.highlight(19);
        this.lang.nextStep();
        codeSupport.unhighlight(0);
        codeSupport.unhighlight(19);
    }

    public static void main(String[] args) {
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        AnimalScript l = new AnimalScript("CombSort Animation", "Florian Kryst und David Kuhn", 640, 480);
        CombSort c = new CombSort(l);
        c.sort(arg0, arg1);
        return ((Object)l).toString();
    }

    @Override
    public String getAlgorithmName() {
        return "CombSort";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "CombSort";
    }

    @Override
    public String getAnimationAuthor() {
        return "David Kuhn, Florian Kryst";
    }

    @Override
    public void init() {
    }
}

