/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class APIShakerSort
implements Generator {
    private Language lang;
    private static final String DESCRIPTION = "Das zu sortierende Feld wird abwechselnd nach oben und nach unten durchlaufen. Dabei werden jeweils zwei benachbarte Elemente verglichen und gegebenenfalls vertauscht.Durch diese Bidirektionalit\u00e4t kommt es zu einem schnellerem Absetzen von gro\u00dfen bzw. kleinen Elementen. Anhand des Sortierverfahrens l\u00e4sst sich auch der Name erkl\u00e4ren, denn der Sortiervorgang erinnert an das Sch\u00fctteln des Arrays oder eines Barmixers.";
    private static final String SOURCE_CODE = "public void shakerSort(int[] array)\n{\n  boolean austausch;\n  int links = 1; //beginnt beim zweiten Element\n  int rechts = (array.length)-1;\n  int fertig = rechts;\n  do{\n     austausch = false;\n     for (int i = rechts; i >= links; i--) //Laufe r\u00fcckw\u00e4rts - beginne beim Zeiger rechts\n        if(array[i].compareTo(array[i-1]) < 0){ //wenn aktuelles Element kleiner als Vorg\u00e4nger\n           austausch = true; fertig = i; //Tausche die Elemente\n           int temp = array[i-1]; //durch einen Dreickstausch\n           array[i-1]=array[i]; array[i]=temp;\n        }\n     links = fertig + 1; //fertig ist das zuletzt getauschte Element\n     for (int i = links; i <= rechts; i++) //gehe zum n\u00e4chsten Element\n        if (array[i].compareTo(array[i-1]) < 0){ //wenn aktuelles Element kleiner als Vorg\u00e4nger\n          austausch = true; fertig = i;\n          int temp = array[i-1]; //durch einen Dreickstausch\n          array[i-1]=array[i]; array[i]=temp;\n        }\n     rechts = fertig -1;\n     }while (austausch); //wiederhole solange ausgetsucht wird\n};";
    private int pointerCounter = 0;

    public APIShakerSort() {
        this(new AnimalScript("Shakersort Animation", "Florian Kryst und David Kuhn", 640, 480));
    }

    public APIShakerSort(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void sort(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        boolean austausch;
        TicksTiming standardDuration = new TicksTiming(100);
        TicksTiming standardDelay = new TicksTiming(20);
        int[] a = (int[])arg1.get("intArray");
        ArrayMarkerProperties arrayLinksProps = (ArrayMarkerProperties)arg0.getPropertiesByName("arrayMarker_left");
        ArrayMarkerProperties arrayRechtsProps = (ArrayMarkerProperties)arg0.getPropertiesByName("arrayMarker_right");
        ArrayMarkerProperties arrayFertigProps = (ArrayMarkerProperties)arg0.getPropertiesByName("arrayMarker_ready");
        ArrayMarkerProperties arrayCurrentProps = (ArrayMarkerProperties)arg0.getPropertiesByName("arrayMarker_current");
        TextProperties variablenProps = (TextProperties)arg0.getPropertiesByName("text");
        ArrayProperties arrayProps = (ArrayProperties)arg0.getPropertiesByName("array");
        SourceCodeProperties scProps = (SourceCodeProperties)arg0.getPropertiesByName("sourceCode");
        Font titleFont = new Font("SansSerif", 1, 30);
        Font standardFont = new Font("SansSerif", 0, 15);
        variablenProps.set("font", titleFont);
        this.lang.newText(new Coordinates(0, 20), "ShakerSort", "sort_title", null, variablenProps);
        variablenProps.set("font", standardFont);
        IntArray ia = this.lang.newIntArray(new Coordinates(20, 100), a, "intArray", null, arrayProps);
        this.lang.nextStep();
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sc.addCodeLine("public void shakerSort(int[] array)", null, 0, null);
        sc.addCodeLine("{", null, 0, null);
        sc.addCodeLine("boolean austausch;", null, 1, null);
        sc.addCodeLine("int links = 1;", null, 1, null);
        sc.addCodeLine("int rechts = (array.length)-1;", null, 1, null);
        sc.addCodeLine("int fertig = rechts;", null, 1, null);
        sc.addCodeLine("do {", null, 2, null);
        sc.addCodeLine("austausch = false;", null, 3, null);
        sc.addCodeLine("for (int i = rechts; i >= links; i--)", null, 3, null);
        sc.addCodeLine("if(array[i].compareTo(array[i-1]) < 0){", null, 4, null);
        sc.addCodeLine("austausch = true; fertig = i;", null, 5, null);
        sc.addCodeLine("int temp = array[i-1];", null, 5, null);
        sc.addCodeLine("array[i-1]=array[i]; array[i]=temp;", null, 5, null);
        sc.addCodeLine("}", null, 4, null);
        sc.addCodeLine("links = fertig + 1;", null, 3, null);
        sc.addCodeLine("for (int i = links; i <= rechts; i++)", null, 3, null);
        sc.addCodeLine("if (array[i].compareTo(array[i-1]) < 0){", null, 4, null);
        sc.addCodeLine("austausch = true; fertig = i;", null, 5, null);
        sc.addCodeLine("int temp = array[i-1];", null, 5, null);
        sc.addCodeLine("array[i-1]=array[i]; array[i]=temp;", null, 5, null);
        sc.addCodeLine("}", null, 4, null);
        sc.addCodeLine("rechts = fertig -1;", null, 3, null);
        sc.addCodeLine("}while (austausch);", null, 2, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        IntArray array = ia;
        SourceCode codeSupport = sc;
        ArrayMarker linksMarker = this.lang.newArrayMarker(array, 0, "links", null, arrayLinksProps);
        ArrayMarker rechtMarker = this.lang.newArrayMarker(array, 0, "rechts", null, arrayRechtsProps);
        ArrayMarker fertigMarker = this.lang.newArrayMarker(array, 0, "fertig", null, arrayFertigProps);
        ArrayMarker currentMarker = this.lang.newArrayMarker(array, 0, "i", null, arrayCurrentProps);
        this.lang.newText(new Coordinates(380, 50), "Informationen:", "info_title", null, variablenProps);
        Text InformationenText = this.lang.newText(new Coordinates(380, 75), "", "info_text", null, variablenProps);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 0, false, 2, 0);
        this.lang.newText(new Coordinates(380, 120), "Variablen:", "variablen_title", null, variablenProps);
        Text AustauschText = this.lang.newText(new Coordinates(380, 145), "austausch", "austausch", null, variablenProps);
        Text TempText = this.lang.newText(new Coordinates(380, 170), "", "temp", null, variablenProps);
        this.lang.nextStep();
        codeSupport.toggleHighlight(2, 0, false, 3, 0);
        int links = 1;
        linksMarker.show();
        linksMarker.move(links, standardDelay, standardDuration);
        this.lang.nextStep();
        codeSupport.toggleHighlight(3, 0, false, 4, 0);
        int rechts = array.getLength() - 1;
        rechtMarker.show();
        rechtMarker.move(rechts, standardDelay, standardDuration);
        this.lang.nextStep();
        codeSupport.toggleHighlight(4, 0, false, 5, 0);
        int fertig = rechts;
        fertigMarker.show();
        fertigMarker.move(fertig, standardDelay, standardDuration);
        this.lang.nextStep();
        codeSupport.toggleHighlight(5, 0, false, 6, 0);
        do {
            int temp;
            this.lang.nextStep();
            codeSupport.unhighlight(22);
            codeSupport.toggleHighlight(6, 0, false, 7, 0);
            austausch = false;
            AustauschText.setText("austausch = false", null, null);
            this.lang.nextStep();
            codeSupport.unhighlight(7);
            int i = rechts;
            while (i >= links) {
                InformationenText.setText("Gehe von rechts nach links durch das Array", null, null);
                currentMarker.show();
                currentMarker.move(i, standardDelay, standardDuration);
                codeSupport.highlight(8);
                array.unhighlightElem(0, array.getLength() - 1, null, null);
                this.lang.nextStep();
                array.highlightElem(i - 1, i, null, null);
                codeSupport.toggleHighlight(8, 0, false, 9, 0);
                this.lang.nextStep();
                if (array.getData(i) < array.getData(i - 1)) {
                    InformationenText.setText("Element " + i + " ist kleiner als Element " + (i - 1) + ": " + array.getData(i) + "<" + array.getData(i - 1), null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(9, 0, false, 10, 0);
                    austausch = true;
                    fertig = i;
                    AustauschText.setText("austausch = true", null, null);
                    fertigMarker.move(fertig, standardDelay, standardDuration);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(10, 0, false, 11, 0);
                    temp = array.getData(i - 1);
                    InformationenText.setText("Element " + (i - 1) + " in temp zwischengespeichert.", null, null);
                    TempText.setText("temp=" + temp, null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(11, 0, false, 12, 0);
                    InformationenText.setText("Element " + (i - 1) + " \u00fcberschrieben und temp in Element " + i + " gespeichert.", null, null);
                    array.swap(i - 1, i, standardDelay, standardDuration);
                    this.lang.nextStep();
                    codeSupport.unhighlight(12);
                } else {
                    InformationenText.setText("Element " + i + " nicht kleiner als  Element " + (i - 1), null, null);
                }
                codeSupport.unhighlight(9);
                codeSupport.unhighlight(8);
                --i;
            }
            codeSupport.highlight(14);
            links = fertig + 1;
            linksMarker.move(links, standardDelay, standardDuration);
            array.highlightCell(0, fertig - 1, null, null);
            array.unhighlightElem(0, array.getLength() - 1, null, null);
            this.lang.nextStep();
            codeSupport.unhighlight(14);
            i = links;
            while (i <= rechts) {
                InformationenText.setText("Gehe von links nach rechts durch das Array", null, null);
                codeSupport.unhighlight(19);
                codeSupport.highlight(15);
                currentMarker.move(i, standardDelay, standardDuration);
                array.unhighlightElem(0, array.getLength() - 1, null, null);
                this.lang.nextStep();
                array.highlightElem(i - 1, i, null, null);
                codeSupport.toggleHighlight(15, 0, false, 16, 0);
                this.lang.nextStep();
                if (array.getData(i) < array.getData(i - 1)) {
                    InformationenText.setText("Element " + i + " ist kleiner als Element " + (i - 1) + ": " + array.getData(i) + "<" + array.getData(i - 1), null, null);
                    codeSupport.toggleHighlight(16, 0, false, 17, 0);
                    austausch = true;
                    fertig = i;
                    AustauschText.setText("austausch = true", null, null);
                    fertigMarker.move(fertig, standardDelay, standardDuration);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(17, 0, false, 18, 0);
                    temp = array.getData(i - 1);
                    InformationenText.setText("Element " + (i - 1) + " in temp zwischengespeichert.", null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(18, 0, false, 19, 0);
                    InformationenText.setText("Element " + (i - 1) + " \u00fcberschrieben und temp in Element " + i + " gespeichert.", null, null);
                    array.swap(i - 1, i, standardDelay, standardDuration);
                    this.lang.nextStep();
                }
                codeSupport.unhighlight(15);
                codeSupport.unhighlight(16);
                ++i;
            }
            codeSupport.toggleHighlight(19, 0, false, 21, 0);
            array.unhighlightElem(0, array.getLength() - 1, null, null);
            rechts = fertig - 1;
            rechtMarker.move(rechts, standardDelay, standardDuration);
            array.highlightCell(fertig, array.getLength() - 1, null, null);
            this.lang.nextStep();
            codeSupport.toggleHighlight(21, 0, false, 22, 0);
        } while (austausch);
        this.lang.nextStep();
        codeSupport.unhighlight(22);
        this.lang.nextStep();
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getName() {
        return "ShakerSort";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        AnimalScript l = new AnimalScript("Shakersort Animation", "Florian Kryst und David Kuhn", 640, 480);
        APIShakerSort s = new APIShakerSort(l);
        s.sort(arg0, arg1);
        return ((Object)l).toString();
    }

    @Override
    public String getAlgorithmName() {
        return "ShakerSort";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "David Kuhn, Florian Kryst";
    }

    @Override
    public void init() {
    }
}

