/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.misc;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.NotEnoughNodesException;
import algoanim.primitives.Polygon;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.PolygonProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class FloodFill
implements Generator {
    private Language lang;
    private static final String AUTHORS = "Martin Tschirsich, Tjark Vandommele et errator";
    private static final String ALGORITHM = "Flood Fill";
    private static final String DESCRIPTION = "Flood fill, also called seed fill, is an algorithm that determines the area connected to a given node in a multi-dimensional array.\nThe flood fill algorithm takes three parameters: a start node, a target color, and a replacement color. The algorithm looks for all nodes in the array which are connected to the start node by a path of the target color and changes them to the replacement color.<br><br><i>Flood fill. (2009, April 22). In Wikipedia, The Free Encyclopedia.Retrieved 16:11, April 22, 2009, from http://en.wikipedia.org/w/index.php?title=Flood_fill&oldid=285426343</i>";
    private static final String SOURCE_CODE = "fill4(x, y) {<br><br> if (getPixel(x, y) == target color) {<br>  setPixel(x, y, fill color);<br><br>  fill4(x, y + 1);<br>  fill4(x, y - 1);<br>  fill4(x + 1, y);<br>  fill4(x - 1, y);<br><br> }<br> return;<br>}";
    private Color sourcePixel = new Color(43, 130, 227);
    private Color standardPixel = new Color(3, 90, 187);
    private Color wrongPixel = new Color(250, 0, 0);
    private Color highlightPixel = new Color(250, 250, 0);
    private Color filledPixel = new Color(0, 250, 0);
    private Text currentText;
    private int depth;

    private String colorToString(Color color) {
        return "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    @Override
    public void init() {
        this.lang = new AnimalScript(ALGORITHM, AUTHORS, 640, 480);
        this.lang.setStepMode(true);
        this.currentText = null;
        this.depth = 0;
    }

    public static void main(String[] args) {
        FloodFill o = new FloodFill();
        o.init();
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        int y;
        int x;
        this.init();
        String[][] a = new String[][]{{" ", " ", " "}, {"1", "1", " "}, {" ", "1", " "}};
        Boolean randomArray = (Boolean)primitives.get("Random array?");
        this.standardPixel = (Color)primitives.get("Basic color");
        this.sourcePixel = (Color)primitives.get("Target color");
        this.filledPixel = (Color)primitives.get("Fill color");
        TextProperties textProps = new TextProperties();
        textProps.set("font", new Font("SansSerif", 1, 28));
        Text h1 = this.lang.newText(new Coordinates(20, 20), "Flood Fill (4-Neighbor)", "h1", null, textProps);
        RectProperties rectProps = new RectProperties();
        rectProps.set("filled", true);
        this.lang.newRect(new Offset(-15, 5, h1, "SW"), new Offset(10, 10, h1, "SE"), "h1Rect1", null, rectProps);
        this.lang.newRect(new Offset(10, 0, h1, "NE"), new Offset(12, 10, h1, "SE"), "h1Rect2", null, rectProps);
        rectProps.set("filled", false);
        this.lang.newRect(new Offset(-15, 0, h1, "NW"), new Offset(12, 10, h1, "SE"), "h1Rect1", null, rectProps);
        PolygonProperties polyProps = new PolygonProperties();
        Node[] p1coords = new Coordinates[]{new Coordinates(25, 165), new Coordinates(25, 75), new Coordinates(20, 75), new Coordinates(25, 65), new Coordinates(30, 75), new Coordinates(25, 75)};
        Polygon p1 = null;
        try {
            p1 = this.lang.newPolygon(p1coords, "p1", null, polyProps);
        }
        catch (NotEnoughNodesException e) {
            e.printStackTrace();
        }
        textProps.set("font", new Font("SansSerif", 0, 16));
        this.lang.newText(new Offset(-10, -20, p1, "NW"), "y", "t1", null, textProps);
        Node[] p2coords = new Coordinates[]{new Coordinates(20, 160), new Coordinates(125, 160), new Coordinates(125, 165), new Coordinates(135, 160), new Coordinates(125, 155), new Coordinates(125, 160)};
        Polygon p2 = null;
        try {
            p2 = this.lang.newPolygon(p2coords, "p2", null, polyProps);
        }
        catch (NotEnoughNodesException e) {
            e.printStackTrace();
        }
        this.lang.newText(new Offset(-5, 2, p2, "NE"), "x", "t2", null, textProps);
        this.lang.addLine("grid \"field\" (35, 80) lines 3 columns 3 color (0, 0, 0) textColor (0, 0, 0) fillColor (0, 0, 0)  highlightBackColor (0, 0, 0) depth 1");
        if (randomArray.booleanValue()) {
            x = 0;
            while (x <= 2) {
                y = 0;
                while (y <= 2) {
                    this.lang.addLine("setGridValue \"field[" + (2 - y) + "][" + x + "]\" \" \"");
                    if (Math.random() > 0.5 || x == 1 && y == 1) {
                        this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.sourcePixel));
                        a[x][y] = "1";
                    } else {
                        this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.standardPixel));
                        a[x][y] = "_";
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x <= 2) {
                y = 0;
                while (y <= 2) {
                    this.lang.addLine("setGridValue \"field[" + (2 - y) + "][" + x + "]\" \" \"");
                    if (a[x][y] == "1") {
                        this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.sourcePixel));
                    } else {
                        this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.standardPixel));
                        a[x][y] = "_";
                    }
                    ++y;
                }
                ++x;
            }
        }
        rectProps.set("filled", true);
        rectProps.set("fillColor", this.sourcePixel);
        Rect fieldRect1 = this.lang.newRect(new Offset(150, 70, h1, "NW"), new Offset(170, 90, h1, "NW"), "fieldRect1", null, rectProps);
        textProps.set("font", new Font("SansSerif", 1, 16));
        this.lang.newText(new Offset(10, 0, fieldRect1, "NE"), "= target color", "fieldRect1Text1", null, textProps);
        rectProps.set("filled", true);
        rectProps.set("fillColor", this.filledPixel);
        Rect fieldRect2 = this.lang.newRect(new Offset(150, 110, h1, "NW"), new Offset(170, 130, h1, "NW"), "fieldRect2", null, rectProps);
        textProps.set("font", new Font("SansSerif", 1, 16));
        this.lang.newText(new Offset(10, 0, fieldRect2, "NE"), "= fill color", "fieldRect2Text1", null, textProps);
        this.lang.nextStep();
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("font", new Font("Monospaced", 1, 14));
        scProps.set("highlightColor", Color.RED);
        SourceCode sc1 = this.lang.newSourceCode(new Offset(0, 140, h1, "SW"), "code1", null, scProps);
        SourceCode sc2 = this.lang.newSourceCode(new Offset(380, 140, h1, "SW"), "code2", null, scProps);
        sc1.addCodeLine("fill4(x, y) {", null, 0, null);
        sc1.addCodeLine("", null, 0, null);
        sc2.addCodeLine("Fill at position (x, y):", null, 0, null);
        sc2.addCodeLine("", null, 0, null);
        sc1.highlight(0);
        sc2.highlight(0);
        this.lang.nextStep();
        sc1.unhighlight(0);
        sc2.unhighlight(0);
        sc1.addCodeLine("if (getPixel(x, y) == target color) {", null, 1, null);
        sc1.addCodeLine("", null, 1, null);
        sc1.addCodeLine("setPixel(x, y, fill color);", null, 2, null);
        sc1.addCodeLine("", null, 2, null);
        sc2.addCodeLine("If pixel color equals target color...", null, 1, null);
        sc2.addCodeLine("", null, 0, null);
        sc2.addCodeLine("...set pixel color to fill color", null, 2, null);
        sc2.addCodeLine("", null, 0, null);
        sc1.highlight(2);
        sc1.highlight(4);
        sc2.highlight(2);
        sc2.highlight(4);
        this.lang.nextStep();
        sc1.unhighlight(2);
        sc1.unhighlight(4);
        sc2.unhighlight(2);
        sc2.unhighlight(4);
        sc1.addCodeLine("fill4(x, y + 1);", null, 2, null);
        sc1.addCodeLine("fill4(x, y - 1);", null, 2, null);
        sc1.addCodeLine("fill4(x + 1, y);", null, 2, null);
        sc1.addCodeLine("fill4(x - 1, y);", null, 2, null);
        sc1.addCodeLine("", null, 2, null);
        sc1.addCodeLine("}", null, 1, null);
        sc1.addCodeLine("return;", null, 1, null);
        sc1.addCodeLine("}", null, 0, null);
        sc2.addCodeLine("...and fill adjacent neighbors", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc2.addCodeLine("", null, 2, null);
        sc1.highlight(6);
        sc1.highlight(7);
        sc1.highlight(8);
        sc1.highlight(9);
        sc2.highlight(6);
        this.lang.nextStep();
        sc1.unhighlight(6);
        sc1.unhighlight(7);
        sc1.unhighlight(8);
        sc1.unhighlight(9);
        sc2.unhighlight(6);
        sc2.hide();
        this.floodFill(a, null, 1, 1);
        return this.lang.toString();
    }

    private void floodFill(String[][] a, SourceCode codeSupport, int x, int y) {
        TextProperties textProps = new TextProperties();
        textProps.set("font", new Font("SansSerif", 1, 14));
        if (this.currentText == null) {
            textProps.set("color", new Color(0, 0, 0));
            this.lang.newText(new Coordinates(400, 10), "Run algorithm: Start at center position (1, 1)", "", null, textProps);
            this.currentText = this.lang.newText(new Coordinates(400, 30), "", "", null, textProps);
            this.lang.nextStep();
        }
        if (x > 2 || x < 0 || y > 2 || y < 0) {
            textProps.set("color", this.wrongPixel);
            this.currentText = this.lang.newText(new Offset(0, 15, this.currentText, "NW"), "fill4(" + x + ", " + y + ") - out of bounds", this.currentText.getName(), null, textProps);
            this.lang.nextStep();
        } else if (a[x][y] == "1") {
            a[x][y] = "x";
            textProps.set("color", this.filledPixel);
            this.currentText = this.lang.newText(new Offset(0, 15, this.currentText, "NW"), "fill4(" + x + ", " + y + ")", this.currentText.getName(), null, textProps);
            this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.highlightPixel));
            this.lang.nextStep();
            this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.filledPixel));
            this.lang.addLine("setGridValue \"field[" + (2 - y) + "][" + x + "]\" \"" + this.depth++ + "\"");
            this.floodFill(a, codeSupport, x, y + 1);
            this.floodFill(a, codeSupport, x, y - 1);
            this.floodFill(a, codeSupport, x + 1, y);
            this.floodFill(a, codeSupport, x - 1, y);
        } else if (a[x][y] == "x") {
            textProps.set("color", this.wrongPixel);
            this.currentText = this.lang.newText(new Offset(0, 15, this.currentText, "NW"), "fill4(" + x + ", " + y + ") - already filled", this.currentText.getName(), null, textProps);
            this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.highlightPixel));
            this.lang.nextStep();
            this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.filledPixel));
        } else {
            textProps.set("color", this.wrongPixel);
            this.currentText = this.lang.newText(new Offset(0, 15, this.currentText, "NW"), "fill4(" + x + ", " + y + ")", this.currentText.getName(), null, textProps);
            this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.highlightPixel));
            this.lang.nextStep();
            this.lang.addLine("setGridColor \"field[" + (2 - y) + "][" + x + "]\" fillColor " + this.colorToString(this.standardPixel));
        }
    }

    @Override
    public String getAlgorithmName() {
        return ALGORITHM;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getAnimationAuthor() {
        return AUTHORS;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.ENGLISH;
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(0x40000000);
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getName() {
        return "FloodFill (4-neighbor)";
    }
}

