/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.cryptography;

import de.ahrgr.animal.kohnert.generators.VigenereEncode2;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Locale;

public class VigenereDecodeWrapperEN
implements Generator {
    private static final String DESCRIPTION = "Vigen\u00cbre-Encryption encrypts a given text using a key phrase. First, the key phrase is copied below the text until each input character of the text is associated with a character of the key phrase. For a reasonable encryption, the key phrase should have a sufficient length.\nThe algorithm then creates a n*m table, where n is the size of the underlying alphabet, and m is the length of the key phrase.\nThe key phrase is inserted into the first row of this table. All columns are then filled with the continuous characters from the alphabet, starting with the character in the given column's first row.\nA given input character is then encoded by the table in row (code of the key phrase associated with the current input character) and column (code of the current input character).";
    private GeneratorType myType = new GeneratorType(128);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Vigen\u00cbre-Decryption";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return "TBD";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    private Hashtable<String, Object> provideMappedProperties(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        Hashtable<String, Object> mapper = new Hashtable<String, Object>(59);
        mapper.put("stringToDecode", primitives.get("stringToDecode"));
        mapper.put("key", primitives.get("key"));
        mapper.put("encodeLabel", primitives.get("encodeLabel"));
        mapper.put("keyLabel", primitives.get("keyLabel"));
        mapper.put("repeatedCopyLabel", primitives.get("repeatedCopyLabel"));
        mapper.put("charSet", primitives.get("charSet"));
        mapper.put("title", primitives.get("title"));
        mapper.put("tableCreateLabel", primitives.get("tableCreateLabel"));
        mapper.put("codePosLabel", primitives.get("codePosLabel"));
        mapper.put("numberSteps", primitives.get("numberSteps (0=alle)"));
        mapper.put("codeColor", props.get("code", "color"));
        mapper.put("codeFont", props.get("code", "font"));
        mapper.put("titleColor", props.get("title", "color"));
        mapper.put("titleFont", props.get("title", "font"));
        mapper.put("tableRowColor", props.get("tableRow", "color"));
        mapper.put("tableColumnColor", props.get("tableColumn", "color"));
        mapper.put("tableFillColor", props.get("tableFill", "color"));
        mapper.put("resultColor", props.get("result", "color"));
        mapper.put("backgroundColor", props.get("background", "color"));
        mapper.put("backgroundColFirstRow", props.get("backgroundColFirstRow", "color"));
        return mapper;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        Hashtable<String, Object> mapper = this.provideMappedProperties(props, primitives);
        VigenereEncode2 encoder = new VigenereEncode2(mapper);
        StringWriter myWriter = new StringWriter();
        encoder.generate(myWriter);
        return myWriter.toString();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getAnimationAuthor() {
        return "Eike Kohnert";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAlgorithmName() {
        return "Vigenere Decoding";
    }

    @Override
    public void init() {
    }
}

