/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.cryptography;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.IllegalDirectionException;
import algoanim.interactionsupport.DocumentationLink;
import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.GroupInfo;
import algoanim.interactionsupport.MultipleChoiceQuestion;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import algoanim.util.Timing;
import avinteraction.parser.InteractionFactory;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class CaesarChiffre2
implements Generator {
    private static final String AUTHOR = "Alper,Bilal,G\u00f6khan";
    private final Coordinates COORDINATES_HEADER = new Coordinates(100, 20);
    private final Coordinates COORDINATES_ALGODESCRIPTION = new Coordinates(10, 50);
    private final Coordinates COORDINATES_AR_PLAIN = new Coordinates(110, 100);
    private final Coordinates COORDINATES_AR_ALPHABET = new Coordinates(10, 200);
    private final Coordinates COORDINATES_AR_CHIFFRE = new Coordinates(110, 290);
    private final Coordinates COORDINATES_DESC_SHIFT = new Coordinates(100, 170);
    private final Coordinates COORDINATES_DESC_ALPHABET = new Coordinates(100, 220);
    private final Coordinates COORDINATES_DESC_PLAIN = new Coordinates(100, 120);
    private final Coordinates COORDINATES_SHIFTTEXT = new Coordinates(10, 150);
    private final Coordinates COORDINATES_SHIFTTEXT_MOVE = new Coordinates(10, 250);
    private final Coordinates COORDINATES_SOURCECODE = new Coordinates(40, 320);
    private final Coordinates COORDINATES_DESCRIPTION = new Coordinates(10, 600);
    private final Coordinates COORDINATES_TB_PLAIN = new Coordinates(10, this.COORDINATES_AR_PLAIN.getY());
    private final Coordinates COORDINATES_TB_CHIFFRE = new Coordinates(10, this.COORDINATES_AR_CHIFFRE.getY());
    AnimalScript lang = new AnimalScript("CaesarChiffre Animation", "Us", 640, 480);
    SourceCodeProperties scProps;
    SourceCode sc;
    SourceCode desc_algorithm;
    ArrayProperties ar_plain_p;
    StringArray ar_plain;
    ArrayProperties ar_chiffre_p;
    StringArray ar_chiffre;
    ArrayProperties ar_alphabet_p;
    StringArray ar_alphabet;
    ArrayMarker i;
    ArrayMarker am_alphabet;
    StringArray ar_alphabet_zahl;
    boolean mod26 = false;
    int countCodeLine = 0;
    Timing defaultTiming;
    Text description;
    private String[] descriptionText;
    private Hashtable<String, String> descriptionVars;
    private ArrayMarkerProperties am_i_p;
    private ArrayMarkerProperties am_alphabet_p;
    private Text tb_plain;
    private Text tb_chiffre;
    private SourceCodeProperties descriptionProps;
    private int shift;

    public static void main(String[] args) throws IllegalDirectionException {
        String plaintext = "Klartext";
        int shift = 4;
        CaesarChiffre2 csChiffre = new CaesarChiffre2();
        csChiffre.caesarChiffre(plaintext, shift);
        csChiffre.getLang().writeFile("D:\\CaesarChiffre.asu");
        System.out.println(csChiffre.getLang());
    }

    public CaesarChiffre2() {
        this.lang.setStepMode(true);
        this.init_CaesarChiffre();
    }

    public AnimalScript getLang() {
        return this.lang;
    }

    public void init_CaesarChiffre() {
        this.defaultTiming = new TicksTiming(15);
        this.descriptionText = new String[13];
        this.descriptionText[0] = "Die Methode bekommt als Parameter den Klartext und Verschiebewert.";
        this.descriptionText[1] = "Das Klartextalphabet wird initialisiert.";
        this.descriptionText[2] = "Der Klartext wird in Gro\ufb02buchstaben umgewandelt.";
        this.descriptionText[3] = "Als Ausgabe erhalten wir ein Chiffretext. ";
        this.descriptionText[4] = "Der Zeiger i wird um eine Stelle nach rechts verschoben. ";
        this.descriptionText[5] = "Das %i'te Element im Klartext wird ausgelesen.";
        this.descriptionText[6] = "Ist das aktuelle Element ein Buchstabe?";
        this.descriptionText[7] = "Berechne die Position vom Buchstaben im Alphabet.";
        this.descriptionText[8] = "Verschl\u00b8ssele den Buchstaben %k durch Verschiebung um %s Buchstaben.";
        this.descriptionText[9] = " Der verschl\u00b8sselte Buchstabe %c wird in die Chiffre \u00b8bertragen.";
        this.descriptionText[10] = "Ausgabe des Geheimtextes.";
        this.descriptionText[11] = "%k  um %s Buchstaben veschoben ergibt %alpha";
        this.descriptionText[12] = "Der Zeiger i wird initialisiert.";
        this.descriptionVars = new Hashtable();
        this.am_i_p = new ArrayMarkerProperties();
        this.am_i_p.set("color", Color.BLACK);
        this.am_i_p.set("label", "i");
        this.am_alphabet_p = new ArrayMarkerProperties();
        this.am_alphabet_p.set("color", Color.BLACK);
    }

    public void caesarChiffre(String plaintext, int shift) throws IllegalDirectionException {
        String[] str_desc_alphabet;
        String[] str_desc_shift;
        String[] str_desc_plain;
        String[] str_desc;
        Text header = this.lang.newText(this.COORDINATES_HEADER, "C\u2030sar-Chiffre", "header", this.defaultTiming);
        header.setFont(new Font("Serif", 1, 40), null, this.defaultTiming);
        this.shift = shift;
        this.lang.addLabel("Einf\u00b8hrung");
        this.desc_algorithm = this.createDescription(this.COORDINATES_ALGODESCRIPTION, "desc_algo");
        String[] stringArray = str_desc = new String[]{"Die C\u2030sar-Chiffre ist eines der einfachsten Verfahren", "zum Verschl\u00b8sseln von Nachrichten. Der Name kommt ", "vom r\u02c6mischen Kaiser Julius C\u2030sar (100-44 v. Chr.),", "der dieses Verfahren w\u2030hrend seiner Regentschaft", "im R\u02c6mischen Reich verwendet hat.", "", "Dabei wird jedem Buchstaben eines Klartextes ein", "anderer eindeutiger Buchstabe zugewiesen.", "Man spricht von monoalphabetischer Substitution.", "", "Die Zuordnung basiert auf der zyklischen Rotation", "des Alphabets um x Zeichen, dabei folgt auf", "'Z' wieder 'A'. Das x ist der Schl\u00b8ssel, mit dem", "verschl\u00b8sselt oder entschl\u00b8sselt wird. ", "siehe: http://home.arcor.de/wemmzi/downloads/vigenere.pdf"};
        int n = str_desc.length;
        int n2 = 0;
        while (n2 < n) {
            String tmpstr = stringArray[n2];
            this.addDescriptionLine(tmpstr, this.desc_algorithm);
            ++n2;
        }
        this.lang.nextStep();
        this.lang.setInteractionType(1024);
        FillInBlanksQuestion algoName = new FillInBlanksQuestion(this.lang, "algoName");
        algoName.setPrompt("Auf welchen Kaiser geht der Name dieses Algorithmus zur\u00b8ck?");
        algoName.setQuestionGroup("Einf\u00b8hrung");
        algoName.addAnswer("Julius C\u2030sar", "Julius C\u2030sar (100-44 v. Chr.) verwendete diesen Algorithmus", 1);
        this.lang.addFIBQuestion(algoName);
        this.lang.nextStep();
        this.desc_algorithm.hide();
        this.ar_plain = this.lang.newStringArray(this.COORDINATES_AR_PLAIN, this.convertToStringArray(plaintext), "ar_plain", null, this.ar_plain_p);
        this.tb_plain = this.lang.newText(this.COORDINATES_TB_PLAIN, "Klartext:", "tb_plain", this.defaultTiming);
        this.tb_plain.setFont(new Font("Serif", 0, 20), null, this.defaultTiming);
        plaintext = plaintext.toUpperCase();
        this.ar_plain.hide();
        this.ar_plain = this.lang.newStringArray(this.COORDINATES_AR_PLAIN, this.convertToStringArray(plaintext), "ar_plain", null, this.ar_plain_p);
        SourceCode description_Plain = this.createDescription(this.COORDINATES_DESC_PLAIN, "desc_plaintext");
        String[] stringArray2 = str_desc_plain = new String[]{"Der Klartext wird in den folgenden Schritten verschl\u00b8sselt.", "In dieser Animation werden nur Grossbuchstaben verschl\u00b8sselt."};
        int n3 = str_desc_plain.length;
        int n4 = 0;
        while (n4 < n3) {
            String tmpstr = stringArray2[n4];
            this.addDescriptionLine(tmpstr, description_Plain);
            ++n4;
        }
        this.lang.nextStep();
        description_Plain.hide();
        Text shiftText = this.lang.newText(this.COORDINATES_SHIFTTEXT, "Schl\u00b8ssel: " + shift, "shiftText", this.defaultTiming);
        shiftText.setFont(new Font("Serif", 0, 20), null, this.defaultTiming);
        SourceCode description_shift = this.createDescription(this.COORDINATES_DESC_SHIFT, "desc_shift");
        String[] stringArray3 = str_desc_shift = new String[]{"Der Schl\u00b8ssel gibt den Wert an, um den", "die Klartextbuchstaben nach rechts verschoben werden.", "Der Klartext und der Schl\u00b8ssel werden als Parameter \u00b8bergeben."};
        int n5 = str_desc_shift.length;
        int n6 = 0;
        while (n6 < n5) {
            String tmpstr = stringArray3[n6];
            this.addDescriptionLine(tmpstr, description_shift);
            ++n6;
        }
        this.lang.nextStep();
        description_shift.hide();
        String[] Alphabet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        this.ar_alphabet = this.lang.newStringArray(this.COORDINATES_AR_ALPHABET, Alphabet, "ar_alphabet", null, this.ar_alphabet_p);
        SourceCode description_alphabet = this.createDescription(this.COORDINATES_DESC_ALPHABET, "desc_alphabet");
        String[] stringArray4 = str_desc_alphabet = new String[]{"Die Verschl\u00b8sselung wird anhand des Alphabets (oben) erkl\u2030rt."};
        int n7 = str_desc_alphabet.length;
        int n8 = 0;
        while (n8 < n7) {
            String tmpstr = stringArray4[n8];
            this.addDescriptionLine(tmpstr, description_alphabet);
            ++n8;
        }
        this.lang.nextStep();
        description_alphabet.hide();
        shiftText.moveTo(null, null, this.COORDINATES_SHIFTTEXT_MOVE, new TicksTiming(10), new TicksTiming(10));
        StringBuffer chiffre = new StringBuffer();
        this.ar_chiffre = this.lang.newStringArray(this.COORDINATES_AR_CHIFFRE, this.convertToEmptyStringArray(plaintext), "ar_chiffre", null, this.ar_chiffre_p);
        this.tb_chiffre = this.lang.newText(this.COORDINATES_TB_CHIFFRE, "Geheimtext:", "tb_chiffre", this.defaultTiming);
        this.tb_chiffre.setFont(new Font("Serif", 0, 20), null, this.defaultTiming);
        this.lang.addLabel("Der Algorithmus");
        this.showSourceCode();
        this.sc.highlight(0);
        this.sc.highlight(1);
        this.sc.highlight(2);
        this.sc.highlight(3);
        this.description = this.lang.newText(this.COORDINATES_DESCRIPTION, "Die ersten drei Zeilen im Code dienen der Initzialisierung", "description", this.defaultTiming);
        this.description.setFont(new Font("Serif", 0, 20), null, this.defaultTiming);
        this.lang.nextStep();
        this.sc.unhighlight(0);
        this.sc.unhighlight(1);
        this.sc.unhighlight(2);
        this.sc.unhighlight(3);
        this.i = this.lang.newArrayMarker(this.ar_plain, 0, "i", null, this.am_i_p);
        InteractionFactory f = new InteractionFactory(this.lang, "InteractionPatterns.xml");
        this.lang.addQuestionGroup(new GroupInfo(this.lang, "chiffre", 3));
        while (this.i.getPosition() < plaintext.length()) {
            MultipleChoiceQuestion chiff = f.generateMCQuestion("caesarChiffreLoop", "chiff" + this.i.getPosition(), "" + plaintext.charAt(this.i.getPosition()));
            this.sc.highlight(4);
            this.showDescription(4);
            this.lang.nextStep();
            this.sc.toggleHighlight(4, 5);
            this.showDescription(5);
            int position = plaintext.charAt(this.i.getPosition());
            chiff.addAnswerOption("" + (char)((position + shift - 65) % 26 + 65), true, "Das ist korrekt", 2);
            chiff.addAnswerOption("" + (char)((position + shift + 3 - 65) % 26 + 65), false, "Nein. Die richtige Antwort lautet: " + (char)((position + shift) % 26), -1);
            chiff.addAnswerOption("" + (char)((position - shift - 65) % 26 + 65), false, "Nein. Die richtige Antwort lautet: " + (char)((position + shift) % 26), -1);
            this.ar_plain.highlightCell(this.i.getPosition(), null, this.defaultTiming);
            this.lang.nextStep();
            this.sc.toggleHighlight(5, 6);
            this.showDescription(6);
            if (position >= 65 && position <= 90) {
                this.lang.nextStep();
                this.sc.toggleHighlight(6, 7);
                this.showDescription(7);
                int oldPosition = position -= 65;
                this.ar_alphabet.highlightCell(oldPosition, null, this.defaultTiming);
                if (this.i.getPosition() == 0) {
                    this.lang.addLabel("Verschl\u00b8sselung des Klartextes(erster Buchstabe)");
                }
                if (this.i.getPosition() == plaintext.length() - 1) {
                    this.lang.addLabel("Verschl\u00b8sselung des Klartextes(letzter Buchstabe)");
                }
                if (position + shift > 26 && !this.mod26) {
                    this.lang.addLabel("Verschl\u00b8sselung des Klartextes(mod 26)");
                    this.mod26 = true;
                }
                this.lang.nextStep();
                this.sc.toggleHighlight(7, 8);
                this.showDescription(8);
                position = (position + shift) % 26;
                this.am_alphabet_p.set("label", "shift + " + String.valueOf(shift));
                this.am_alphabet = this.lang.newArrayMarker(this.ar_alphabet, oldPosition, "shift", this.defaultTiming, this.am_alphabet_p);
                this.lang.nextStep();
                this.am_alphabet.move(position, null, this.defaultTiming);
                this.showDescription(11);
                this.lang.nextStep();
                this.ar_alphabet.highlightCell(this.am_alphabet.getPosition(), null, this.defaultTiming);
                this.lang.nextStep();
                this.ar_alphabet.unhighlightCell(oldPosition, null, this.defaultTiming);
                this.ar_alphabet.unhighlightCell(this.am_alphabet.getPosition(), null, this.defaultTiming);
                this.am_alphabet.hide();
                this.sc.toggleHighlight(8, 9);
                chiffre.append(Alphabet[position]);
                this.ar_chiffre.put(this.i.getPosition(), " " + Alphabet[position] + " ", null, this.defaultTiming);
                this.ar_chiffre.highlightCell(this.i.getPosition(), null, this.defaultTiming);
                this.showDescription(9);
                this.lang.nextStep();
                this.ar_chiffre.unhighlightCell(this.i.getPosition(), null, this.defaultTiming);
                this.sc.unhighlight(9);
            } else {
                this.sc.unhighlight(6);
            }
            this.sc.unhighlight(3);
            this.ar_plain.unhighlightCell(this.i.getPosition(), null, this.defaultTiming);
            this.lang.nextStep();
            this.i.increment(null, this.defaultTiming);
        }
        this.i.hide();
        this.showDescription(10);
        DocumentationLink link = new DocumentationLink(this.lang, "link");
        link.setLinkAddress("http://de.wikipedia.org/wiki/Verschiebechiffre");
        this.lang.addDocumentationLink(link);
        this.lang.nextStep();
    }

    private SourceCode createDescription(Coordinates descCoordinate, String name) {
        return this.lang.newSourceCode(descCoordinate, name, this.defaultTiming, this.descriptionProps);
    }

    private void updateDescription() {
        if (this.i != null && this.i.getPosition() >= 0 && this.i.getPosition() < 8) {
            System.out.println(this.i.getPosition());
            this.descriptionVars.put("%k", this.ar_plain.getData(this.i.getPosition()));
            if (this.am_alphabet != null) {
                this.descriptionVars.put("%alpha", this.ar_alphabet.getData(this.am_alphabet.getPosition()));
            }
            this.descriptionVars.put("%c", this.ar_chiffre.getData(this.i.getPosition()));
            this.descriptionVars.put("%s", String.valueOf(this.shift));
            this.descriptionVars.put("%i", String.valueOf(this.i.getPosition()));
        }
    }

    private void showDescription(int pos) {
        if (pos != 0) {
            this.updateDescription();
        }
        String descriptionNewText = this.descriptionText[pos];
        for (String key : this.descriptionVars.keySet()) {
            if (!descriptionNewText.contains(key)) continue;
            descriptionNewText = descriptionNewText.replace(key, this.descriptionVars.get(key));
        }
        this.description.setText(descriptionNewText, null, this.defaultTiming);
    }

    private void showSourceCode() {
        this.sc = this.lang.newSourceCode(this.COORDINATES_SOURCECODE, "sourceCode", null, this.scProps);
        this.addCodeLine("public String caesarChiffre(String plain, int shift) {", 0);
        this.addCodeLine("char Alphabet[] = { 'A', 'B', 'C', ... ,'Z' };", 1);
        this.addCodeLine("plain=plain.toUpperCase();", 1);
        this.addCodeLine("StringBuffer chiffre = new StringBuffer();", 1);
        this.addCodeLine("for (int i = 0; i < plain.length(); i++) {", 1);
        this.addCodeLine("int position = ((int) plain.charAt(i));", 2);
        this.addCodeLine("if (position >= 'A' && position <= 'Z') {", 2);
        this.addCodeLine("position = position - 'A';", 3);
        this.addCodeLine("position = (position + shift) % 26;", 3);
        this.addCodeLine("chiffre.append(Alphabet[position]);", 3);
        this.addCodeLine("}", 2);
        this.addCodeLine("}", 1);
        this.addCodeLine("return chiffre.toString();", 1);
        this.addCodeLine("}", 0);
    }

    private void addCodeLine(String codeLine, int space) {
        this.sc.addCodeLine(codeLine, null, space, null);
    }

    private void addDescriptionLine(String codeLine, SourceCode sc_description) {
        sc_description.addCodeLine(codeLine, null, 0, null);
    }

    private String[] convertToStringArray(String text) {
        String[] result = new String[text.length()];
        int i = 0;
        while (i < text.length()) {
            result[i] = " " + text.charAt(i) + " ";
            ++i;
        }
        return result;
    }

    private String[] convertToEmptyStringArray(String text) {
        String[] result = new String[text.length()];
        int i = 0;
        while (i < text.length()) {
            result[i] = "  ";
            ++i;
        }
        return result;
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        this.ar_plain_p = (ArrayProperties)arg0.get(0);
        this.ar_alphabet_p = (ArrayProperties)arg0.get(1);
        this.ar_chiffre_p = (ArrayProperties)arg0.get(2);
        this.scProps = (SourceCodeProperties)arg0.get(3);
        this.descriptionProps = (SourceCodeProperties)arg0.get(4);
        try {
            this.caesarChiffre((String)arg1.get("plaintext"), (Integer)arg1.get("shift"));
        }
        catch (IllegalDirectionException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "C\u2030sar-Chiffre";
    }

    @Override
    public String getAnimationAuthor() {
        return AUTHOR;
    }

    @Override
    public String getCodeExample() {
        return "public String caesarChiffre(String plain, int shift) {\nchar Alphabet[] = { 'A', 'B', 'C', ... ,'Z' };\nplain=plain.toUpperCase();\nStringBuffer chiffre = new StringBuffer();\nfor (int i = 0; i < plain.length(); i++) {\nint position = ((int) plain.charAt(i));\nif (position >= 'A' && position <= 'Z') {\nposition = position - 'A';\nposition = (position + shift) % 26;\nchiffre.append(Alphabet[position]);\n}\n}\nreturn chiffre.toString();\n}\n";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        String[] str_desc = new String[]{"Die C\u2030sar-Chiffre ist eines der einfachsten Verfahren", "zum Verschl\u00b8sseln von Nachrichten. Der Name kommt ", "vom r\u02c6mischen Kaiser Julius C\u2030sar (100-44 v. Chr.),", "der dieses Verfahren w\u2030hrend seiner Regentschaft", "im R\u02c6mischen Reich verwendet hat.", "siehe www.wikipedia.de"};
        String desc_generator = "";
        String[] stringArray = str_desc;
        int n = str_desc.length;
        int n2 = 0;
        while (n2 < n) {
            String tmpstr = stringArray[n2];
            desc_generator = String.valueOf(desc_generator) + tmpstr + "\n";
            ++n2;
        }
        return desc_generator;
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(128);
    }

    @Override
    public String getName() {
        return "C\u2030sar-Chiffre";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public void init() {
    }
}

