/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.cryptography;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class CaesarChiffre
implements Generator {
    private static Language lang;
    private static final String DESCRIPTION = "Die C\u00e4sar-Chiffre ist ein einfaches Verschl\u00fcsselungsverfahren,  bei dem jeder Buchstabe um eine feste Anzahl von Stellen im Alphabet verschoben wird.";
    private static final String SOURCE_CODE = "public static String encrypt(int shiftValue, byte[] plainText) { \n\n    String[] plainAlphabet = {'A','B','C','D','E','F','G','H','I','J','K','L','M',\n                             'N','O','P','Q','R','S','T','U','V','W','X','Y','Z'};\n   String[] cipherAlphabet = new String[26];\n\n   for (int i = 0; i < plainAlphabet.length; i++) {\n      cipherAlphabet[i] = plainAlphabet[(i+shiftValue)%26];\n   }\n\n   StringBuilder cipherText = new StringBuilder(plainText.length);\n\n   for (int i = 0; i < plainText.length; i++) {\n      cipherText.append(cipherAlphabet[(Byte.valueOf(plainText[i])-65)%26]);\n   }\n\n   return cipherText.toString();\n}";

    public CaesarChiffre() {
        lang = new AnimalScript("Caesar-Chiffre", "Henrik Schr\u00f6der, Nedislav Nedyalkov, Latinka Pavlova", 1024, 768);
    }

    public CaesarChiffre(Language l) {
        lang = l;
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getName() {
        return "Caesar-Chiffre";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        String allowedLetters = "abcdefghijklmnopqrstuvwxyz";
        String inputTemp = arg1.get("Plaintext").toString().trim();
        StringBuilder sbPlainText = new StringBuilder(inputTemp.length());
        int i = 0;
        while (i < inputTemp.length()) {
            if (allowedLetters.indexOf(inputTemp.substring(i, i + 1).toLowerCase()) != -1) {
                sbPlainText.append(inputTemp.substring(i, i + 1).toUpperCase());
            }
            ++i;
        }
        inputTemp = sbPlainText.toString();
        String[] arrPlainTextInput = new String[inputTemp.length()];
        int i2 = 0;
        while (i2 < arrPlainTextInput.length) {
            arrPlainTextInput[i2] = inputTemp.substring(i2, i2 + 1);
            ++i2;
        }
        i2 = 0;
        while (i2 < arrPlainTextInput.length) {
            if (arrPlainTextInput[i2].equalsIgnoreCase("I")) {
                arrPlainTextInput[i2] = " I ";
            } else if (arrPlainTextInput[i2].equalsIgnoreCase("J")) {
                arrPlainTextInput[i2] = "J ";
            } else if (arrPlainTextInput[i2].equalsIgnoreCase("L")) {
                arrPlainTextInput[i2] = "L ";
            } else if (arrPlainTextInput[i2].equalsIgnoreCase("T")) {
                arrPlainTextInput[i2] = "T ";
            } else if (arrPlainTextInput[i2].equalsIgnoreCase("Y")) {
                arrPlainTextInput[i2] = "Y ";
            } else if (arrPlainTextInput[i2].equalsIgnoreCase("Z")) {
                arrPlainTextInput[i2] = "Z ";
            }
            ++i2;
        }
        int shiftValue = Integer.parseInt(arg1.get("Shiftvalue(minValue=1,maxValue=25)").toString());
        if (shiftValue < 1) {
            shiftValue = 1;
        } else if (shiftValue > 25) {
            shiftValue = 25;
        }
        lang.setStepMode(true);
        RectProperties rp = new RectProperties();
        rp.set("fillColor", Color.YELLOW);
        rp.set("filled", Boolean.TRUE);
        lang.newRect(new Coordinates(120, 10), new Coordinates(315, 41), "HeaderRect", null, rp);
        TextProperties tp = new TextProperties();
        tp.set("font", new Font("Monospaced", 1, 20));
        lang.newText(new Coordinates(140, 15), "Caesar-Cipher", "Header", null, tp);
        lang.newRect(new Coordinates(490, 5), new Coordinates(490, 600), "vertLine", null, rp);
        SourceCodeProperties scProps = (SourceCodeProperties)arg0.getPropertiesByName("SourceCode");
        SourceCode sc = lang.newSourceCode(new Coordinates(500, 100), "sourceCode", null, scProps);
        sc.addCodeLine("public static String encrypt", null, 0, null);
        sc.addCodeLine("(int shiftValue, ", null, 16, null);
        sc.addCodeLine("byte[] plainText) {", null, 17, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("String[] plainAlphabet = {'A','B','C','D','E','F','G','H','I','J','K','L','M',", null, 3, null);
        sc.addCodeLine("'N','O','P','Q','R','S','T','U','V','W','X','Y','Z'};", null, 18, null);
        sc.addCodeLine("String[] cipherAlphabet = new String[26];", null, 3, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("for (int i = 0; i < plainAlphabet.length; i++) {", null, 3, null);
        sc.addCodeLine("cipherAlphabet[i] = plainAlphabet[(i+shiftValue)%26];", null, 6, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("StringBuilder cipherText = new StringBuilder(plainText.length);", null, 3, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("for (int i = 0; i < plainText.length; i++) {", null, 3, null);
        sc.addCodeLine("cipherText.append(cipherAlphabet[Byte.valueOf(plainText[i])-65]);", null, 6, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("return cipherText.toString();", null, 3, null);
        sc.addCodeLine("}", null, 3, null);
        lang.nextStep();
        TextProperties textProp = (TextProperties)arg0.getPropertiesByName("Text");
        textProp.set("font", new Font("SansSerif", 1, 14));
        Text tshiftValue = lang.newText(new Coordinates(20, 100), "Shift Value = " + shiftValue, "verschiebeWert", null, textProp);
        sc.highlight(1);
        lang.nextStep();
        ArrayProperties prop_plainText = (ArrayProperties)arg0.getPropertiesByName("Arrays");
        lang.newText(new Coordinates(20, 150), "Plaintext", "plaintext", null, textProp);
        StringArray strArrPlainText = lang.newStringArray(new Coordinates(20, 180), arrPlainTextInput, "stringArray", null, prop_plainText);
        sc.unhighlight(1);
        sc.highlight(2);
        lang.nextStep();
        lang.newText(new Coordinates(20, 270), "Plain alphabet", "plain alphabet", null, textProp);
        String[] plainAlphabet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", " I ", "J ", "K", "L ", "M", "N", "O", "P", "Q", "R", "S", "T ", "U", "V", "W", "X", "Y ", "Z "};
        StringArray strArrPlainAlphabet = lang.newStringArray(new Coordinates(20, 300), plainAlphabet, "Alphabet1", null, prop_plainText);
        sc.unhighlight(2);
        sc.highlight(4);
        sc.highlight(5);
        lang.nextStep();
        String[] cipherAlphabet = new String[26];
        int i3 = 0;
        while (i3 < cipherAlphabet.length) {
            cipherAlphabet[i3] = "   ";
            ++i3;
        }
        lang.newText(new Coordinates(20, 330), "Cipher alphabet", "cipher alphabet", null, textProp);
        StringArray strArrCipherAlphbet = lang.newStringArray(new Coordinates(20, 360), cipherAlphabet, "Alphabet2", null, prop_plainText);
        sc.unhighlight(4);
        sc.unhighlight(5);
        sc.highlight(6);
        lang.nextStep();
        strArrCipherAlphbet.highlightCell(0, null, null);
        strArrPlainAlphabet.highlightCell(0, null, null);
        sc.unhighlight(6);
        sc.highlight(8);
        sc.highlight(9);
        sc.highlight(10);
        lang.nextStep();
        int shiftCounter = shiftValue;
        Text tShiftCounter = lang.newText(new Coordinates(200, 270), "Shift: " + String.valueOf(shiftCounter), "shift counter", null, textProp);
        tShiftCounter.changeColor(null, Color.RED, null, null);
        tshiftValue.changeColor(null, Color.RED, null, null);
        lang.nextStep();
        tShiftCounter.changeColor(null, Color.BLACK, null, null);
        tshiftValue.changeColor(null, Color.BLACK, null, null);
        lang.nextStep();
        int i4 = 0;
        while (i4 < shiftValue) {
            strArrPlainAlphabet.unhighlightCell(i4 % 26, null, null);
            strArrPlainAlphabet.highlightCell((i4 + 1) % 26, null, null);
            tShiftCounter.hide();
            tShiftCounter = lang.newText(new Coordinates(200, 270), "Shift: " + String.valueOf(--shiftCounter), "shift counter", null, textProp);
            lang.nextStep();
            ++i4;
        }
        strArrCipherAlphbet.put(0, plainAlphabet[shiftValue % 26], null, null);
        lang.nextStep();
        tShiftCounter.hide();
        lang.nextStep();
        strArrPlainAlphabet.unhighlightCell(shiftValue % 26, null, null);
        strArrCipherAlphbet.unhighlightCell(0, null, null);
        strArrPlainAlphabet.highlightCell((shiftValue + 1) % 26, null, null);
        strArrCipherAlphbet.highlightCell(1, null, null);
        lang.nextStep();
        strArrCipherAlphbet.put(1, plainAlphabet[(shiftValue + 1) % 26], null, null);
        lang.nextStep();
        strArrPlainAlphabet.unhighlightCell((shiftValue + 1) % 26, null, null);
        strArrCipherAlphbet.unhighlightCell(1, null, null);
        strArrPlainAlphabet.highlightCell((shiftValue + 2) % 26, null, null);
        strArrCipherAlphbet.highlightCell(2, null, null);
        lang.nextStep();
        strArrCipherAlphbet.put(2, plainAlphabet[(shiftValue + 2) % 26], null, null);
        lang.nextStep();
        strArrPlainAlphabet.unhighlightCell((shiftValue + 2) % 26, null, null);
        strArrCipherAlphbet.unhighlightCell(2, null, null);
        String[] strArrCipherAlmostFull = new String[26];
        int i5 = 0;
        while (i5 < 23) {
            strArrCipherAlmostFull[i5] = strArrPlainAlphabet.getData((i5 + shiftValue) % 26);
            ++i5;
        }
        strArrCipherAlmostFull[23] = "   ";
        strArrCipherAlmostFull[24] = "   ";
        strArrCipherAlmostFull[25] = "   ";
        strArrCipherAlphbet.hide();
        strArrCipherAlphbet = lang.newStringArray(new Coordinates(20, 360), strArrCipherAlmostFull, "Alphabet3", null, prop_plainText);
        strArrPlainAlphabet.highlightCell((shiftValue + 23) % 26, null, null);
        strArrCipherAlphbet.highlightCell(23, null, null);
        lang.nextStep();
        strArrCipherAlphbet.put(23, plainAlphabet[(shiftValue + 23) % 26], null, null);
        lang.nextStep();
        strArrPlainAlphabet.unhighlightCell((shiftValue + 23) % 26, null, null);
        strArrCipherAlphbet.unhighlightCell(23, null, null);
        strArrPlainAlphabet.highlightCell((shiftValue + 24) % 26, null, null);
        strArrCipherAlphbet.highlightCell(24, null, null);
        lang.nextStep();
        strArrCipherAlphbet.put(24, plainAlphabet[(shiftValue + 24) % 26], null, null);
        lang.nextStep();
        strArrPlainAlphabet.unhighlightCell((shiftValue + 24) % 26, null, null);
        strArrCipherAlphbet.unhighlightCell(24, null, null);
        strArrPlainAlphabet.highlightCell((shiftValue + 25) % 26, null, null);
        strArrCipherAlphbet.highlightCell(25, null, null);
        lang.nextStep();
        strArrCipherAlphbet.put(25, plainAlphabet[(shiftValue + 25) % 26], null, null);
        lang.nextStep();
        strArrPlainAlphabet.unhighlightCell((shiftValue + 25) % 26, null, null);
        strArrCipherAlphbet.unhighlightCell(25, null, null);
        lang.nextStep();
        String[] ciphTxt = new String[strArrPlainText.getLength()];
        int i6 = 0;
        while (i6 < ciphTxt.length) {
            ciphTxt[i6] = "   ";
            ++i6;
        }
        lang.newText(new Coordinates(20, 470), "Ciphertext", "ciphertext", null, textProp);
        StringArray strArrCipherText = lang.newStringArray(new Coordinates(20, 500), ciphTxt, "CipherText", null, prop_plainText);
        sc.unhighlight(8);
        sc.unhighlight(9);
        sc.unhighlight(10);
        sc.highlight(12);
        lang.nextStep();
        sc.unhighlight(12);
        sc.highlight(14);
        sc.highlight(15);
        sc.highlight(16);
        lang.nextStep();
        int alphPos = 0;
        int i7 = 0;
        while (i7 < strArrPlainText.getLength()) {
            strArrPlainText.highlightCell(i7, null, null);
            lang.nextStep();
            int j = 0;
            while (j < 26) {
                if (strArrPlainText.getData(i7).trim().equalsIgnoreCase(strArrPlainAlphabet.getData(j).trim())) {
                    alphPos = j;
                    strArrPlainAlphabet.highlightCell(j, null, null);
                    lang.nextStep();
                    break;
                }
                ++j;
            }
            strArrCipherAlphbet.highlightCell(alphPos, null, null);
            lang.nextStep();
            strArrCipherText.highlightCell(i7, null, null);
            strArrCipherText.put(i7, strArrCipherAlphbet.getData(alphPos), null, null);
            lang.nextStep();
            strArrPlainText.unhighlightCell(i7, null, null);
            strArrPlainAlphabet.unhighlightCell(alphPos, null, null);
            strArrCipherAlphbet.unhighlightCell(alphPos, null, null);
            strArrCipherText.unhighlightCell(i7, null, null);
            ++i7;
        }
        sc.unhighlight(14);
        sc.unhighlight(15);
        sc.unhighlight(16);
        sc.highlight(18);
        return lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Caesar Cipher";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(128);
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Henrik Schr\u00f6der, Nedislav Nedyalkov, Latinka Pavlova";
    }

    @Override
    public void init() {
    }
}

