/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.cryptography;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.Polyline;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.PolylineProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import algoanim.util.Node;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class Caesar
implements Generator {
    private Language lang;
    private boolean hidden_am_pABC;
    private boolean hidden_am_sABC;
    private TextProperties textProps;
    private ArrayProperties plaintextArrayProps;
    private ArrayProperties plainABCArrayProps;
    private ArrayProperties secretABCArrayProps;
    private ArrayProperties ciphertextArrayProps;
    private ArrayMarkerProperties amPlainProps;
    private ArrayMarkerProperties amSecretProps;
    private SourceCodeProperties scProps;
    private static final String[] PLAIN_ABC = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int width = 16;
    private static final String DESCRIPTION = "Bei der Caesar-Chiffre (auch als Verschiebechiffre, Caesar-Verschluesselung oder Caesar-Verschiebung bezeichnet) wird zum Zwecke der Verschluesselung jeder Buchstabe des lateinischen Standardalphabets um eine bestimmte Anzahl von Positionen zyklisch verschoben (rotiert). Die Anzahl bestimmt den Schluessel (key), der fuer die gesamte Verschluesselung unveraendert bleibt. Es ist eine der einfachsten (und unsichersten) Formen einer Geheimschrift.\nDer Name der Caesar-Verschluesselung leitet sich vom roemischen Feldherrn Gaius Julius Caesar ab, der diese Art der geheimen Kommunikation f\u00b8r seine militaerische Korrespondenz verwendet hat. Dabei benutzte Caesar selbst haeufig den Verschiebewert von drei Buchstaben. Im Allgemeinen kann aber der Schluessel beliebig gewaelt werden.";
    private static final String CODE_EXAMPLE = "Verschluesselung vom \"Plaintext\": \nUm das Geheimtextalphabet \"SecretABC\" zu erhalten, wird das Klartextalphabet \"PlainABC\" um key Stellen nach links verschoben. \nDamit wird der an einer beliebigen Stelle i im \"PlainABC\" stehende Buchstabe an die Position ((i-key) mod 26) ins \"SecretABC\" geschrieben. \nUm einen Buchstaben aus dem \"Plaintext\" zu verschluesseln, muss er zunaechst im \"PlainABC\" gefunden werden. Der Buchstabe mit dem gleichen Index im \"SecretABC\" verschluesselt dann den Buchstaben aus dem \"PlainABC\" und wird an die entsprechende Position (=Position des zu verschluesselnden Buchstabens im \"Plaintext\") ins \"Ciphertext\" geschrieben. \nDie 26 Buchstaben des lateinischen Standardalphabets werden unabhaengig von der Schreibweise (gross oder klein) im \"Plaintext\" als Grossbuchstaben im \"Ciphertext\" verschluesselt. Das Leerzeichen wird durch sich selbst verschluesselt, und alle anderen Buchstaben, die nicht zum lateinischen Standardalphabet gehoeren, werden bei der Verschluesselung ignoriert.";

    public Caesar(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public Caesar() {
        this(new AnimalScript("Caesar Chiffre", "Dmytro Vronskyi", 640, 480));
    }

    private void encode(String plaintext, int key) {
        MsTiming delay = new MsTiming(1000);
        MsTiming delay2 = new MsTiming(2000);
        TextProperties titleTextProp = new TextProperties();
        titleTextProp.set("font", new Font("Monospaced", 1, 24));
        this.lang.newText(new Coordinates(480, 40), "Caesar Cipher Algorithm", "title", null, titleTextProp);
        this.lang.nextStep();
        String[] temparray = plaintext.split("");
        String[] plainArray = new String[temparray.length - 1];
        int i = 0;
        while (i < plainArray.length) {
            plainArray[i] = temparray[i + 1];
            ++i;
        }
        StringArray pa = this.lang.newStringArray(new Coordinates(20, 100), plainArray, "plainArray", null, this.plaintextArrayProps);
        this.lang.newText(new Offset(20, 0, pa, "NE"), "Plaintext", "Plaintext", null, this.textProps);
        SourceCode sc = this.lang.newSourceCode(new Offset(400, -20, pa, "NE"), "code", null, this.scProps);
        sc.addCodeLine("Verschl\u00b8sselung vom Plaintext:", null, 0, null);
        sc.addCodeLine("", null, 0, null);
        sc.addCodeLine("Bestimme SecretABC durch Verschiebung vom PlainABC um key Stellen nach links", null, 0, null);
        sc.addCodeLine("F\u00b8r jeden Buchstaben c aus dem Plaintext", null, 0, null);
        sc.addCodeLine("Finde c im PlainABC", null, 1, null);
        sc.addCodeLine("Finde den Buchstaben mit dem gleichen Index im SecretABC", null, 1, null);
        sc.addCodeLine("Schreibe den gefundenen verschl\u00b8ssenden Buchstaben aus dem SecretABC ins Ciphertext an die Position vom c", null, 1, null);
        this.lang.nextStep();
        StringArray pABC = this.lang.newStringArray(new Coordinates(20, 220), PLAIN_ABC, "plainABC", null, this.plainABCArrayProps);
        ArrayMarker am_pABC = this.lang.newArrayMarker(pABC, 0, "am_pABC", null, this.amPlainProps);
        am_pABC.hide(null);
        this.hidden_am_pABC = true;
        Text pABC_label = this.lang.newText(new Offset(20, 8, pABC, "E"), "PlainABC", "PlainABC", null, this.textProps);
        String[] secretABC = new String[26];
        int i2 = 0;
        while (i2 < secretABC.length) {
            secretABC[(i2 - key + 26) % 26] = PLAIN_ABC[i2];
            ++i2;
        }
        this.lang.nextStep();
        this.lang.newText(new Offset(0, 50, pABC_label, "NW"), "key = " + key, "key", null, this.textProps);
        pABC.highlightCell(key, pABC.getLength() - 1, delay2, delay);
        StringArray sABC = this.lang.newStringArray(new Coordinates(20, 320), secretABC, "secretABC", new ArrayDisplayOptions(delay2, delay, false), this.secretABCArrayProps);
        sABC.highlightCell(0, sABC.getLength() - key - 1, delay2, delay);
        ArrayMarker am_sABC = this.lang.newArrayMarker(sABC, 0, "am_sABC", delay2, this.amSecretProps);
        am_sABC.hide(delay2);
        this.hidden_am_sABC = true;
        this.lang.newText(new Offset(20, 8, sABC, "E"), "SecretABC", "SecretABC", delay2, this.textProps);
        sc.highlight(2);
        PolylineProperties plp = new PolylineProperties();
        plp.set("fwArrow", true);
        Node[] nodes1 = new Node[]{new Offset(key * 16, 0, pABC, "SW"), sABC.getUpperLeft()};
        Polyline pl1 = this.lang.newPolyline(nodes1, "", delay2, plp);
        Node[] nodes2 = new Node[]{new Offset(0, 0, pABC, "SE"), new Offset(-key * 16, 40, sABC, "NE")};
        Polyline pl2 = this.lang.newPolyline(nodes2, "", delay2, plp);
        this.lang.nextStep();
        pABC.unhighlightCell(key, pABC.getLength() - 1, null, null);
        sABC.unhighlightCell(0, sABC.getLength() - key - 1, null, null);
        sc.unhighlight(2);
        pl1.hide();
        pl2.hide();
        String[] chiffreArray = new String[plainArray.length];
        int i3 = 0;
        while (i3 < chiffreArray.length) {
            chiffreArray[i3] = "...";
            ++i3;
        }
        StringArray ca = this.lang.newStringArray(new Coordinates(20, 420), chiffreArray, "chiffreArray", null, this.ciphertextArrayProps);
        this.lang.newText(new Offset(20, 0, ca, "NE"), "Ciphertext", "ChiffreArray", null, this.textProps);
        int i4 = 0;
        while (i4 < chiffreArray.length) {
            this.lang.nextStep();
            sc.highlight(3);
            pa.highlightCell(i4, null, null);
            int index = plainArray[i4].toLowerCase().codePointAt(0) - 97;
            pa.highlightElem(i4, null, null);
            this.lang.nextStep();
            sc.toggleHighlight(3, 4);
            pa.unhighlightElem(i4, null, null);
            if (index < 0 || index > 122) {
                if (index == -65) {
                    ca.put(i4, " ", null, null);
                }
            } else {
                am_pABC.move(index, null, null);
                if (this.hidden_am_pABC) {
                    am_pABC.show();
                }
                pABC.highlightElem(index, null, null);
                pABC.highlightCell(index, null, null);
                this.lang.nextStep();
                sc.toggleHighlight(4, 0, false, 5, 0, delay, null);
                am_sABC.move(index, null, null);
                if (this.hidden_am_sABC) {
                    am_sABC.show(null);
                }
                sABC.highlightElem(index, delay, null);
                sABC.highlightCell(index, null, null);
                pABC.unhighlightElem(index, delay, null);
                this.lang.nextStep();
                sc.toggleHighlight(5, 6);
                sABC.unhighlightElem(index, null, null);
                ca.put(i4, sABC.getData(index), null, null);
                ca.highlightCell(i4, null, null);
                pABC.unhighlightCell(index, null, null);
                sABC.unhighlightCell(index, null, null);
                this.lang.nextStep();
                sc.unhighlight(6);
            }
            ++i4;
        }
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.textProps = (TextProperties)props.getPropertiesByName("text");
        this.plaintextArrayProps = (ArrayProperties)props.getPropertiesByName("plaintextArrayProps");
        this.plainABCArrayProps = (ArrayProperties)props.getPropertiesByName("plainABCArrayProps");
        this.secretABCArrayProps = (ArrayProperties)props.getPropertiesByName("secretABCArrayProps");
        this.ciphertextArrayProps = (ArrayProperties)props.getPropertiesByName("ciphertextArrayProps");
        this.amPlainProps = (ArrayMarkerProperties)props.getPropertiesByName("plainABCMarker");
        this.amSecretProps = (ArrayMarkerProperties)props.getPropertiesByName("secretABCMarker");
        this.scProps = (SourceCodeProperties)props.getPropertiesByName("code");
        String text = (String)primitives.get("Plaintext");
        int key = (Integer)primitives.get("key");
        this.encode(text, key);
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getAlgorithmName() {
        return "Caesar Chiffre";
    }

    @Override
    public String getCodeExample() {
        return CODE_EXAMPLE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(128);
    }

    @Override
    public String getName() {
        return "Caesar Chiffre";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String getAnimationAuthor() {
        return "Dmytro Vronskyi";
    }

    @Override
    public void init() {
    }
}

