/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.compression;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.Primitive;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.util.Coordinates;
import algoanim.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.compression.CompressionAlgorithm;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Sequitur
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 10;
    private static final String DESCRIPTION = "Sequitur ist ein W\u02c6rterbuch-basiertes Kompressionsverfahren.  Durch ein iteratives Vorgehen wird aus dem Eingabetext eine Grammatik erzeugt, so dass h\u2030ufig auftretende Zeichen kodiert werden k\u02c6nnen. Zu einem kodierten Text wird dementsprechend eine Kodierungsliste mit ausgelifert.";
    private static final String SOURCE_CODE = "public void sequitur(char[] array) {\n  String tmp, rest;\n  Hashtable<String, String> dict = new Hashtable<String, String>();\n  for (int i = 0; i < input.length(); i++) {\n    text += input[i];\n  \t for (int j = 0; j < text.length() - 1; j++) {\n  \t    tmp = text[j] + text[j+1];\n  \t\trest = null;\n  \t\tfor (int k = 0; k<text.length(); k++) {\n  \t       if (k != j && k != j + 1) rest += text[k];\n  \t    }\n  \t\tif (rest.contains(tmp)) {\n  \t\t   dict.put((char)ascii, tmp);\n  \t       text = text.replaceAll(tmp, (char)ascii);\n  \t       input = input.replaceAll(tmp, (char)ascii);\n  \t       ascii++;\n  \t       j = j - 2;\n          i = i - 2;\n       }\n    }\n  }\n}";

    public Sequitur() {
        this(new AnimalScript("Sequitur", "Florian Lindner", 800, 600));
    }

    public Sequitur(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] textIn) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(textIn.length, 10)];
        int i = 0;
        while (i < t.length) {
            t[i] = textIn[i];
            ein = String.valueOf(ein) + textIn[i];
            ++i;
        }
        textIn = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Sequitur", "Topic", null, tptopic);
        this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Lese den Eingabestring buchstabenweise ein, und erweitere einen neuen", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(0, 20, step1, "SW"), "   String um die eingelesenen Buchstaben.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step12, "SW"), "2) Tritt eine gelesene Zeichenfolge redundant auf, ersetzte sie durch eine Chiffre.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), "3) F\u00b8hre die Ersetzungen solange fort, bis der String vollst\u2030ndig ist.", "line3", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step12.hide();
        step2.hide();
        step3.hide();
        String input = "";
        int i2 = 0;
        while (i2 < textIn.length) {
            input = String.valueOf(input) + textIn[i2];
            ++i2;
        }
        input = input.toLowerCase();
        algoinWords.hide();
        StringArray in = this.lang.newStringArray(new Offset(0, 75, topic, "SW"), textIn, "in", null, ap);
        ArrayMarker am = this.lang.newArrayMarker(in, 0, "am", null, amp);
        in.highlightCell(0, null, null);
        this.lang.nextStep();
        SourceCode sc = this.lang.newSourceCode(new Offset(0, 75, in, "SW"), "codeName", null, scp);
        sc.addCodeLine("public void sequitur(char[] array) {", null, 0, null);
        sc.addCodeLine("String tmp, rest;", null, 1, null);
        sc.addCodeLine("Hashtable<String, String> dict = new Hashtable<String, String>();", null, 1, null);
        sc.addCodeLine("for (int i = 0; i < input.length(); i++) {", null, 1, null);
        sc.addCodeLine("text += input[i];", null, 2, null);
        sc.addCodeLine("for (int j = 0; j < text.length() - 1; j++) {", null, 2, null);
        sc.addCodeLine("tmp = text[j] + text[j + 1];", null, 3, null);
        sc.addCodeLine("rest = null;", null, 3, null);
        sc.addCodeLine("for (int k = 0; k < text.length(); k++) {", null, 3, null);
        sc.addCodeLine("if (k != j && k != j + 1) rest += text[k];", null, 4, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("if (rest.contains(tmp)) {", null, 3, null);
        sc.addCodeLine("dict.put((char)ascii, tmp);", null, 4, null);
        sc.addCodeLine("text = text.replaceAll(tmp, (char)ascii);", null, 4, null);
        sc.addCodeLine("input = input.replaceAll(tmp, (char)ascii);", null, 4, null);
        sc.addCodeLine("ascii++;", null, 4, null);
        sc.addCodeLine("j = j - 2;", null, 4, null);
        sc.addCodeLine("i = i - 2;", null, 4, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        Text iLabel = this.lang.newText(new Offset(0, 35, sc, "SW"), "i :  ", "i", null, tpsteps);
        Text iContent = this.lang.newText(new Offset(15, 7, iLabel, "E"), "0", "i", null, tpsteps);
        iContent.changeColor(null, Color.RED, null, null);
        Text jLabel = this.lang.newText(new Offset(0, 20, iLabel, "SW"), "j :  ", "j", null, tpsteps);
        Text jContent = this.lang.newText(new Offset(15, 7, jLabel, "E"), "0", "j", null, tpsteps);
        jContent.changeColor(null, Color.RED, null, null);
        Text kLabel = this.lang.newText(new Offset(0, 20, jLabel, "SW"), "k:  ", "k", null, tpsteps);
        Text kContent = this.lang.newText(new Offset(15, 7, kLabel, "E"), "0", "k", null, tpsteps);
        kContent.changeColor(null, Color.RED, null, null);
        Text tmpLabel = this.lang.newText(new Offset(0, 20, kLabel, "SW"), "tmp:", "tmp", null, tpsteps);
        Text tmpContent = this.lang.newText(new Offset(5, 7, tmpLabel, "E"), " ", "tmp", null, tpsteps);
        tmpContent.changeColor(null, Color.RED, null, null);
        Text restLabel = this.lang.newText(new Offset(0, 20, tmpLabel, "SW"), "rest:", " ", null, tpsteps);
        Text restContent = this.lang.newText(new Offset(5, 7, restLabel, "E"), " ", "rest", null, tpsteps);
        restContent.changeColor(null, Color.RED, null, null);
        Vector<StringArray> strArrays = new Vector<StringArray>();
        sc.highlight(0, 0, false);
        this.lang.nextStep();
        sc.toggleHighlight(0, 0, false, 1, 0);
        String text = "";
        this.lang.nextStep();
        int ascii = 65;
        sc.toggleHighlight(1, 0, false, 2, 0);
        Hashtable<String, String> dict = new Hashtable<String, String>();
        this.lang.nextStep();
        sc.toggleHighlight(2, 0, false, 3, 0);
        Primitive strMatrix = null;
        String[] textOut = null;
        int highlightCounter = 0;
        int i3 = 0;
        while (i3 < input.length()) {
            in.highlightCell(highlightCounter, null, null);
            am.move(highlightCounter, null, null);
            if (highlightCounter > 0) {
                in.unhighlightCell(highlightCounter - 1, null, null);
            }
            this.lang.nextStep();
            sc.toggleHighlight(3, 0, false, 4, 0);
            text = String.valueOf(text) + input.charAt(i3);
            textOut = new String[text.length()];
            int p = 0;
            while (p < text.length()) {
                textOut[p] = "" + text.charAt(p);
                ++p;
            }
            int z = 0;
            while (z < strArrays.size()) {
                ((StringArray)strArrays.elementAt(z)).hide();
                ++z;
            }
            strArrays.add(this.lang.newStringArray(new Offset(0, 135, topic, "SW"), textOut, "stringArray", null, ap));
            this.lang.nextStep();
            sc.toggleHighlight(4, 0, false, 5, 0);
            int j = 0;
            while (j < text.length() - 1) {
                this.lang.nextStep();
                sc.toggleHighlight(5, 0, false, 6, 0);
                String tmp = "" + text.charAt(j) + text.charAt(j + 1);
                tmpContent.setText(tmp, null, null);
                this.lang.nextStep();
                sc.toggleHighlight(6, 0, false, 7, 0);
                String rest = "";
                this.lang.nextStep();
                sc.toggleHighlight(7, 0, false, 8, 0);
                int k = 0;
                while (k < text.length()) {
                    this.lang.nextStep();
                    sc.toggleHighlight(8, 0, false, 9, 0);
                    if (k != j && k != j + 1) {
                        rest = String.valueOf(rest) + text.charAt(k);
                    }
                    restContent.setText(rest, null, null);
                    this.lang.nextStep();
                    sc.unhighlight(9, 0, false);
                    sc.highlight(8, 0, false);
                    kContent.setText("" + ++k, null, null);
                }
                this.lang.nextStep();
                sc.unhighlight(5, 0, false);
                sc.unhighlight(8, 0, false);
                sc.highlight(11, 0, false);
                if (rest.contains(tmp)) {
                    this.lang.nextStep();
                    sc.toggleHighlight(11, 0, false, 12, 0);
                    dict.put("" + (char)ascii, tmp);
                    String[][] dictData = new String[dict.size()][2];
                    Enumeration keys = dict.keys();
                    int q = 0;
                    while (q < dict.size()) {
                        dictData[q][0] = (String)keys.nextElement();
                        dictData[q][1] = (String)dict.get(dictData[q][0]);
                        ++q;
                    }
                    if (strMatrix != null) {
                        strMatrix.hide();
                    }
                    strMatrix = this.lang.newStringMatrix(new Offset(50, 0, sc, "NE"), dictData, "dict", null, mp);
                    this.lang.nextStep();
                    sc.toggleHighlight(12, 0, false, 13, 0);
                    text = text.replaceAll(tmp, "" + (char)ascii);
                    textOut = new String[text.length()];
                    int p2 = 0;
                    while (p2 < text.length()) {
                        textOut[p2] = "" + text.charAt(p2);
                        ++p2;
                    }
                    this.lang.nextStep();
                    int z2 = 0;
                    while (z2 < strArrays.size()) {
                        ((StringArray)strArrays.elementAt(z2)).hide();
                        ++z2;
                    }
                    strArrays.add(this.lang.newStringArray(new Offset(0, 135, topic, "SW"), textOut, "stringArray", null, ap));
                    this.lang.nextStep();
                    sc.toggleHighlight(13, 0, false, 14, 0);
                    input = input.replaceAll(tmp, "" + (char)ascii);
                    this.lang.nextStep();
                    sc.toggleHighlight(14, 0, false, 15, 0);
                    ++ascii;
                    this.lang.nextStep();
                    sc.toggleHighlight(15, 0, false, 16, 0);
                    j -= 2;
                    this.lang.nextStep();
                    sc.toggleHighlight(16, 0, false, 17, 0);
                    i3 -= 2;
                    this.lang.nextStep();
                    sc.toggleHighlight(17, 0, false, 18, 0);
                    this.lang.nextStep();
                    sc.unhighlight(11, 0, false);
                    sc.unhighlight(18, 0, false);
                    break;
                }
                sc.unhighlight(8, 0, false);
                sc.unhighlight(11, 0, false);
                sc.highlight(5, 0, false);
                jContent.setText("" + ++j, null, null);
            }
            this.lang.nextStep();
            sc.unhighlight(5, 0, false);
            ++highlightCounter;
            sc.highlight(3, 0, false);
            iContent.setText("" + ++i3, null, null);
        }
        this.lang.nextStep();
        sc.unhighlight(5, 0, false);
        String result = "";
        int i4 = 0;
        while (i4 < textOut.length) {
            result = String.valueOf(result) + textOut[i4];
            ++i4;
        }
        Text fazit1 = this.lang.newText(new Offset(0, 50, restLabel, "SW"), "Resulting encoding: ", "fazit", null, tpsteps);
        tpsteps.set("color", Color.BLUE);
        this.lang.newText(new Offset(15, 0, fazit1, "SE"), result, "fazit1", null, tpsteps);
        tpsteps.set("color", Color.BLACK);
        Text fazit2 = this.lang.newText(new Offset(0, 15, fazit1, "SW"), "The dictionary shown on the right has to be added to the output,", "fazit2", null, tpsteps);
        this.lang.newText(new Offset(0, 15, fazit2, "SW"), "e.g., coded as a Hashtable.", "fazit3", null, tpsteps);
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Sequitur";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

