/*
 * Decompiled with CFR 0.152.
 */
package generator.properties.tree;

import algoanim.primitives.Graph;
import algoanim.properties.AnimationProperties;
import generator.PropertiesGUI;
import generator.properties.AnimationPropertiesContainer;
import generator.properties.GetAsXMLVisitor;
import generator.properties.LoadFromXMLVisitor;
import generator.properties.tree.PropertiesTreeNode;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PropertiesTreeModel
extends DefaultTreeModel
implements ErrorHandler {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XSD_FILE = "generator/properties/tree/PropertiesTreeModel.xsd";
    private static final long serialVersionUID = 3257283630224126006L;
    boolean showItems = true;
    boolean showHiddenItems = true;

    public PropertiesTreeModel() {
        super(new PropertiesTreeNode("Root"));
    }

    public AnimationPropertiesContainer getPropertiesContainer() {
        AnimationPropertiesContainer apc = new AnimationPropertiesContainer(Math.min(23, this.getElementsCount()));
        Enumeration<TreeNode> e = ((PropertiesTreeNode)this.getRoot()).depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreePath t = new TreePath(((PropertiesTreeNode)e.nextElement()).getPath());
            PropertiesTreeNode n = (PropertiesTreeNode)t.getLastPathComponent();
            if (!n.isProperty()) continue;
            apc.add(n.getAnimationProperties());
        }
        apc.updateIndex();
        return apc;
    }

    public Hashtable<String, Object> getPrimitivesContainer() {
        Hashtable<String, Object> h = new Hashtable<String, Object>(Math.min(23, this.getElementsCount()));
        Graph graph = null;
        Enumeration<TreeNode> e = ((PropertiesTreeNode)this.getRoot()).depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreePath t = new TreePath(((PropertiesTreeNode)e.nextElement()).getPath());
            PropertiesTreeNode n = (PropertiesTreeNode)t.getLastPathComponent();
            if (!n.isPrimitive()) continue;
            if (n.getName().contains("graph")) {
                graph = PropertiesGUI.getGraphFromScriptFile();
                if (graph != null) {
                    h.put(n.getName(), graph);
                    continue;
                }
                h.put(n.getName(), "%graphscript");
                continue;
            }
            h.put(n.getName(), n.getValue());
        }
        return h;
    }

    public String getAsXML() {
        StringBuilder ret = new StringBuilder(8192);
        GetAsXMLVisitor v = new GetAsXMLVisitor();
        ret.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<PropertiesTreeModel xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"PropertiesTreeModel.xsd\">\n");
        ret.append(this.getRecurseXML((PropertiesTreeNode)this.getRoot(), v, 1));
        ret.append("</PropertiesTreeModel>");
        return ret.toString();
    }

    private String getRecurseXML(PropertiesTreeNode n, GetAsXMLVisitor v, int l) {
        if (n == null || n.isItem() || v == null) {
            return "";
        }
        int level = l;
        if (level < 0) {
            level = 0;
        }
        if (n.isProperty()) {
            return v.getPropertiesAsXML(n.getAnimationProperties(), level);
        }
        if (n.isPrimitive()) {
            return v.getPrimitiveAsXML(n.getName(), n.getValue(), level);
        }
        StringBuilder ret = new StringBuilder(8192);
        int i = 0;
        while (i < level) {
            ret.append("\t");
            ++i;
        }
        ret.append("<Folder name=\"");
        ret.append(GetAsXMLVisitor.replaceEntitiesForXML(n.getLabel()));
        ret.append("\">\n");
        int count = n.getChildCount();
        int newLevel = level + 1;
        int i2 = 0;
        while (i2 < count) {
            ret.append(this.getRecurseXML((PropertiesTreeNode)n.getChildAt(i2), v, newLevel));
            ++i2;
        }
        i2 = 0;
        while (i2 < level) {
            ret.append("\t");
            ++i2;
        }
        ret.append("</Folder>\n");
        return ret.toString();
    }

    public static String cleanString(String filename, String extension) {
        StringBuffer cleanName = new StringBuffer(filename.length());
        int i = 0;
        int start = 0;
        int endPos = filename.length() - extension.length() - 1;
        while (start < filename.length() && (i = filename.indexOf(46, start)) > -1) {
            cleanName.append(filename.substring(start, i));
            if (i < endPos) {
                cleanName.append('/');
            }
            start = i + 1;
        }
        cleanName.append('.').append(extension);
        return cleanName.toString();
    }

    public void loadFromXMLFile(String uri, boolean isRessourceFile) throws IllegalArgumentException {
        this.clear();
        if (uri == null || uri.length() == 0) {
            return;
        }
        InputStream isXML = null;
        String fname = PropertiesTreeModel.cleanString(uri, "xml");
        if (!isRessourceFile) {
            try {
                isXML = new FileInputStream(fname);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The File " + fname + "was not found!");
            }
        } else {
            isXML = this.getClass().getResourceAsStream("/" + fname);
        }
        if (isXML == null) {
            throw new IllegalArgumentException("Error reading XML-Ressource-File " + fname + "!");
        }
        InputStream isXSD = this.getClass().getResourceAsStream("/generator/properties/tree/PropertiesTreeModel.xsd");
        if (isXSD == null) {
            throw new IllegalArgumentException("Error reading XSD-File generator/properties/tree/PropertiesTreeModel.xsd!");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setIgnoringComments(true);
        try {
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            factory.setAttribute(JAXP_SCHEMA_SOURCE, isXSD);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error trying to validate the XML-File " + uri + ",\nyour Java XML Parser does not support" + " JAXP 1.2!");
        }
        LoadFromXMLVisitor v = new LoadFromXMLVisitor();
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(this);
            Document doc = parser.parse(isXML);
            Element r = null;
            r = doc.getDocumentElement();
            if (r == null) {
                throw new IllegalArgumentException("No Root Element was found!");
            }
            if (!r.getLocalName().equals("PropertiesTreeModel")) {
                throw new IllegalArgumentException("Root Element is not 'PropertiesTreeModel'!");
            }
            Node child = null;
            child = r.getFirstChild();
            while (child != null && child.getNodeType() == 3 && child.getLocalName() == null) {
                child = child.getNextSibling();
            }
            if (child == null) {
                throw new IllegalArgumentException("Root Folder wasn't found!");
            }
            if (!child.getLocalName().equals("Folder")) {
                throw new IllegalArgumentException("Root Folder wasn't found!");
            }
            this.loadXMLFolder((PropertiesTreeNode)this.getRoot(), child, v);
        }
        catch (ParserConfigurationException pce) {
            this.clear();
            throw new IllegalArgumentException("Parser-Setup: " + pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            this.clear();
            throw new IllegalArgumentException("I/O: " + ioe.getLocalizedMessage());
        }
        catch (SAXException saxe) {
            this.clear();
            throw new IllegalArgumentException(saxe.getLocalizedMessage());
        }
    }

    private void loadXMLFolder(PropertiesTreeNode n, Node c, LoadFromXMLVisitor v) {
        if (n == null || c == null || v == null) {
            return;
        }
        Node child = null;
        child = c.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3 && child.getLocalName() == null) {
                child = child.getNextSibling();
                continue;
            }
            if ("AnimationProperties".equals(child.getLocalName())) {
                AnimationProperties ap = v.loadPropsFromXML(child);
                if (ap != null) {
                    this.insertNodeInto(this.getNewNode(ap), n, n.getChildCount());
                }
            } else if ("Primitive".equals(child.getLocalName())) {
                PropertiesTreeNode primNode = v.loadPrimitiveFromXML(child);
                if (primNode != null) {
                    this.insertNodeInto(primNode, n, n.getChildCount());
                }
            } else if ("Folder".equals(child.getLocalName())) {
                NamedNodeMap attributes = child.getAttributes();
                if (attributes.getLength() != 1 && !attributes.item(0).getLocalName().equals("name")) {
                    throw new IllegalArgumentException("'Folder' needs a 'name' attribute!");
                }
                String name = attributes.item(0).getNodeValue();
                PropertiesTreeNode newN = new PropertiesTreeNode(name);
                this.insertNodeInto(newN, n, n.getChildCount());
                this.loadXMLFolder(newN, child, v);
            } else {
                throw new IllegalArgumentException("Child Element is not 'AnimationProperties' or 'Primitive' or 'Folder'!");
            }
            child = child.getNextSibling();
        }
    }

    public void clear() {
        PropertiesTreeNode r = (PropertiesTreeNode)this.getRoot();
        int i = r.getChildCount() - 1;
        while (i >= 0) {
            this.removeNodeFromParent((PropertiesTreeNode)r.getChildAt(i));
            --i;
        }
    }

    public PropertiesTreeNode getNewNode(AnimationProperties p) {
        if (p == null) {
            return null;
        }
        PropertiesTreeNode n = new PropertiesTreeNode(p);
        n.setShowHiddenItems(this.showHiddenItems);
        n.setShowItems(this.showItems);
        return n;
    }

    public void update() {
        Enumeration<TreeNode> e = ((PropertiesTreeNode)this.getRoot()).depthFirstEnumeration();
        while (e.hasMoreElements()) {
            PropertiesTreeNode n = (PropertiesTreeNode)e.nextElement();
            if (n.isItem()) continue;
            if (n.isFolder()) {
                this.nodeChanged(n);
                continue;
            }
            PropertiesTreeNode parent = (PropertiesTreeNode)n.getParent();
            int index = parent.getIndex(n);
            this.removeNodeFromParent(n);
            if (n.isPrimitive()) {
                this.insertNodeInto(new PropertiesTreeNode(n.getName(), n.getValue()), parent, index);
                continue;
            }
            this.insertNodeInto(this.getNewNode(n.getAnimationProperties()), parent, index);
        }
    }

    public int getElementsCount() {
        Enumeration<TreeNode> e = ((PropertiesTreeNode)this.getRoot()).depthFirstEnumeration();
        int count = 0;
        while (e.hasMoreElements()) {
            PropertiesTreeNode n = (PropertiesTreeNode)e.nextElement();
            if (!n.isProperty() && !n.isPrimitive()) continue;
            ++count;
        }
        return count;
    }

    public boolean getShowItems() {
        return this.showItems;
    }

    public void setShowItems(boolean b) {
        this.showItems = b;
        this.update();
    }

    public boolean getShowHiddenItems() {
        return this.showHiddenItems;
    }

    public void setShowHiddenItems(boolean b) {
        this.showHiddenItems = b;
        this.update();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

