/*
 * Decompiled with CFR 0.152.
 */
package generator;

import algoanim.properties.AnimationProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewPropertyTypeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3617291233572042806L;
    private JComboBox cmbTypes;
    private JTextField txtName;
    private String type;
    private String name;
    private boolean returnValue;

    public NewPropertyTypeDialog(JFrame parent) {
        super(parent, "New Property Type", true);
        JPanel border = new JPanel();
        border.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout(8, 8));
        this.getContentPane().add((Component)border, "Center");
        this.cmbTypes = new JComboBox<String>(AnimationProperties.getAllPropertyTypes());
        this.cmbTypes.setPreferredSize(new Dimension(250, this.cmbTypes.getMinimumSize().height));
        this.cmbTypes.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.cmbTypes.getMinimumSize().height));
        this.cmbTypes.setAlignmentX(0.0f);
        this.cmbTypes.setActionCommand("cmbTypes");
        this.cmbTypes.addActionListener(this);
        this.txtName = new JTextField();
        this.txtName.setText("");
        this.name = "";
        this.txtName.setPreferredSize(new Dimension(250, this.txtName.getMinimumSize().height));
        this.txtName.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.txtName.getMinimumSize().height));
        this.txtName.setAlignmentX(0.0f);
        border.setLayout(new BoxLayout(border, 3));
        JLabel lblType = new JLabel("Chose a Property Type:");
        border.add(lblType);
        border.add(Box.createRigidArea(new Dimension(0, 4)));
        border.add(this.cmbTypes);
        border.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel lblName = new JLabel("Enter a Name:");
        border.add(lblName);
        border.add(Box.createRigidArea(new Dimension(0, 4)));
        border.add(this.txtName);
        border.add(Box.createRigidArea(new Dimension(0, 16)));
        JPanel pBut = new JPanel();
        pBut.setLayout(new BoxLayout(pBut, 2));
        pBut.setAlignmentX(0.0f);
        pBut.add(Box.createHorizontalGlue());
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand("cancel");
        btnCancel.addActionListener(this);
        pBut.add(btnCancel);
        pBut.add(Box.createRigidArea(new Dimension(8, 0)));
        JButton btnOK = new JButton("OK");
        btnOK.setActionCommand("ok");
        btnOK.addActionListener(this);
        pBut.add(btnOK);
        border.add((Component)pBut, "South");
        this.getRootPane().setDefaultButton(btnOK);
        this.txtName.requestFocus();
        this.pack();
    }

    public boolean showDialog() {
        if (this.cmbTypes.getItemCount() > 0) {
            this.cmbTypes.setSelectedIndex(0);
        }
        this.returnValue = false;
        this.setVisible(true);
        return this.returnValue;
    }

    private static String createNameForProperty(String prop) {
        if (prop == null) {
            return "property";
        }
        String theProp = prop;
        if (theProp.length() > 10 && theProp.substring(theProp.length() - 10).equalsIgnoreCase("properties")) {
            theProp = theProp.substring(0, theProp.length() - 10);
        }
        if (theProp.length() > 0) {
            theProp = String.valueOf(theProp.toLowerCase().charAt(0)) + theProp.substring(1);
        }
        return theProp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("cmbTypes")) {
            JComboBox cb = (JComboBox)e.getSource();
            this.type = (String)cb.getSelectedItem();
            String newName = NewPropertyTypeDialog.createNameForProperty(this.type);
            this.txtName.setText(newName);
        }
        if (e.getActionCommand().equalsIgnoreCase("ok")) {
            this.returnValue = true;
            this.name = this.txtName.getText();
            this.setVisible(false);
        }
        if (e.getActionCommand().equalsIgnoreCase("cancel")) {
            this.returnValue = false;
            this.setVisible(false);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }
}

